{
  template:'${tmpl}',
  data:function(){
      return {
          windowHeight:'',
          loading:false,
          data:{},
          year:"",
          entName:"",
          patentInformationdata:{
            tooltip: {
                trigger: 'item',
                formatter: "{a} <br/>{b}: {c} ({d}%)"
            },
            color:['#6EB3EB','#786EEB','#FB6776','#E0B947','#01B787'],
            legend: {
                orient: 'vertical',
                x: 'left',
                data:['实用新型','外观设计','发明'],
                textStyle: {
                    color: '#666'
                },
            },
            series: [
                {
                    name:'',
                    type:'pie',
                    radius: ['50%', '70%'],
                    avoidLabelOverlap: false,
                    label: {
                        normal: {
                            show: false,
                            position: 'center'
                        },
                        emphasis: {
                            show: true,
                            textStyle: {
                                fontSize: '30',
                                fontWeight: 'bold'
                            }
                        }
                    },
                    labelLine: {
                        normal: {
                            show: false
                        }
                    },
                    data:[
                    ]
                }
            ]
          },
          trademarkInformationdata:{
            tooltip: {
                trigger: 'item',
                formatter: "{a} <br/>{b}: {c} ({d}%)"
            },
            color:['#6EB3EB','#786EEB','#FB6776','#E0B947','#01B787'],
            legend: {
                orient: 'vertical',
                x: 'left',
                data:['有效注册','申请中','无效','其他'],
                textStyle: {
                    color: '#666'
                },
            },
            series: [
                {
                    name:'',
                    type:'pie',
                    radius: ['50%', '70%'],
                    avoidLabelOverlap: false,
                    label: {
                        normal: {
                            show: false,
                            position: 'center'
                        },
                        emphasis: {
                            show: true,
                            textStyle: {
                                fontSize: '30',
                                fontWeight: 'bold'
                            }
                        }
                    },
                    labelLine: {
                        normal: {
                            show: false
                        }
                    },
                    data:[]
                }
            ]
          },
          trademarkGrowthdata:{
            grid: {
                top: '6%',
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: {
                type: 'category',
                boundaryGap: false,
                data: [],
                axisLine:{
                    lineStyle:{
                        color:'#AEAEAE'
                    }
                }
            },
            yAxis: {
                type: 'value',
                axisLine:{
                    lineStyle:{
                        color:'#AEAEAE'
                    }
                }
            },
            series: [{
                color:['#008AFF'],
                data: [],
                type: 'line',
                areaStyle: {}
            }]
          },
          patentTrendsdata:{
            grid: {
                top: '6%',
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: {
                type: 'category',
                boundaryGap: false,
                data: [],
                axisLine:{
                    lineStyle:{
                        color:'#AEAEAE'
                    }
                }
            },
            yAxis: {
                type: 'value',
                axisLine:{
                    lineStyle:{
                        color:'#AEAEAE'
                    }
                }
            },
            series: [{
                color:['#008AFF'],
                data: [],
                type: 'line',
                areaStyle: {}
            }]
          },
          patentMainWordsEchartdata:{
              series: [{
                  name: '企业专利',
                  type: 'wordCloud',
                  size: ['100%', '100%'],
                  sizeRange: [12, 32],
                  textRotation : [-45, 0, 45, 90],
                  textPadding: 0,
                  textStyle: {
                      normal: {
                          color: function() {
                              return 'rgb(' +
                                      Math.round(Math.random() * 255) +
                                      ', ' + Math.round(Math.random() * 255) +
                                      ', ' + Math.round(Math.random() * 255) + ')'
                          }
                      }
                  },
                  data: [
                   
                  ]
              }]
          },
          /* */
          enterprisePatentEchartdata:{
              tooltip: {
                  trigger: 'item',
                  formatter: "{a} <br/>{b}: {c} ({d}%)"
              },
              grid: {
                  top:'5%',
                  left: '3%',
                  right: '4%',
                  bottom: '8%',
                  containLabel: true
              },
              legend: {
                  orient: 'vertical',
                  default: '#fff',
                  x: 'left',
                  data:[{name:'发明专利',textStyle: {color: '#fff'}},{name:'实用新型专利',textStyle: {color: '#fff'}},{name:'外观专利',textStyle: {color: '#fff'}}]
              },
              color:['#A859FF','#FF9745','#34ABFF'],

              series: [
                  {
                      name:'专利类型',
                      type:'pie',
                      radius: ['50%', '70%'],
                      avoidLabelOverlap: false,
                      label: {
                          normal: {
                              show: false,
                              position: 'center'
                          },
                          emphasis: {
                              show: true,
                              textStyle: {
                                  fontSize: '14',
                                  fontWeight: 'bold'
                              }
                          }
                      },
                      labelLine: {
                          normal: {
                              show: false
                          }
                      },
                      data:[
                         
                      ]
                  }
              ]
          },
          option:{
                tooltip: {
                    trigger: 'axis'
                },
                radar: [
                    {   
                        name:{
                            show: true,
                            formatter: null,
                            textStyle: {
                                color:'#000000'
                            }
                        },
                        indicator: [
                            {text: '财务状况', max: 100},
                            {text: '企业信用', max: 100},
                            {text: '影响力', max: 100},
                            {text: '知识产权', max: 100},
                            {text: '人力资源', max: 100}
                        ],
                        center: ['50%','52%'],
                        radius: 80
                    }
                ],
                series: [
                    {
                        type: 'radar',
                        tooltip: {
                            trigger: 'item'
                        },
                        itemStyle: {normal: {
                            color : "#1890FF",
                            lineStyle: {
                                color:"#1890FF"
                            },
                            areaStyle: {type: 'default'}
                        }},
                        data: []
                    },
                ]
            },
        tmstatuscountArr:[],
        patentInformationArr:[],
        trademarkGrowthArr:[],
        basicInformationArr:[],
        cellPhone: null,
        visitcount: 0

      }
  },
  created(){
      $('#header').hide();
      /** this.showLoading();*/
      
      this.entName=this.$router.history.current.query.entName || "";
      this.year=this.$router.history.current.query.year || "";
      this.cellPhone = this.$router.history.current.query.shouji || "";
      var taht = this;
      taht.windowHeight = 'height:' + document.documentElement.clientHeight + 'px';  
      window.addEventListener("resize",function(){
        taht.windowHeight = 'height:' + document.documentElement.clientHeight + 'px';  
      });
      
      console.log(document.documentElement.clientHeight,'高度');
      /*if(!this.entName){
          this.$root.pushx(
              { name:'/businessdecisions',title:"企业决策"}
          );
          return ;
      }*/
      this.basicInformationArr = this.$router.history.current.query.obj;
      
      this.aliBusinessDecision(this.$router.history.current.query.obj);
  },
  mounted:function(){
    /*var data1=this.$refs.echarts.getEchartObj();
    function sum (m,n){
    　var num = Math.floor(Math.random()*(m - n) + n);
      return num
    };
    var option = data1.getOption();
    option.series[0].data = [{ value: [sum(70,90),sum(30,70),sum(20,50),sum(30,60),sum(20,80)], name: '名称' }];
    console.log(option.series[0].data,'111111111111111');
    data1.setOption(option);*/
      
  },
  methods:{
    createRandomItemStyle() {
        return {
            normal: {
                color: 'rgb(' + [
                    Math.round(Math.random() * 160),
                    Math.round(Math.random() * 160),
                    Math.round(Math.random() * 160)
                ].join(',') + ')'
            }
        };
    },
      fanhui () {
          this.$root.pushx({
              name:"/"
          });
          $('#header').show();
      },
      showLoading(){
          var that=this;
          this.loading = true;
          setTimeout(()=>{
              that.loading = false;
          },3000);
      },
      yearChange(){
          /** this.showLoading();*/
          console.log(this.year);
          this.aliBusinessDecision();
      },
      aliBusinessDecision(obj){
          console.log(obj);
          var that = this;
          this.$root.postReq("/web/companyportraitCtl/companynamequery",obj).then(d=>{
              if(d && d.status==0){
                  this.visitcount = d.data.visitcount;
                  console.log(d,'/////////////////////////////////////');
                  var echarts = that.$refs.trademarkInformation.getEchartObj();
                  var arr =[];
                  this.tmstatuscountArr = d.data.tmstatuscount;
                  for (let i = 0; i < d.data.tmstatuscount.length; i++) {
                    var obj = {
                        value: d.data.tmstatuscount[i].value,
                        name: d.data.tmstatuscount[i].key
                    };
                    arr.push(obj)
                  };
                  that.trademarkInformationdata.series[0].data = arr;
                  echarts.setOption(that.trademarkInformationdata);
                  window.addEventListener("resize",function(){
                      echarts.resize();
                  });
                  that.$forceUpdate();
                  /* 2 */
                  that.patentInformationArr = d.data.patenttypestatus;
                  var echarts1 = that.$refs.patentInformation.getEchartObj();
                  var arr1 =[];
                  for (let i = 0; i < d.data.patenttypestatus.length; i++) {
                    var obj1 = {
                        value: d.data.patenttypestatus[i].value,
                        name: d.data.patenttypestatus[i].typename
                    };
                    arr1.push(obj1)
                  };
                  that.patentInformationdata.series[0].data = arr1;
                  echarts1.setOption(that.patentInformationdata);
                  window.addEventListener("resize",function(){
                      echarts1.resize();
                  });
                  that.$forceUpdate();
                  /* 3 */
                  var echarts2 = that.$refs.trademarkGrowth.getEchartObj();
                  var arr21 =[];
                  var arr22 =[];
                  for (let i = 0; i < d.data.tmyearcount.length; i++) {
                    arr21.push(d.data.tmyearcount[i].key);
                    arr22.push(d.data.tmyearcount[i].value);
                  };
                  that.trademarkGrowthdata.xAxis.data = arr21;
                  that.trademarkGrowthdata.series[0].data = arr22;
                  echarts2.setOption(that.trademarkGrowthdata);
                  window.addEventListener("resize",function(){
                      echarts2.resize();
                  });
                  that.$forceUpdate();
                  /* 4 */
                  var echarts3 = that.$refs.patentTrends.getEchartObj();
                  var arr31 =[];
                  var arr32 =[];
                  for (let i = 0; i < d.data.patentgrstatus.length; i++) {
                    arr31.push(d.data.patentgrstatus[i].data);
                    arr32.push(d.data.patentgrstatus[i].value);
                  };
                  that.patentTrendsdata.xAxis.data = arr31;
                  that.patentTrendsdata.series[0].data = arr32;
                  echarts3.setOption(that.patentTrendsdata);
                  window.addEventListener("resize",function(){
                      echarts3.resize();
                  });
                  that.$forceUpdate();
                  /* 5 */
                  var echarts4 = that.$refs.patentMainWordsRef.getEchartObj();
                  var arr4 =[];
                  for (let i = 0; i < d.data.wordcloud.length; i++) {
                    var obj4 = {
                        name: d.data.wordcloud[i].name,
                        value: d.data.wordcloud[i].value,
                        itemStyle: that.createRandomItemStyle()
                    };
                    arr4.push(obj4)
                  };
                  that.patentMainWordsEchartdata.series[0].data= arr4;
                  echarts4.setOption(that.patentMainWordsEchartdata);
                  window.addEventListener("resize",function(){
                      echarts4.resize();
                  });
                  that.$forceUpdate();
                  /* 6 */
                  var echarts5=this.$refs.echarts.getEchartObj();
                  var option = echarts5.getOption();
                  option.series[0].data = [{ value: d.data.radarmap, name: '名称' }];
                  echarts5.setOption(option);
              }
          }).catch(e=>{
          })
      },
      initParams(){
          var data = this.data;
          console.log(data);
          if(data){
              var cped = data.profile;
              if(cped){
                  companyPatentEchartdata_x = ["总量","公开量","有效量","无效量"];
                  companyPatentEchartdata_y =[cped.sum ,cped.pubnum,cped.validnum,cped.unvalidnum];
                  var echarts = this.$refs.companyPatentRef.getEchartObj();
                  this.companyPatentEchartdata.xAxis.data =companyPatentEchartdata_x;
                  this.companyPatentEchartdata.series[1].data = companyPatentEchartdata_y;
                  echarts.setOption(this.companyPatentEchartdata);
                  window.addEventListener("resize",function(){
                      echarts.resize();
                  });
                  this.$forceUpdate();
              }
              if(data.title){
                  
                  this.patentMainWordsEchartdata.series[0].data=data.title;
                  var echarts2 = this.$refs.patentMainWordsRef.getEchartObj();
                  echarts2.setOption(this.patentMainWordsEchartdata);
                  window.addEventListener("resize",function(){
                      echarts2.resize();
                  });
                  this.$forceUpdate();
              }
              
              if(data.statestatistic && data.statestatistic.length>0){
                  var x=[];
                  var y=[];
                  for(var i=0;i<data.statestatistic.length;i++){
                      var o=data.statestatistic[i];
                      x.push(o.statename);
                      y.push(o.value);
                  }
                  var echarts3 = this.$refs.companyPatentStatusRef.getEchartObj();
                  this.companyPatentStatusEchartdata.xAxis[0].data=x;
                  this.companyPatentStatusEchartdata.series[0].data=y;
                  echarts3.setOption(this.companyPatentStatusEchartdata);
                  window.addEventListener("resize",function(){
                      echarts3.resize();
                  });
                  this.$forceUpdate();
              }
              if(data.applytrend){
                  var x=[];
                  var y1=[];
                  var y2=[];
                  for(var i=0;i<data.applytrend.apply.length;i++){
                      var o=data.applytrend.apply[i];
                      var o2 = data.applytrend.empower[i];
                      x.push(o.data);
                      y1.push(o.value);
                      y2.push(o2.value);
                  }
                  var echarts4 = this.$refs.patentApplyRef.getEchartObj();
                  this.patentApplyEchartdata.xAxis[0].data=x;
                  this.patentApplyEchartdata.series[0].data=y1;
                  this.patentApplyEchartdata.series[1].data=y2;
                  echarts4.setOption(this.patentApplyEchartdata);
                  window.addEventListener("resize",function(){
                      echarts4.resize();
                  });
                  this.$forceUpdate();
              }
              if(data.typestatistic && data.typestatistic.length>0){
                  var ddd=[];
                  for(var i=0;i<data.typestatistic.length;i++){
                      var o=data.typestatistic[i];
                      var obj={name:o.typename,value:o.value};
                      ddd.push(obj);
                  }
                  var echarts5 = this.$refs.enterprisePatentRef.getEchartObj();
                  this.enterprisePatentEchartdata.series[0].data=ddd;
                  var this_ = this;
                  this_.enterprisePatentEchartdata.legend.data = [];
                  ddd.forEach(row =>{
                      var map = {};
                      map['name'] = row.name;
                      map['textStyle'] = {color: '#fff'};
                      this_.enterprisePatentEchartdata.legend.data.push(map);
                  });
                  echarts5.setOption(this.enterprisePatentEchartdata);
                  window.addEventListener("resize",function(){
                      echarts5.resize();
                  });
                  this.$forceUpdate();
              }
              if(data.ipc && data.ipc.length>0){
                  var x=[];
                  var y=[];
                  for(var i=0;i<data.ipc.length;i++){
                      var o=data.ipc[i];
                      x.push(o.code);
                      y.push(o.num);
                  }
                  var echarts6 = this.$refs.patentTechnologyRef.getEchartObj();
                  this.patentTechnologyEchartdata.xAxis[0].data=x;
                  this.patentTechnologyEchartdata.series[0].data=y;
                  echarts6.setOption(this.patentTechnologyEchartdata);
                  window.addEventListener("resize",function(){
                      echarts6.resize();
                  });
                  this.$forceUpdate();
              }

              if(data.distribution && data.distribution.length>0){
                  var patentIndustryEchartdata = [];
                  for(var i=0;i<data.distribution.length;i++){
                      var patentIndustryEchartObj={name:data.distribution[i].industryname,value:data.distribution[i].value};
                      patentIndustryEchartdata.push(patentIndustryEchartObj);
                  }
                  var echarts7 = this.$refs.patentIndustryRef.getEchartObj();
                  this.patentIndustryEchartdata.series[0].data=patentIndustryEchartdata;
                  echarts7.setOption(this.patentIndustryEchartdata);
                  window.addEventListener("resize",function(){
                      echarts7.resize();
                  });
                  this.$forceUpdate();
              }
              
          }
      }
  },
  vname:"gsb-entdrawing"
}
  