{
  template: '${tmpl}',
    data: function() {
      var that = this;
      var validateMethod = function (rule, value, callback) {
        if (rule.field == "customerMobile") {
          if (/^1[23456789]\d{9}$/.test(value) == false) {
            return callback(new Error("请输入正确格式的手机号"));
          } else {
            return callback();
          }
        }
        return callback();
      };
      var validateTmname = (rule, value, callback) => {
        console.log(this.itemtype);
        console.log(value);
        if (this.itemtype == "ip" && value === "") {
          return callback(new Error('请输入商标名称'));
        } else {
          return callback();
        }
      };
      var validateApplynum = (rule, value, callback) => {
        console.log(this.itemtype);
        console.log(value);
        if (this.itemtype == "ip" && value === "") {
          return callback(new Error('请输入商标申请号'));
        } else {
          return callback();
        }
      };
      return {
        orderCode:"",
        order:{},
        serviceitem:{},
        tm:{},
        form:{
          totalSum:0,
          totalServiceCharge:0,
          totalPublicExpense:0,
          totalDiscounts:0,
          totalTaxes:0,
          totalProfitSum:0,

          serviceCharge:0,
          totalDiscountsRate:0,
          invoiceTaxRate:0,
          sveItemRateConfig:0,
          publicExpense:0,
        },
        apply:{
          customerName:"",
          customerMobile:"",
          customerEmail:""
        },
        id:"",
        sveItemCode:"",
        key:"",
        applyRules:{
          customerName: [
            { required: true, message: '请输入客户姓名', trigger: 'blur' }
          ],
          customerMobile: [
            { required: true, message: '请输入客户电话', trigger: 'blur' },
            { validator: validateMethod, trigger: 'blur' },
          ],
          customerEmail: [
            { required: true, message: '请输入客户邮箱', trigger: 'blur' }
          ],
          totalSum:[
            { required: true, message: '请输入订单金额', trigger: 'blur' }
          ]
        },
      }
    },
  mounted: function() {

  },
  created: function() {
    var id=this.$router.history.current.query.id;
    var sveItemCode=this.$router.history.current.query.sve_item_code;
    var key = this.$router.history.current.query.key;
    var orderCode = this.$router.history.current.query.orderCode;
    if((!id && !orderCode) || !sveItemCode || !key){
      this.$message.warning("参数错误");
      this.$root.pushx({
        title:"我的商机",
        name:"/mybusiness"
      });
      return;
    }else{
      this.id=id || "";
      this.orderCode=orderCode || "";
      this.sveItemCode=sveItemCode;
      this.key=key;
    }
    if(this.key!="edit"){
      this.getItemInfo();
    }
    this.getBusinessInfo();
  },
  methods: {
    getOrderInfo(){
      var code = this.orderCode;
      var that=this;
      if(!code){
        this.$message.warning("订单编码错误");
        this.$root.pushx({
          title:"我的商机",
          name:"/mybusiness"
        });
        return;
      }
      this.$root.postReq("/web/orderCtl/findOne",{code:code}).then(function(d){
        if(d && d.code==1){
          console.log("AAAAAAAAAAAAAAAAAAAAAAAad.data");
          console.log(d.data);
          that.order = d.data;
          var serviceitem = d.data.serviceItemSnapshot || null;
          if(that.key=="edit" && serviceitem){
            that.serviceitem=JSON.parse(serviceitem);
            that.form.totalSum = d.data.totalSum;
            that.form.serviceCharge = that.serviceitem.serviceCharge || 0;
            that.form.totalDiscountsRate = that.serviceitem.discountsRateConfig || 0;
            that.form.invoiceTaxRate=that.serviceitem.rateConfig || 0;
            that.form.sveItemRateConfig = that.serviceitem.rateConfig || 0;
            that.form.publicExpense =that.serviceitem.publicExpense || 0;
            that.apply.customerName = d.data.contacts;
            that.apply.customerMobile = d.data.mobile;
            that.apply.customerEmail = d.data.email;
            that.updatePrice();
          }
        }else{
          that.$message.warning(d.msg);
        }
      }).catch(function(e){
        console.log(e);
        that.$message.warning("获取商标信息失败");
      })
    },
    getBusinessInfo(){
      var that = this;
      var id = this.id;
      var orderCode = this.orderCode;
      if(id || (orderCode && this.key=="edit") ){
        var obj={id:id};
        if(orderCode && this.key=="edit"){
          obj={sourceOrderCode:orderCode};
        }
        this.$root.postReq("/web/businessinfoCtl/findOne",obj).then(function(d){
          console.log(12345);
          console.log(d);
          if(d && d.status==0 && d.data){
            that.tm = d.data;
            if(that.key=="detail"){
              that.orderCode = d.data.sourceOrderCode ||"";
              that.getOrderInfo();
            }
            if(that.key=="edit"){
              that.getOrderInfo();
            }
          }else{
            that.$message.warning(d.msg);
          }
        }).catch(function(e){
          console.log(e);
          that.$message.warning("获取商标信息失败");
        })
      }

    },
    getItemInfo(){
      var that = this;
      var itemCode = this.sveItemCode;
      if(itemCode){
        this.$root.getReq("/web/serviceitemCtl/findOneByCode",{code:itemCode}).then(function(d){
          if(d && d.code==1 && d.data.isPubed){
            var data = d.data;
            that.serviceitem = data;
            that.form.totalSum = data.price;
            that.form.serviceCharge = data.serviceCharge || 0;
            that.form.totalDiscountsRate = data.discountsRateConfig || 0;
            that.form.invoiceTaxRate=data.rateConfig || 0;
            that.form.sveItemRateConfig = data.rateConfig || 0;
            that.form.publicExpense =data.publicExpense || 0;
            that.updatePrice();
          }else{
            that.$message.warning(d.msg);
          }
        }).catch(function(e){
          console.log(e);
          that.$message.warning("获取产品失败");
        })
      }
      
    },
    updatePrice(){
      var totalSum=Number(this.form.totalSum);
      var invoiceTaxRate = Number(this.serviceitem.rateConfig || 0 );
      var totalDiscountsRate = Number(this.serviceitem.discountsRateConfig || 0);
      var totalServiceCharge = Number(this.serviceitem.serviceCharge || 0);
      var price = Number(this.serviceitem.price || 0);
      var shui = 0;
      var totalPublicExpense=this.serviceitem.publicExpense || 0;
      totalPublicExpense = Number(totalPublicExpense);
      var maxTotalDiscounts = Number(price)*Number(totalDiscountsRate)/100;
      maxTotalDiscounts =Number(maxTotalDiscounts.toFixed(2));
      var minSum = Number(totalServiceCharge)+Number(totalPublicExpense)-Number(maxTotalDiscounts);
      minSum = minSum.toFixed(2);
      minSum = Number(minSum);
      var totalTaxes = totalSum/(1+invoiceTaxRate/100)*invoiceTaxRate/100;
      totalTaxes=totalTaxes.toFixed(2);
      var totalDiscounts = 0;
      if(Number(totalSum)<(Number(totalServiceCharge)+Number(totalPublicExpense))){
        totalDiscounts = Number(totalServiceCharge)+Number(totalPublicExpense) - Number(totalSum);
        totalDiscounts = Number(totalDiscounts.toFixed(2));
      }
      var totalProfitSum = Number(totalSum) - Number(totalPublicExpense);
      totalProfitSum = totalProfitSum.toFixed(2);
      this.form.totalSum = totalSum;
      this.form.totalServiceCharge = totalServiceCharge;
      this.form.totalPublicExpense = totalPublicExpense;
      this.form.totalDiscounts = totalDiscounts;
      this.form.totalTaxes = totalTaxes;
      this.form.totalProfitSum = totalProfitSum;
    },
    validPrice(){
      var totalSum=Number(this.form.totalSum);
      var invoiceTaxRate = Number(this.serviceitem.rateConfig || 0 );
      var totalDiscountsRate = Number(this.serviceitem.discountsRateConfig || 0);
      var totalServiceCharge = Number(this.serviceitem.serviceCharge || 0);
      var price = Number(this.serviceitem.price || 0);
      var shui = 0;
      var totalPublicExpense=this.serviceitem.publicExpense || 0;
      totalPublicExpense = Number(totalPublicExpense);
      var maxTotalDiscounts = Number(price)*Number(totalDiscountsRate)/100;
      maxTotalDiscounts =Number(maxTotalDiscounts.toFixed(2));
      var minSum = Number(totalServiceCharge)+Number(totalPublicExpense)-Number(maxTotalDiscounts);
      minSum = minSum.toFixed(2);
      minSum = Number(minSum);
      var totalTaxes = totalSum/(1+invoiceTaxRate/100)*invoiceTaxRate/100;
      totalTaxes=totalTaxes.toFixed(2);
      var totalDiscounts = 0;
      if(Number(totalSum)<(Number(totalServiceCharge)+Number(totalPublicExpense))){
        totalDiscounts = Number(totalServiceCharge)+Number(totalPublicExpense) - Number(totalSum);
        totalDiscounts = Number(totalDiscounts.toFixed(2));
      }
      var totalProfitSum = Number(totalSum) - Number(totalPublicExpense);
      totalProfitSum = totalProfitSum.toFixed(2);
      this.form.totalSum = totalSum;
      this.form.totalServiceCharge = totalServiceCharge;
      this.form.totalPublicExpense = totalPublicExpense;
      this.form.totalDiscounts = totalDiscounts;
      this.form.totalTaxes = totalTaxes;
      this.form.totalProfitSum = totalProfitSum;
      if(!this.serviceitem || !this.serviceitem.price){
        this.$message.warning('获取产品信息错误');
        return false;
      }
      if(totalSum<minSum){
        this.$message.warning('订单金额不足');
        return false;
      }
      if(totalDiscounts>maxTotalDiscounts){
        this.$message.warning('优惠金额超过最大额度');
        return false;
      }
      return true;
    },
    editOrder(){
      var that = this;
      var params = {
        orderNum:this.orderCode,
        tm: {
          totalPublicExpense: this.form.totalPublicExpense,
          totalTaxes: this.form.totalTaxes,
          totalSum: this.form.totalSum,
          totalDiscounts: this.form.totalDiscounts,
          totalServiceCharge: this.form.totalServiceCharge,
          totalProfitSum: this.form.totalProfitSum,
        },
        apply: {
          contacts: this.apply.customerName,
          mobile: this.apply.customerMobile,
          email: this.apply.customerEmail
        },
      };
      that.$refs.form.validate(valid => {
        if (valid) {
          that.$refs.apply.validate(valid => {
            if (valid) {
              var flag = that.validPrice();
              if (flag) {
                console.log("--------true--------");
                this.$root.postReq("/web/orderCtl/updatePtsjOrder", params).then(function (d) {
                  console.log("---------submitOrder-------");
                  console.log(d);
                  if(d.code==1){
                    that.$message.success('修改成功');
                    that.getBusinessInfo();
                  }
                })
              } else {
                console.log("---------false---------");
                return;
              }
            }
          });
        }
      });
    },
    submitOrder(){
      var that = this;
      var params = {
        itemCode: this.sveItemCode,
        orderSource:"ptsj",
        bus_id:this.tm.id,
        tm_company_type:this.tm.tm_company_type,
        sourceOrderNo:this.tm.sourceCode,
        tm: {
          nclOneCodes:this.tm.ncl_one_codes,
          name: this.tm.tm_name,
          tmApplyNum: this.tm.tm_regist_num,
          totalPublicExpense: this.form.totalPublicExpense,
          totalTaxes: this.form.totalTaxes,
          totalSum: this.form.totalSum,
          totalDiscounts: this.form.totalDiscounts,
          totalServiceCharge: this.form.totalServiceCharge,
          totalProfitSum: this.form.totalProfitSum,
        },
        apply: {
          contacts: this.apply.customerName,
          mobile: this.apply.customerMobile,
          email: this.apply.customerEmail,
          notes: "",
        },
      };
      that.$refs.form.validate(valid => {
        if (valid) {
          that.$refs.apply.validate(valid => {
            if (valid) {
              var flag = that.validPrice();
              if (flag) {
                console.log("--------true--------");
                this.$root.postReq("/web/orderCtl/createOtherOrder", params).then(function (d) {
                  console.log("---------submitOrder-------");
                  console.log(d);
                  if(d.code==1){
                    that.$root.pushx({
                      title:"订单支付",
                      name:"/orderpay",
                      params:{orderNum:d.data.code}
                    });
                  }
                })
              } else {
                console.log("---------false---------");
                return;
              }
            }
          });
        }
      });
    },



  },
  computed: Vuex.mapState({

  }),
    vname: "gsb_businesstmorder"
}
