const system=require("../../system");
const ServiceBase=require("../sve.base");
const logCtl = system.getObject("web.oplogCtl");
class WxuserService extends ServiceBase{
    constructor(){
        super(ServiceBase.getDaoName(WxuserService));
        this.newschannelDao=system.getObject("db.newschannelDao");
        this.userDao = system.getObject("db.userDao");
    }
    async editWxUserInfo(obj){//订阅公众号时执行 --- 订阅公众号存在company_id参数
        if(!obj.openid){
            return {code:-100,msg:"openid参数错误"};
        }
        if(!obj.company_id){
            return {code:-101,msg:"company_id参数错误"};
        }
        var wxuser = await this.dao.model.findOne({where:{openid:obj.openid},raw:true});
        var that = this;
        await this.db.transaction(async function (t) {
            if(wxuser){
                await that.dao.model.update(obj,{where:{openid:obj.openid}, transaction: t});
                wxuser=obj;
            }else{
                wxuser = await that.dao.create(obj,t);
            }
            if(obj.mobile){
                var user = await that.userDao.model.findOne({
                    where:{company_id:obj.company_id,
                        [that.db.Op.or]: [{ mobile: obj.mobile }, { userName: obj.mobile }] 
                    },
                    raw:true
                });
                if(user){
                    await that.userDao.model.update({notifyOpenId:obj.openid},{where:{id:user.id}, transaction: t});
                }else{
                    var userobj={
                        userName: obj.mobile,
                        password: "7c8712d838190c3fdc6305aa7584bc98",
                        nickName: obj.nick_name,
                        headUrl: obj.head_img,
                        mobile: obj.mobile,
                        notifyOpenId: obj.openid,
                        company_id:obj.company_id,
                    };
                    logCtl.info({
                        optitle: "wxop微信开放平台 editWxUserInfo userobj2",
                        op: "/base/service/impl/WxuserService/editWxUserInfo",
                        content: JSON.stringify(userobj) ,
                        clientIp: ""
                      });
                    await that.userDao.create(userobj,t);
                }
            }
        });
        return {code:1};
        
    }
    

    async editWxUserInfo2(obj){//取消订阅公众号时执行 --- 无company_id参数
        if(!obj.openid){
            return {code:-100,msg:"openid参数错误"};
        }
        var wxuser = await this.dao.model.findOne({where:{openid:obj.openid},raw:true});
        var that = this;
        await this.db.transaction(async function (t) {
            if(wxuser){
                await that.dao.model.update(obj,{where:{openid:obj.openid}, transaction: t});
                wxuser=obj;
            }else{
                wxuser = await that.dao.create(obj,t);
            }
        });
        return {code:1};
        
    }

    async getWxUser(obj){//获取用户 
        var wxuser = await this.dao.model.findOne({
            where:{appid:obj.appid,openid:obj.openid},
            attributes: ["appid", "id", "openid","nick_name", "head_img","subscribe_status","subscribe_status_name"],
            raw:true
        });
        return wxuser;
    }
    //使user与wxuser相关联
    async connectUser(obj){
        var that = this;
        var mobile = obj.mobile;
        var wxuser = obj.wxuser;
        var company_id = obj.company_id;
        if(!mobile){
            return {code:-1,msg:"mobile参数错误"}
        }
        if(!wxuser || !wxuser.openid){
            return {code:-2,msg:"wxuser参数错误"}
        }
        if(!company_id){
            return {code:-3,msg:"未知的企业id"}
        }
        var user = await this.userDao.model.findOne({
            where:{company_id:company_id,
                [this.db.Op.or]: [{ mobile:mobile }, { userName: mobile }] 
            },
            raw:true
        });
        if(user){
            await this.userDao.model.update({bindOpenId:wxuser.openid,notifyOpenId:wxuser.openid},{
                where:{
                    company_id:company_id,
                    [this.db.Op.or]: [{ mobile:mobile }, { userName: mobile }] 
                 }
            });
        }else{
            var userobj={
                userName: mobile,
                password: "7c8712d838190c3fdc6305aa7584bc98",
                nickName: wxuser.nick_name,
                headUrl: wxuser.head_img,
                mobile: mobile,
                bindOpenId: wxuser.openid,
                notifyOpenId:wxuser.openid,
                company_id:company_id,
            };
            logCtl.info({
                optitle: "wxop微信开放平台 editWxUserInfo userobj3",
                op: "/base/service/impl/WxuserService/connectUser",
                content: JSON.stringify(userobj) ,
                clientIp: ""
              });
            var user2 = await that.userDao.create(userobj);
            // return {code:1,data:user2};
        }
        var user2 = await this.userDao.model.findOne({
            where:{company_id:company_id,
                [this.db.Op.or]: [{ mobile:mobile }, { userName: mobile }] 
            },
            attributes: ["userName", "id", "nickName", "headUrl", "mobile","company_id","bindOpenId"],
            raw:true
        });
        return {code:1,data:user2};

    }
    //关注公众号时 编辑微信用户
    async subscribeEditWxUser(obj){
        if(!obj.openid){
            return {code:-100,msg:"openid参数错误"};
        }
        if(!obj.appid){
            return {code:-101,msg:"appid参数错误"};
        }
        var wxuser = await this.dao.model.findOne({where:{openid:obj.openid,appid:obj.appid},raw:true});
        var that = this;
        await this.db.transaction(async function (t) {
            if(wxuser){
                await that.dao.model.update(obj,{where:{openid:obj.openid,appid:obj.appid}, transaction: t});
                wxuser=obj;
            }else{
                wxuser = await that.dao.create(obj,t);
            }
            if(obj.mobile && obj.company_id){
                var user = await that.userDao.model.findOne({
                    where:{company_id:obj.company_id,
                        [that.db.Op.or]: [{ mobile: obj.mobile }, { userName: obj.mobile }] 
                    },
                    raw:true
                });
                if(user){
                    await that.userDao.model.update({notifyOpenId:obj.openid},{where:{id:user.id}, transaction: t});
                }else{
                    var userobj={
                        userName: obj.mobile,
                        password: "7c8712d838190c3fdc6305aa7584bc98",
                        nickName: obj.nick_name,
                        headUrl: obj.head_img,
                        mobile: obj.mobile,
                        notifyOpenId: obj.openid,
                        company_id:obj.company_id,
                    };
                    await that.userDao.create(userobj,t);
                }
            }
        });
        return {code:1};
        
    }
    //取消关注公众号时 编辑微信用户
    async unsubscribeEditWxUser(obj){
        if(!obj.openid){
            return {code:-100,msg:"openid参数错误"};
        }
        if(!obj.appid){
            return {code:-101,msg:"appid参数错误"};
        }
        var wxuser = await this.dao.model.findOne({where:{openid:obj.openid,appid:obj.appid},raw:true});
        var that = this;
        await this.db.transaction(async function (t) {
            if(wxuser){
                await that.dao.model.update(obj,{where:{openid:obj.openid}, transaction: t});
                wxuser=obj;
            }else{
                wxuser = await that.dao.create(obj,t);
            }
        });
        return {code:1};
    }

}
module.exports=WxuserService;
// var task = new WxuserService();
// var obj={
//     "appid":"wx5411ca0e225f2772","openid":"oV9ul1QPnHDDxLbKwPBuz9vapQuw","nick_name":"庄冰",
//     "head_img":"http://thirdwx.qlogo.cn/mmopen/xJoVRZvaBAfpOWjzsBmtKMtmQbIwcxSU0guYODhSf8KiaacQGILo9eEuqdDiaiciaTZic4YicOh0U9h0iadzTAUl7EG4Gy3xLpSY8f0/132",
//     "mobile":"13075556693","sex":1,"country":"中国","province":"江苏","language":"zh_CN","subscribe_status":"subscribe",
//     "company_id":"4"};
// task.editWxUserInfo(obj).then(d=>{
//     console.log("dddddddddddddddddddddddddddd");
//     console.log(d);
// })
