const system=require("../../system");
const ServiceBase=require("../sve.base");
class WxappService extends ServiceBase{
    constructor(){
        super(ServiceBase.getDaoName(WxappService));
        this.newschannelDao=system.getObject("db.newschannelDao");
        this.companyDao = system.getObject("db.companyDao");
    }
    /**
     * 关注公众号触发 创建/更新微信app信息
     */
    async createOrUpdateAppInfo(obj){
        var appid = obj.appid;
        var company_id = obj.company_id;
        if(!appid){
            return {code:-1,msg:"appid参数错误"};
        }
        if(!company_id){
            return {code:-2,msg:"company_id参数错误"};
        }
        var wxapp = await this.dao.model.findOne({where:{appid:appid},raw:true});
        var that = this;
        return this.db.transaction(async function (t) {
            if(wxapp){//更新wxapp
                if(wxapp.authorized_status=="authorized" && company_id !=wxapp.company_id){
                    return {code:-3,msg:"操作失败，该公众号已绑定其它站点"};
                }else{
                    await that.dao.model.update(obj,{where:{appid:appid,company_id:company_id},transaction:t});
                }
            }else{//创建wxapp
                // if(obj.authorized_status && obj.authorized_status=="authorized"){
                //     var app = await that.dao.create(obj,t);
                // }
                var app = await that.dao.create(obj,t);   

            }
            // if(obj.authorized_status && obj.authorized_status=="authorized"){//授权
            //     var company = await that.companyDao.model.findOne({where:{id:company_id,isEnabled:true},raw:true});
            //     if(company){
            //         await that.companyDao.model.update({appid:appid},{where:{id:company_id,isEnabled:true},transaction:t});
            //     }
            // }else{
            //     if(obj.authorized_status && obj.authorized_status=="unauthorized"){//取消授权
            //         await that.companyDao.model.update({appid:""},{where:{appid:appid},transaction:t});
            //     } 
            // }
            var company = await that.companyDao.model.findOne({where:{id:company_id,isEnabled:true},raw:true});
            if(company){
                await that.companyDao.model.update({appid:appid},{where:{id:company_id,isEnabled:true},transaction:t});
            }
            return {code:1};
        });
        
    }
     /**
     * 取消关注公众号触发 创建/更新微信app信息
     */
    async createOrUpdateAppInfo2(obj){
        var appid = obj.appid;
        if(!appid){
            return {code:-1,msg:"appid参数错误"};
        }
        // var wxapp = await this.dao.model.findOne({where:{appid:appid,authorized_status:"authorized"},raw:true});
        var that = this;
        return this.db.transaction(async function (t) {
            await that.dao.model.update(obj,{where:{appid:appid},transaction:t});
            await that.companyDao.model.update({appid:""},{where:{appid:appid},transaction:t});
            return {code:1};
        });
        
    }
    async getWxapp(obj){
        var wxapp = await this.dao.model.findOne({
            where:{appid:obj.appid,authorized_status:"authorized"},
            attributes: ["appid", "id", "authorized_status", "authorized_status_name", "head_img","company_id"],
            raw:true
        });
        return wxapp;
    }

}
module.exports=WxappService;
