const system=require("../../system");
const ServiceBase=require("../sve.base")
const settings=require("../../../config/settings")
class ServiceitemService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(ServiceitemService));
  }
  async findAll(obj) {
    return this.dao.model.findAll({where:obj,include:[{model:this.db.models.producttype,attributes:["id","name","isRecommend"]}],raw:true});
  }
  async findOneByCode(code,cid){
    return this.dao.findOneByCode(code,cid);
  }
  //获取推荐产品(6条)
  async findByCompany(obj){
    return this.dao.model.findAndCountAll({
      "where":{"company_id":obj,"isRecommend":"1"},
      attributes:["id", "code", "name", "shortDesc", "price", "mobilePic", "mobileContentImg", "mobileContentImg1", "mobileContentImg2", "mobileContentImg3", "mobileContentImg4", "mobileContentImg5", "mobileContentImg6", "mobileContentImg7", "mobileContentImg8", "producttype_id", "producttype_pid_id", "iconUrl", "serviceCharge", "publicExpense", "rateConfig", "discountsRateConfig", "isRecommend"],
      limit : 6
    })
  }
}
module.exports=ServiceitemService;
