const system = require("../../system");
const ServiceBase = require("../sve.base");
var settings = require("../../../config/settings");
class OplogService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(OplogService));
    //this.appDao=system.getObject("db.appDao");
    this.opLogUrl = settings.apiconfig.opLogUrl();
    this.opLogEsIsAdd = settings.apiconfig.opLogEsIsAdd();
  }
  async getCountBySourceOrderNo(sourceOrderNo) {
    return this.findCount({ where: { sourceOrderNo: sourceOrderNo, opLogStatus: "waitingProcess" } });
  }
  async updateByCallback(obj) {
    var setParam = { notes: "回调信息：" + JSON.stringify(obj) };
    if (obj.respCode == "00") {
      setParam.opLogStatus = "success";
    }
    else if (obj.respCode == "02") {
      setParam.opLogStatus = "fail";
    }
    return this.updateByWhere(setParam, { where: { sourceOrderNo: obj.outTradeNo, opLogStatus: "waitingProcess" } });
  }
  async create(qobj) {
    if (qobj.op.indexOf("metaCtl/getUiConfig") >= 0 ||
      qobj.op.indexOf("userCtl/checkLogin") >= 0 ||
      qobj.op.indexOf("oplogCtl") >= 0 ||
      qobj.op.indexOf("getDicConfig") >= 0 ||
      qobj.op.indexOf("getRouteConfig") >= 0 ||
      qobj.op.indexOf("getRsConfig") >= 0) {
      return null;
    }
    var rc = system.getObject("util.execClient");
    var rtn = null;
    try {

      qobj.optitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.optitle;
      if (this.opLogEsIsAdd == 1) {
        qobj.content = qobj.content.replace("field list", "字段列表")
        qobj.created_at = (new Date()).getTime();
        //往Es中写入日志
        var addEsData = JSON.stringify(qobj);
        rc.execPost(qobj, this.opLogUrl);
      } else {
        //解决日志大于4000写入的问题
        if (qobj.content.length > 3980) {
          qobj.content = qobj.content.substring(0, 3980);
        }
        this.dao.create(qobj);
      }
    } catch (e) {
      console.log("addLog------>error-----------------------*****************");
      console.log(e);
      //解决日志大于4000写入的问题
      if (qobj.content.length > 3980) {
        qobj.content = qobj.content.substring(0, 3980);
      }
      this.dao.create(qobj);
    }
  }

}
module.exports = OplogService;
