const system = require("../../system");
const ServiceBase = require("../sve.base")
const settings = require("../../../config/settings")
class ExpenseVoucherService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(ExpenseVoucherService));
    this.moneyjourneyDao = system.getObject("db.moneyjourneyDao");
    this.moneyaccountDao = system.getObject("db.moneyaccountDao");
  }
  async afteraudit(obj, tm) {
    var item = await this.moneyjourneyDao.model.findOne({ where: { code: obj.code }, raw: true });
    if (!item) {
      throw new Error("账单信息有误");
    }
    if (item.auditStatus != "dsh") {
      throw new Error("账单信息状态不是待审核状态,无法进行操作");
    }
    await this.moneyjourneyDao.update({ id: item.id, auditStatus: obj.auditStatus, opNotes: obj.opNotes }, tm);
    if (obj.auditStatus == "tg") {
      var moneyaccountinfo = await this.moneyaccountDao.model.findOne({ where: { id: item.moneyaccount_id }, raw: true });
      if (moneyaccountinfo) {
        var balanceSum = Number(moneyaccountinfo.balance) - Number(item.payAmount);
        await this.moneyaccountDao.update({ id: moneyaccountinfo.id, balance: balanceSum });
      }
    }
  }
  async aftercreate(result, tm) {
    var obj = {
      code: result.code,
      directionType: "zc",
      voucherDate: result.created_at,
      recvAmount: 0,
      payAmount: result.totalSum,
      sourceType: "expensevoucher",
      sourceOrderNo: result.sourceOrderNo,
      notes: result.notes,
      createuser_id: result.createuser_id,
      moneyaccount_id: result.moneyaccount_id,
      auditStatus: result.auditStatus,
      company_id: result.company_id
    };
    await this.moneyjourneyDao.create(obj, tm);
  }
  async beforedelete(result, tm) {
    var obj = await this.dao.findOne({ id: result.id });
    var moneyjourneyinfo = await this.moneyjourneyDao.findOne({ sourceOrderNo: obj.id });
    await this.moneyjourneyDao.delete(result, tm);
  }
  async fetchForFinance(companyid) {
    var receiveDsh = await this.db.query(
      'SELECT count(*) as num from `biz_receiptvoucher` where auditStatusName="待审核" and company_id=:status',
      { replacements: { status: companyid }, type: this.db.QueryTypes.SELECT });
    var receiveTotal = await this.db.query(
      'SELECT count(*) as num from `biz_receiptvoucher` where company_id=:status',
      { replacements: { status: companyid }, type: this.db.QueryTypes.SELECT });
    var expenseDsh = await this.db.query(
      'SELECT count(*) as num from `biz_expensevoucher` where auditStatusName="待审核" and company_id=:status',
      { replacements: { status: companyid }, type: this.db.QueryTypes.SELECT });
    var expenseTotal = await this.db.query(
      'SELECT count(*) as num from `biz_expensevoucher` where company_id=:status',
      { replacements: { status: companyid }, type: this.db.QueryTypes.SELECT });
    var num1 = Number(receiveTotal[0].num) - Number(receiveDsh[0].num);
    var num2 = Number(receiveDsh[0].num);
    var num3 = Number(expenseTotal[0].num) - Number(expenseDsh[0].num);
    var num4 = Number(expenseDsh[0].num);
    var result = {
      receive: [
        { name: "已审核", num: num1 },
        { name: "未审核", num: num2 }
      ],
      expense: [
        { name: "已审核", num: num3 },
        { name: "未审核", num: num4 }
      ]
    };
    console.log(result);
    return result;
  }

}
module.exports = ExpenseVoucherService;
