const TaskBase = require("../task.base");
var system = require("../../system")
const logCtl = system.getObject("web.oplogCtl");
class CreatepatentrepotTask extends TaskBase {
    constructor() {
        super();
        this.pytmreportSve = system.getObject("service.pytmreportSve");
        this.mailClient = system.getObject("util.mailClient");
    };

    async subDoTask() {
        await this.execTj();
    };

    async execTj() {
        var id = await this.redisClient.lpop("create_patentrepotCache");
        if (id) {
          var info = await this.pytmreportSve.dao.findById(id);
          console.log(info.dataValues);
          if (info) {
            var url = "http://43.247.184.94:19500/patentdoc/api/createdoc?mycompanyname=" + encodeURIComponent(info.companyname);
            var rc = system.getObject("util.execClient");
            var rtn = null;
            try {
              rtn = await rc.execGetTimeOut({}, url, 1200000);
              var j = rtn.stdout;
              // var j="https://gsb-zc.oss-cn-beijing.aliyuncs.com/北京创知厚德科技有限公司_20190822014212_tmreport.docx"
              // console.log("fanhui");
              console.log(j);
              if (j.indexOf("gsb-zc.oss-cn-beijing.aliyuncs.com") >= 0) {
                var text = "企业专利监控报告";
                var html = '<a href="' + j + '">企业专利监控报告</a>'
                var result = this.mailClient.sendMsg(info.email, "企业专利监控报告", null, html, null, null, []); //发送成功后result的值:250 Data Ok: queued as freedom 
              }
              info.dataValues.filepath = j;
              info.dataValues.status = 1;
              var result = await this.pytmreportSve.dao.model.update(info.dataValues, { where: { id: id } });
              logCtl.info({
                optitle: "专利检索报告执行结果",
                op: "/igirl-web/app/base/db/task/CreatepatentrepotTask.js",
                content: "id=" + id + "执行结果：" + j,
                clientIp: ""
              });
            } catch (e) {
              console.log(e);
              //日志记录
              logCtl.error({
                optitle: "专利检索报告执行结果-error",
                op: "/igirl-web/app/base/db/task/CreatepatentrepotTask.js",
                content: e.stack,
                clientIp: ""
              });
              return { code: -200, msg: "操作失败" };
            }
          }
        }
    }
}
module.exports = CreatepatentrepotTask;