const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/voucherbasetwo")(db, DataTypes);
  return db.define("workcrsubmit", Object.assign({
    // 引用表的信息:
    // //作品著作权表引用用户信息
    // this.db.models.workcrsubmit.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.workcrsubmit.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });

    //基类 code: 提报号(自动生成)
    //基类 name: 作品名称
    //基类 opNotes: 操作备注
    //基类 sourceTypeName: //来源类型名称
    //基类 sourceType: //来源类型:ENUM=source_type，order: 订单,expensevoucher: 费用单,receiptvoucher: 收款单, trademark: 商标单
    //基类 sourceOrderNo: DataTypes.STRING,//来源单号--订单号  

    // statusProgress: {//1: "待上传材料", 2: "待审核", 4: "审核不通过", 8: "待递交", 16: "待下回执", 32: "部分递交异常", 64: "不予受理", 128: "待邮件申请表", 256: "已完成"
    //   type: DataTypes.INTEGER,
    //   values: Object.keys(uiconfig.config.pdict.statusProgress_status),
    //   set: function (val) {
    //     this.setDataValue("statusProgress", Number(val));
    //     this.setDataValue("statusProgressName", uiconfig.config.pdict.statusProgress_status[val]);
    //   },
    // },
    // statusProgressName: DataTypes.STRING,//进展状态名称
    tmRegistNum: DataTypes.STRING(50),//注册号
    compositionType: {//作品著作权分类（wz文字、ks口述、yl音乐、xj戏剧、qy曲艺 、wd舞蹈 、zjys杂技艺术、ms美术 、jz建筑 、sy摄影 、dy电影和类似摄制电影方法创作的作品、tx图形、mj模型、qt其他 ）
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.composition_type),
      set: function (val) {
        this.setDataValue("compositionType", val);
        this.setDataValue("compositionTypeName", uiconfig.config.pdict.composition_type[val]);
      },
    },
    compositionTypeName: DataTypes.STRING(50),//作品著作权分类名称
    compositionTypeDesc: DataTypes.STRING(500),//作品著作权分类说明
    authorData: DataTypes.STRING(4000),//作者姓名或名称以及作品署名：[{"authorName":"作者","authorSign":"作者署名"}]
    opusInditeKind: {//作品创作性质：yc:原创,gb:改编,fy:翻译,hb:汇编,zs:注释,zl:整理,qt:其他
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.opus_indite_kind),
      set: function (val) {
        this.setDataValue("opusInditeKind", val);
        this.setDataValue("opusInditeKindName", uiconfig.config.pdict.opus_indite_kind[val]);
      },
    },
    opusInditeKindName: DataTypes.STRING(50),//作品创作性质名称
    opusDesc: DataTypes.STRING(500),//作品创作性质说明
    opusCreateDate: DataTypes.DATE,//作品创作完成日期
    finishCountry: DataTypes.STRING(50),//完成国家
    finishCity: DataTypes.STRING(50),//完成城市
    publishStatus: {//发表状态1已发表，2未发表
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.publish_status),
      set: function (val) {
        this.setDataValue("publishStatus", val);
        this.setDataValue("publishStatusName", uiconfig.config.pdict.publish_status[val]);
      },
    },
    publishStatusName: DataTypes.STRING(50),//发表状态名称
    appearDate: DataTypes.DATE,//首次发表日期
    appearCountry: DataTypes.STRING(50),//首次发表地点国家
    appearCity: DataTypes.STRING(50),//首次发表地点城市
    obtainMode: {//权利取得方式：ys:原始,jc:继承,cs:承受,qt:其他
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.obtain_mode),
      set: function (val) {
        this.setDataValue("obtainMode", val);
        this.setDataValue("obtainModeName", uiconfig.config.pdict.obtain_mode[val]);
      },
    },
    obtainModeName: DataTypes.STRING(50),//权利取得方式名称
    inheritDesc: DataTypes.STRING(500),//权利取得方式为原始以外的有此值：权利取得方式说明
    rightOwnMode: {//权利归属方式：grzp:个人作品,hzzp:合作作品,frzp:法人作品,zwzp:职务作品,wtzp:委托作品
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.right_own_mode),
      set: function (val) {
        this.setDataValue("rightOwnMode", val);
        this.setDataValue("rightOwnModeName", uiconfig.config.pdict.right_own_mode[val]);
      },
    },
    rightOwnModeName: DataTypes.STRING(50),//权利归属方式名称
    rightOwnDesc: DataTypes.STRING(500),//权利归属方式说明
    rightScope: {//权利拥有状况1全部，2部分
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.range_type),
      set: function (val) {
        this.setDataValue("rightScope", val);
        this.setDataValue("rightScopeName", uiconfig.config.pdict.range_type[val]);
      },
    },
    rightScopeName: DataTypes.STRING(50),//权利拥有状况名称
    rightScopeList: DataTypes.STRING(500),//权利拥有状况为部分有此值，部分选项集合
    ownPartDesc: DataTypes.STRING(50),//权利拥有状况说明
    emedium: DataTypes.STRING(50),//电子介质
    ecount: DataTypes.STRING(50),//电子介质几件
    pmedium: DataTypes.STRING(50),//纸介质
    pcount: DataTypes.STRING(50),//纸介质几张
    applyType: {//申请办理方式1由著作权任申请，2由代理任申请
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.apply_type),
      set: function (val) {
        this.setDataValue("applyType", val);
        this.setDataValue("applyTypeName", uiconfig.config.pdict.apply_type[val]);
      },
    },
    applyTypeName: DataTypes.STRING(50),//申请办理方式名称
    declarationUrl: DataTypes.STRING(500),//法人作品声明Url
    authorizationUrl: DataTypes.STRING(500),//作品授权书Url
    descUrl: DataTypes.STRING(500),//作品说明Url
    sampleUrl: DataTypes.STRING(500),//作品样本Url
    workPicUrl: DataTypes.STRING(500),//作品Url
    notes: DataTypes.STRING(255),//备注

  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'cr_works_submit',
      validate: {
      }
    });
}
