const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/voucherbase")(db, DataTypes);
  return db.define("trademark", Object.assign({
    // 引用表的信息:
    // //商标表引用用户信息
    // this.db.models.trademark.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.trademark.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    // this.db.models.trademark.belongsTo(this.db.models.user, { as: 'audituser', constraints: false, });
    // this.db.models.trademark.hasMany(this.db.models.tmofficial, { constraints: false, });

    //基类 code: 提报号(自动生成)
    //基类 name: 商标名称
    //基类 creator: 创建者
    //基类 updator:/更新者
    //基类 auditor: 审核者
    //基类 opNotes: 操作备注
    //基类 auditStatusName: //审核状态名称
    //基类 auditStatus: //审核状态:ENUM=audit_status，"dsh": "待审核", "btg": "不通过", "tg": "通过"
    //基类 sourceTypeName: //来源类型名称
    //基类 sourceType: //来源类型:ENUM=source_type，order: 订单,expensevoucher: 费用单,receiptvoucher: 收款单, trademark: 商标单
    //基类 sourceOrderNo: DataTypes.STRING,//来源单号--订单号  

    tmTypeName: {//订单付款状态名称
      type: DataTypes.STRING,
      defaultValue: "普通商标",
    },
    tmType: {//"p": "普通商标", "j": "集体商标", "z": "证明商标", "t": "特殊商标"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_type),
      defaultValue: "p",
      set: function (val) {
        this.setDataValue("tmType", val);
        this.setDataValue("tmTypeName", uiconfig.config.pdict.tm_type[val]);
      }
    },
    tmFormTypeName: DataTypes.STRING,
    tmFormType: {//商标类型形式："1": "立体", "3": "字", "4": "图", "5": "字图", "6": "颜色", "7": "彩色"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_form_type),
      set: function (val) {
        this.setDataValue("tmFormType", val);
        this.setDataValue("tmFormTypeName", uiconfig.config.pdict.tm_form_type[val]);
      }
    },
    // caseTypeName:{
    //   type:DataTypes.STRING,
    //   default:"商标注册"
    // },
    // caseType:{//案例类型:"sbzc": "商标注册", "sbbg": "商标变更", "sbbh": "商标驳回"
    //   type:DataTypes.ENUM,
    //   values: Object.keys(uiconfig.config.pdict.case_type),
    //   defaultValue: "sbzc",
    //   set:function(val){
    //     this.setDataValue("caseType",val);
    //     this.setDataValue("caseTypeName",uiconfig.config.pdict.case_type[val]);
    //   }
    // },
    producttype_id: DataTypes.INTEGER,//产品小类Id 
    productTypeName: DataTypes.STRING,//产品小类名称
    nclOneCodes: DataTypes.STRING,//尼斯大类
    nclSmallCodes: DataTypes.TEXT('long'),//尼斯小类
    submitTime: DataTypes.DATE,//提报时间
    tmRegistNum: DataTypes.STRING,//注册号
    officialTypeName: DataTypes.STRING,
    officialType: {
      // "1": "商标注册申请书", "2": "商标注册申请补正通知书", "3": "商标注册申请受理通知书", "4": "商标注册申请不予受理通知书", "5": "商标注册同日申请补送使用证据通知书",
      // "6": "商标注册同日申请协商通知书商标注册同日申请抽签通知书", "7": "商标驳回通知书", "8": "商标部分驳回通知书", "9": "商标注册申请初步审定公告通知书",
      // "10": "商标异议答辩通知书", "11": "异议裁定书", "12": "纸质版商标注册证", "13": "电子版商标注册证"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.official_type),
      set: function (val) {
        this.setDataValue("officialType", val);
        this.setDataValue("officialTypeName", uiconfig.config.pdict.official_type[val]);
      }
    },
    payPublicExpense: {//支付官费,0否，1是
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    tbKey: DataTypes.STRING,//提报的key
    tbErrorCount: {//提报的错误次数,0是成功，-1未提报，>0为提报错误次数
      type: DataTypes.INTEGER,
      defaultValue: -1,
    },
    notes: DataTypes.STRING,//备注信息
    subErrorMsg: DataTypes.STRING(4000),//提报错误信息   
    nclPublicExpense: DataTypes.DECIMAL(12, 2),//尼斯官费总额
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_trademark',
      validate: {
      }
    });
}
