const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("tmofficial", Object.assign({//收款单：
    // 引用表的信息:
    // //商标官文引用用户表
    // this.db.models.tmofficial.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // //商标官文引用商标表
    // this.db.models.tmofficial.belongsTo(this.db.models.trademark, { constraints: false, }); 
    //// 商标官文引用订单表
    // this.db.models.tmofficial.belongsTo(this.db.models.order, { constraints: false, }); 

    //基类 code: 官文单号（自动生成）
    //基类 name:  ---暂时没有用

    officialTypeName: DataTypes.STRING,
    officialType: {
      // "1": "商标注册申请书", "2": "商标注册申请补正通知书", "3": "商标注册申请受理通知书", "4": "商标注册申请不予受理通知书", "5": "商标注册同日申请补送使用证据通知书",
      // "6": "商标注册同日申请协商通知书商标注册同日申请抽签通知书", "7": "商标驳回通知书", "8": "商标部分驳回通知书", "9": "商标注册申请初步审定公告通知书",
      // "10": "商标异议答辩通知书", "11": "异议裁定书", "12": "纸质版商标注册证", "13": "电子版商标注册证"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.official_type),
      set: function (val) {
        this.setDataValue("officialType", val);
        this.setDataValue("officialTypeName", uiconfig.config.pdict.official_type[val]);
      }
    },
    officialMailTypeName: DataTypes.STRING,
    officialMailType: {//官文邮寄类型:"1": "待申请", "2": "待邮寄", "3": "已邮寄"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.official_mail_type),
      set: function (val) {
        this.setDataValue("officialMailType", val);
        this.setDataValue("officialMailTypeName", uiconfig.config.pdict.official_mail_type[val]);
      }
    },
    tmRegistNum: DataTypes.STRING,//注册号
    officialFileName: DataTypes.STRING(200),//官文文件名称
    officialFileUrl: DataTypes.STRING(500),//官文文件地址
    recipients: DataTypes.STRING(50),//收件人
    mobile: DataTypes.STRING(20),//手机号
    email: DataTypes.STRING(50),//邮箱    
    province: DataTypes.STRING(50),//省名称
    city: DataTypes.STRING(50),//市名称
    area: DataTypes.STRING(20),//申请区域-存储省市的编码
    address: DataTypes.STRING,//地址
    notes: DataTypes.STRING,//备注      
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_tmofficial',
      validate: {
      }
    });
}
