const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("serviceitem", {
    code: DataTypes.STRING,
    name: DataTypes.STRING,
    isPubed: {//是否可以交易，0不发布，1发布，默认为1
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    isRecommendName: {
      // 是否推荐名称
      type: DataTypes.STRING,
      defaultValue: "否",
    },
    isRecommend: {
      //是否推荐："0": "否", "1": "是"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.isRecommend),
      set: function (val) {
        this.setDataValue("isRecommend", val);
        this.setDataValue("isRecommendName", uiconfig.config.pdict.isRecommend[val]);
      },
      defaultValue: "0",
    },
    // itemType: {
    //   //项目类型:ip:商标,ic:版权,pa:专利,iso:海外业务,common:增值服务,icbc:工商注册,zscq:知识产权,cwfw:财务服务,hyzz:行业资质,gqzr:股权转让,xzsp:行政审批
    //   type: DataTypes.ENUM,
    //   values: Object.keys(uiconfig.config.pdict.productCata),
    //   set: function (val) {
    //     this.setDataValue("itemType", val);
    //     this.setDataValue("itemTypeName", uiconfig.config.pdict.productCata[val]);
    //   },
    //   defaultValue: "ip",
    // },
    itemType: {
      type: DataTypes.STRING
    },
    itemTypeName: {//服务类型名称
      type: DataTypes.STRING
    },
    iconUrl: DataTypes.STRING(500),//产品图标地址
    mobilePic: DataTypes.STRING,//产品图片
    mobileContentImg: DataTypes.STRING(500),//PC产品内容图片 1
    mobileContentImg1: DataTypes.STRING(500),//PC产品内容图片 2
    mobileContentImg2: DataTypes.STRING(500),//PC产品内容图片 3
    mobileContentImg3: DataTypes.STRING(500),//PC产品内容图片 4
    mobileContentImg4: DataTypes.STRING(500),//PC产品内容图片 5
    mobileContentImg5: DataTypes.STRING(500),//PC产品内容图片 6
    mobileContentImg6: DataTypes.STRING(500),//PC产品内容图片 7
    mobileContentImg7: DataTypes.STRING(500),//移动产品图片 
    mobileContentImg8: DataTypes.STRING(500),//移动产品详情 
    countryPic: DataTypes.STRING,//国家图片章
    shortDesc: {//项目简介
      type: DataTypes.STRING(4000),
      allowNull: true,
    },
    serviceCharge: {//服务费
      type: DataTypes.DOUBLE,
      allowNull: true,
    },
    publicExpense: {//官费
      type: DataTypes.DOUBLE,
      allowNull: true,
    },
    rateConfig: {//税率
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 7.00,
    },
    discountsRateConfig: {//优惠税率
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 0,
    },
    channelProfitRate: {//渠道利润分成比率(只分订单中毛利润总额的分成)
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 50,
    },
    price: {//产品价格
      type: DataTypes.DOUBLE,
      allowNull: true,
    },
    sort: {  //排序
      type: DataTypes.DOUBLE,
      allowNull: true,
      defaultValue: 1,
    },
    priceRangeMin: DataTypes.DOUBLE,//商标价格区间最小值
    priceRangeMax: DataTypes.DOUBLE,//商标价格区间最大值
    isRangeName: {
      // 是否区间销售名称
      type: DataTypes.STRING,
      defaultValue: "否",
    },
    isRange: {
      //是否区间销售："0": "否", "1": "是"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.isRecommend),
      set: function (val) {
        this.setDataValue("isRange", val);
        this.setDataValue("isRangeName", uiconfig.config.pdict.isRecommend[val]);
      },
      defaultValue: "0",
    },
    isSystem: {//是否系统数据,0否，1是
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 's_serviceitem',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
