module.exports = (db, DataTypes) => {
  const enums={
     price:"宝币兑换率",
     initGift:"初次赠送",
     platformProfitRatio:"平台的分成比率",
     referrerProfitRatio:"推荐人分成比率",
     apiCallPrice:"API调用价格",
     apiInitGift:"API初次赠送次数",
     platformUseProfit:"平台使用费",
     wtsName:"委托书联系人名称",
     wtsMobile:"委托书电话",
     wtsZipcode:"委托书邮编",
     withdrawalData:"提现申请限制日期范围20-31，-1不限制",
     withdrawalLimit:"提现限制额度，-1不限制，0则不发放提现申请，大于0则为限制的额度",
     withdrawalIssueLimit:"提现申请发放限制，-1不限制，0则不发放提现申请，大于0则为限制的额度",
     logOpWrite:"操作日志步骤是否写入，0否，1是",
     invoiceTaxRate:"发票税率",
     bussinessAllotChannelConfig:"商机分配渠道配置，格式：wssyh5,yzc等",
  }
  var PConfig=db.define("pconfig", {
    name: {
      type:DataTypes.STRING,
      allowNull: false,
      // get(){
      //   const ctype = this.getDataValue("configType");
      //   return enums[ctype];
      // }
    },
    configType: {
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(enums),
      set:function(val){
        this.setDataValue("name",enums[val]);
        this.setDataValue("configType",val);
      }
    },
    configValue: {
      type:DataTypes.STRING,
      allowNull: false,
    },
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     tableName: 'p_config',
     validate: {
     },
  });
  PConfig.enums=enums;
  return PConfig;
}
