const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/voucherbase")(db, DataTypes);
  return db.define("invoiceapply", Object.assign({//商标材料：
    // 引用表的信息:
    // //发票申请引用用户表
    // this.db.models.invoiceapply.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // //发票申请引用订单表
    // this.db.models.invoiceapply.belongsTo(this.db.models.order, { constraints: false, });
    // this.db.models.invoiceapply.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.invoiceapply.belongsTo(this.db.models.user, { as: 'audituser', constraints: false, });

    //基类 code: 发票申请号（自动生成）
    //基类 name: ---暂时没有用
    //基类 creator: 创建者
    //基类 updator:/更新者
    //基类 auditor: 审核者
    //基类 opNotes: 操作备注
    //基类 auditStatusName: //审核状态名称
    //基类 auditStatus: //审核状态:ENUM=audit_status，"dsh": "待审核", "btg": "不通过", "tg": "通过"
    //基类 sourceTypeName: //来源类型名称
    //基类 sourceType: //来源类型:ENUM=source_type，"order": "订单","expensevoucher": "费用单","receiptvoucher": "收款单", "trademark": "商标单"
    //基类 sourceOrderNo: DataTypes.STRING,//来源单号

    invoiceTypeName: DataTypes.STRING,//发票类型名称
    invoiceType: {
      //发票类型："1": "电子普通发票", "2": "纸质普通发票", "3": "纸质专用发票"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.invoice_type),
      set: function (val) {
        this.setDataValue("invoiceType", val);
        this.setDataValue("invoiceTypeName", uiconfig.config.pdict.invoice_type[val]);
      },
      defaultValue: "1",
    },
    invoiceHeadUpType: {
      //发票抬头类型，person个人，ent公司
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_apply_type),
      set: function (val) {
        this.setDataValue("invoiceHeadUpType", val);
        this.setDataValue("invoiceHeadUpTypeName", uiconfig.config.pdict.tm_apply_type[val]);
      },
      defaultValue: "ent",
    },
    invoiceHeadUpTypeName: DataTypes.STRING,//发票抬头类型名称
    invoiceContent: {//发票内容
      type: DataTypes.STRING,
      defaultValue: "服务费",
    },
    invoiceStatusName: {
      type: DataTypes.STRING,
      defaultValue: "已提交",
    },
    invoiceStatus: {//发票状态："submitted":"已提交","processing":"处理中","finished":"已完成"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.invoice_status),
      set: function (val) {
        this.setDataValue("invoiceStatus", val);
        this.setDataValue("invoiceStatusName", uiconfig.config.pdict.invoice_status[val]);
      },
      defaultValue: "submitted",
    },
    invoiceHeadUp: DataTypes.STRING,//发票抬头
    taxpayerID: DataTypes.STRING,//纳税人识别号
    recipients: DataTypes.STRING(50),//收件人
    mobile: DataTypes.STRING,//收票人手机号
    email: DataTypes.STRING,//收票人邮箱
    address: DataTypes.STRING,//申请地址
    applyProvince: DataTypes.STRING,//省
    applyCity: DataTypes.STRING,//市
    applyArea: DataTypes.STRING,//县
    applyAddr: DataTypes.STRING,//公司注册地址
    applytelephone: DataTypes.STRING,
    bankName: DataTypes.STRING,//开户行名称
    bankNum: DataTypes.STRING,//开户行账号
    taxesCertifyUrl: DataTypes.STRING(500),//纳税资格证明
    notes: DataTypes.STRING,//备注
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_invoiceapply',
      validate: {
      }
    });
}
