const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("businessinfo", {
    // 引用表的信息:
    // this.db.models.businessinfo.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//认领人公司
    // this.db.models.businessinfo.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });//认领人
    // this.db.models.businessinfo.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });

    sourceOrderCode: DataTypes.STRING(50),//来源订单号
    sourceCode: DataTypes.STRING(50),//来源唯一码
    tm_type: DataTypes.STRING(50),//商标类别：p普通商标、J集体商标、Z证明商标、T特殊商标
    tm_name: DataTypes.STRING(1000),//商标名称
    pic_url: DataTypes.STRING(500),//商标大图片
    tm_agency: DataTypes.STRING(1000),//商标代理机构
    apply_day: DataTypes.DATE,//申请时间
    tm_regist_num: DataTypes.STRING(100),//商标注册号
    ncl_one_codes: DataTypes.STRING(50),//所属尼斯大类
    applicant_cn: DataTypes.STRING(1000),//申请人中文
    applicant_en: DataTypes.STRING(1000),//申请人英文
    applicant_cn_addr: DataTypes.STRING(500),//申请人中文地址
    applicant_en_addr: DataTypes.STRING(1000),//申请人英文地址
    regist_notice_day: DataTypes.DATE,//注册公告日期
    regist_notice_issue: DataTypes.INTEGER,//注册公告期号
    regist_notice_page_num: DataTypes.INTEGER,//注册公告页码
    original_regist_notice_day: DataTypes.DATE,//原注册公告日期
    tm_end_day: DataTypes.DATE,//商标截至时间（续展时间） 
    known: DataTypes.INTEGER,//是否驰名商标
    tm_company_type_name: DataTypes.STRING(50),//商机类型名称
    tm_company_type: {//商机类型：xz: 商标续展，kz：商标宽展，bh: 商标驳回复审，bysl: 商标不予受理，yy: 商标异议，bg: 商标变更
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_company_type),
      set: function (val) {
        this.setDataValue("tm_company_type", val);
        this.setDataValue("tm_company_type_name", uiconfig.config.pdict.tm_company_type[val]);
      }
    },
    legal_status_name: DataTypes.STRING(50),//法律状态名称
    dispose_status_name: DataTypes.STRING(50),//商机类型名称
    dispose_status: {//处理状态：wxd: 未下单, yxd: 已下单, wx: 无效
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.dispose_status),
      set: function (val) {
        this.setDataValue("dispose_status", val);
        this.setDataValue("dispose_status_name", uiconfig.config.pdict.dispose_status[val]);
      }
    },
    notes: DataTypes.STRING,//备注
    op_notes: DataTypes.STRING(50),//操作备注   
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'bi_businessinfo',
      validate: {

      },
      indexes: [
      ]
    });
}
