module.exports = {
  "list": {
    columnMetaData: [
      { "width": "120", "label": "产品编码", "prop": "code", "isShowTip": true, "isTmpl": false },
      { "width": "150", "label": "产品大类", "prop": "itemTypeName", "isShowTip": true, "isTmpl": false },
      { "width": "150", "label": "产品小类", "prop": "producttype.name", "isShowTip": true, "isTmpl": false },
      { "width": "200", "label": "产品名称", "prop": "name", "isShowTip": true, "isTmpl": false },
      { "width": "150", "label": "产品价格", "prop": "price", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "产品官费", "prop": "publicExpense", "isShowTip": true, "isTmpl": false },
      // { "width": "100", "label": "是否推荐", "prop": "isRecommend", "isShowTip": true, "isTmpl": false },
      { "width": "200", "label": "是否发布", "prop": "isPubed", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "排序", "prop": "sort", "isShowTip": true, "isTmpl": false },
      { "width": "null", "label": "操作", "name": "null", "isShowTip": false, "isTmpl": true, "isBtns": true },
    ]
  },
  "form": [
    {
      "title": "基本信息",
      "ctls": [
        { "type": "number", "label": "排序", "prop": "sort", "disabled": false, "placeHolder": "请输入排序，越小越靠前显示，可以为负数", "style": "", rules: [{ "validator": "validatex", "trigger": 'blur' }, { "required": true, "message": '请输入排序，越小越靠前显示，可以为负数', "trigger": 'blur' }, { "type": 'number', "message": '排序必须为数字值' }] },        
        { "type": "input", "label": "产品名称", "prop": "name", "placeHolder": "请输入产品名称", "style": "", rules: [{ "required": true, "message": '请输入产品名称', "trigger": 'blur' },] },
        { "type": "select", label: "是否推荐", "dicKey": "isRecommend", "prop": "isRecommend", "labelField": "label", "valueField": "value", "style": "", rules: [{ "required": true, "message": '请选择类型', "trigger": 'blur' },] },
        { "type": "input", "label": "产品编码", "prop": "code", "placeHolder": "请输入产品编码", "style": "",disabled:true, rules: [{ "required": true, "message": '请输入产品编码', "trigger": 'blur' },] },
        { "type": "switch", label: "是否发布", "prop": "isPubed", "acText": "发布", "inactText": "不发布", "placeHolder": " ", "style": "" },
      ]
    },
    {
      "title": "所属类别",
      "validProp": "itemType",
      "rule": [

      ],
      "ctls": [
        // {"type":"select","dicKey":"productCata","label":"产品大类","prop":"itemType","labelField":"label","valueField":"value","style":"",rules:[ { "required": true, "message": '请选择产品大类', "trigger": 'blur' },]},
        { "type": "select", "refModel": "producttype", "isMulti": false, "label": "产品大类", "prop": "producttype_pid_id", "labelField": "name", "valueField": "id", "refwhere2": { "pid": 0 }, target: "producttype_id", "style": "", rules: [{ "required": true, "message": '请选择产品大类', "trigger": 'blur' },] },
        { "type": "select", "refModel": "producttype", "isMulti": false, "label": "产品小类", "prop": "producttype_id", "labelField": "name", "valueField": "id", "style": "", rules: [{ "required": true, "message": '请选择产品小类', "trigger": 'blur' },] },
      ]
    },
    {
      "title": "产品简介",
      "ctls": [
        { "type": "input", "label": "产品价格", "prop": "price", "disabled": true, "placeHolder": "含税的产品价格", "style": "", rules: [{ "required": true, "message": '请输入产品价格', "trigger": 'blur' }] },
        { "type": "input", "label": "产品官费", "prop": "publicExpense", "disabled": false, "placeHolder": "请输入产品官费", "style": "", rules: [{ "validator": "validatex", "trigger": 'blur' }, { "required": true, "message": '请输入产品官费', "trigger": 'blur' }] },
        { "type": "input", "label": "产品服务费", "prop": "serviceCharge", "disabled": false, "placeHolder": "请输入产品服务费", "style": "", rules: [{ "validator": "validatex", "trigger": 'blur' }, { "required": true, "message": '请输入产品服务费', "trigger": 'blur' }] },
        { "type": "input", "label": "优惠率", "prop": "discountsRateConfig", "disabled": false, "placeHolder": "请输入1-100之间的数字", "style": "", rules: [{ "validator": "validatex", "trigger": 'blur' }, { "required": true, "message": '请输入优惠税率', "trigger": 'blur' }] },
        { "type": "input", "label": "最大优惠金额", "prop": "discountAmount", "disabled": true, "placeHolder": "", "style": "" },
        { "type": "input", "label": "产品税率", "prop": "rateConfig", "disabled": false, "placeHolder": "请输入产品1-100之间的数字", "style": "", rules: [{ "required": true, "message": '请输入产品税率', "trigger": 'blur' }] },
        { "type": "upload", "label": "产品图片", "prop": "mobilePic", "placeHolder": "请输入产品图片", "style": "" },
        { "type": "upload", "label": "产品图标", "prop": "iconUrl", "style": "" },
        { "type": "textarea", "label": "产品简介", "prop": "shortDesc", "placeHolder": "请输入产品简介", "style": "" }
      ]
    },
    {
      "title": "产品详情",
      "ctls": [
        { "type": "upload", "label": "产品详情1", "prop": "mobileContentImg", "placeHolder": "请输入产品图片", "style": "" },
        { "type": "upload", "label": "产品详情2", "prop": "mobileContentImg1", "placeHolder": "请输入产品图片", "style": "" },
        { "type": "upload", "label": "产品详情3", "prop": "mobileContentImg2", "placeHolder": "请输入产品图片", "style": "" },
        { "type": "upload", "label": "产品详情4", "prop": "mobileContentImg3", "placeHolder": "请输入产品图片", "style": "" },
        { "type": "upload", "label": "产品详情5", "prop": "mobileContentImg4", "placeHolder": "请输入产品图片", "style": "" },
        { "type": "upload", "label": "产品详情6", "prop": "mobileContentImg5", "placeHolder": "请输入产品图片", "style": "" },
        { "type": "upload", "label": "产品详情7", "prop": "mobileContentImg6", "placeHolder": "请输入产品图片", "style": "" },
      ]
    },
    {
      "title": "移动详情",
      "ctls": [
        { "type": "upload", "label": "移动产品图片", "prop": "mobileContentImg7", "placeHolder": "请上传移动产品图片", "style": "" },
        { "type": "upload", "label": "移动产品详情", "prop": "mobileContentImg8", "placeHolder": "请上传移动产品详情", "style": "" },

      ]
    },
    {
      "title": "渠道分润",
      "ctls": [
        { "type": "input", "label": "分润比例", "prop": "channelProfitRate", "disabled": false, "placeHolder": "请输入1-100之间的数字", "style": "", rules: [{ "validator": "validatex", "trigger": 'blur' }, { "required": true, "message": '请输入粉润比例', "trigger": 'blur' }] },

      ]
    },

  ],
  "search": [
    {
      "title": "基本查询",
      ctls: [
        // { "type": "select", "label": "产品大类", "dicKey": "productCata", "prop": "itemType", "labelField": "label", "valueField": "value", "style": "" },
        // { "type": "select", "refModel": "producttype", "isMulti": false, "label": "产品小类", "prop": "producttype_id", "labelField": "name", "valueField": "id", "style": "", rules: [{ "required": true, "message": '请选择产品小类', "trigger": 'blur' },] },
        { "type": "select", "refModel": "producttype", "isMulti": false, "label": "产品大类", "prop": "producttype_pid_id", "labelField": "name", "valueField": "id", "refwhere2": { "pid": 0 }, target: "producttype_id", "style": "", rules: [{ "required": true, "message": '请选择产品大类', "trigger": 'blur' },] },
        { "type": "select", "refModel": "producttype", "isMulti": false, "label": "产品小类", "prop": "producttype_id", "labelField": "name", "valueField": "id", "style": "", rules: [{ "required": true, "message": '请选择产品小类', "trigger": 'blur' },] },
        { "type": "input", "label": "产品编码", "prop": "code", "placeHolder": "请输入产品编码", "style": "" },
        { "type": "input", "label": "产品名称", "prop": "name", "placeHolder": "请输入产品名称", "style": "" },
      ]
    },
  ],
  "auth": {
    "add": [
      { "icon": "el-icon-plus", "title": "新增", "type": "default", "key": "new", "isOnGrid": true },
      { "icon": "el-icon-save", "title": "保存", "type": "default", "key": "save", "isOnForm": true },
    ],
    "edit": [
      { "icon": "el-icon-edit", "title": "修改", "type": "default", "key": "edit", "isInRow": true },
      { "icon": "el-icon-cancel", "title": "取消", "type": "default", "key": "cancel", "isOnForm": true },

    ],
    "delete": [
      { "icon": "el-icon-remove", "title": "删除", "type": "default", "key": "delete", "isInRow": true },
    ],
    "common": [

    ],
  }
}
