const system=require("../../system");
const Dao=require("../dao.base");
class AccountDao extends Dao{
  constructor(){
    super(Dao.getModelName(AccountDao));
  }
  async findOrCreate(ac,t){
    var account=  await this.model.findOne({where:{unionId:ac.unionId}},{transaction:t});
    if(account){
      return account;
    }else{
      account=await this.model.create(ac,{transaction:t});
      return account;
    }
  }
  async findOneByOnlyCode(onlycode){
    return this.model.findOne({"where":{"onlyCode":onlycode}});
  }

}
module.exports=AccountDao;
