const CacheBase = require("../cache.base");
const system = require("../../system");
//缓存蜂擎商标智能推荐
class TmSubCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "tmsub_crm:";
  }
  async delCache(keyCode) {
    const key = this.prefix + keyCode;
    await this.redisClient.delete(key);
  }
  async setTmSubList(keyCode, obj) {
    const key = this.prefix + keyCode;
    await this.redisClient.set(key, obj);
    return obj;
  }
  async getTmSubListByCache(keyCode) {
    if (keyCode == null || keyCode == "") {
      return null;
    }
    const key = this.prefix + keyCode;
    var cachedVal = await this.redisClient.get(key);
    if (cachedVal && cachedVal != "undefined") {
      return cachedVal;
    } else {
      return null;
    }
  }
}
module.exports = TmSubCache;
