const CacheBase = require("../cache.base");
const system = require("../../system");
class TmMonitQueryCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "tmmonit_query:";
    this.bytmresultDao = system.getObject("db.bytmresultDao");
  }
  async delCache(code, total_type){
    const key = this.prefix + code + "_" + total_type;
    await this.redisClient.delete(key);
  }
  async setList(code, total_type, values) {
    const key = this.prefix + code + "_" + total_type;
    this.redisClient.setWithEx(key, values, 60);//秒
  }
  async getListByCache(code, total_type) {
    const key = this.prefix + code + "_" + total_type;
    var cachedVal = await this.redisClient.get(key);
    if (cachedVal && cachedVal != "undefined") {
      // return JSON.parse(cachedVal);
      return cachedVal;
    } else {
      var item = await this.bytmresultDao.model.findOne({ where: { monitCode: code, resultType: total_type }, raw: true });
      if (item == null || !item.resultData || item.resultData.length < 20) {
        return null;
      }
      await this.setList(code, total_type, item.resultData);
      return item.resultData;
      // return JSON.parse(item.resultData);
    }
  }
}
module.exports = TmMonitQueryCache;
