const CacheBase = require("../cache.base");
const system = require("../../system");
class TmMonitAgencyQueryCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "tmmonit_agency_query:";
    this.bytmresultDao = system.getObject("db.bytmresultDao");
  }
  async delCache(agency_name, query_type) {
    const key = this.prefix + agency_name + "_" + query_type;
    await this.redisClient.delete(key);
  }
  async setList(agency_name, query_type, values) {
    const key = this.prefix + agency_name + "_" + query_type;
    this.redisClient.setWithEx(key, values, 86400);//秒==2天
  }
  async getListByCache(agency_name, query_type) {
    const key = this.prefix + agency_name + "_" + query_type;
    var cachedVal = await this.redisClient.get(key);
    if (cachedVal && cachedVal != "undefined") {
      return cachedVal;
    }
    return null;
  }
}
module.exports = TmMonitAgencyQueryCache;
