const CacheBase = require("../cache.base");
const system = require("../../system");
//缓存首次登录的赠送的宝币数量
class ThemeCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "theme:";
    this.themeDao = system.getObject("db.sitethemeDao");
    this.companyDao = system.getObject("db.companyDao");
  }
  async cacheTheme(hostname) {
    const key = this.prefix + hostname;
    var configValue = await this.redisClient.get(key);
    if (!configValue || configValue == "undefined") {
      console.log("uiconfig no cache....");
      var company = await this.companyDao.findOne({ "domainname": hostname, isEnabled: true });
      if (company) {
        var s = company.siteTheme;
        configValue = s;
        await this.redisClient.setWithEx(key, s, 60);
      } else {
        configValue = "default";
      }
      return configValue;
    } else {
      console.log("uiconfig already cache....");
    }
    return configValue;
  }
}
module.exports = ThemeCache;
