const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存首次登录的赠送的宝币数量
class CompanyCache extends CacheBase{
   constructor(){
     super();
     this.prefix="g_company_";
     this.companyDao = system.getObject("db.companyDao");
     this.footerinfoDao = system.getObject("db.footerinfoDao");
     this.moneyaccountDao = system.getObject("db.moneyaccountDao");
     this.desc="平台配置参数!"
   }
   async preFetchComanyAndFooterAndBankaccount(hostname){
    //获取当前域名
    var companytmp = await this.companyDao.findOne({ domainname: hostname, isEnabled: true });
    var bankAccount = null;
    if (!companytmp) {
      companytmp = await this.companyDao.findOne({ id: 1 });
    }
    bankAccount = await this.moneyaccountDao.findOne({ company_id: companytmp.id, isPlatformAutopay: true });
    var footerinfo = await this.footerinfoDao.findOne({ company_id: companytmp.id });
    if (!footerinfo) {
      footerinfo = await this.footerinfoDao.findOne({ company_id: 1 });
    }
    var companyinfoRtn={
      company:companytmp,
      footerinfo:footerinfo,
      bankAccount:bankAccount
    };
    return companyinfoRtn;
}
   async cacheCompany(hostname){
       const key=this.prefix+hostname;
       var configValue=await this.redisClient.get(key);
       if(!configValue || configValue=="undefined" || true){
         console.log("uiconfig no cache....");
         const configValue=await this.preFetchComanyAndFooterAndBankaccount(hostname);
         var s=JSON.stringify(configValue);
         await this.redisClient.set(key,s);
         return configValue;
       }else {
         console.log("uiconfig already cache....");
       }
       return JSON.parse(configValue);
   }
}
module.exports=CompanyCache;
