var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class OrderCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(OrderCtl));
  }
  async fetchProAndOrderForBoss(qobj, obj, req) {//订单数量（件数）展示---在使用
    var result = await this.service.fetchProAndOrderForBoss(req.companyid, req.session.user);
    return system.getResult2(result);
  }
  async fetchProfitAndOrder(qobj, obj, req) {
    var result = await this.service.fetchProfitAndOrder(req.companyid);
    return system.getResult2(result);
  }
  async fetchProAndOrderPie(qobj, obj, req) {//统计产品订单贡献度---在使用
    var result = await this.service.fetchProAndOrderPie(req.companyid, req.session.user);
    return system.getResult2(result);
  }
  async fetchForSalesman(qobj, obj, req) {
    var result = await this.service.fetchForSalesman(req.companyid, req.session.user.id);
    return system.getResult2(result);
  }
  async fetchPicForSalesman(qobj, obj, req) {
    var result = await this.service.fetchPicForSalesman(req.companyid, req.session.user.id);
    return system.getResult2(result);
  }

  async findAndCountAll(pobj, obj, req) {
    obj.mobile = req.session.user.mobile;
    return super.findAndCountAll(pobj, obj, req);
  }
  async findAndCountAll2(pobj, obj, req) {
    obj.mobile = req.session.user.mobile;
    return super.findAndCountAll(pobj, obj, req);
  }
  async createOtherOrder(pobj, obj, req) {
    var user = req.session.user;
    if (user) {
      obj["user"] = user;
      try {
        var result = await this.service.createOtherOrder(obj);
        return result;
      } catch (error) {
        console.log(error.stack, "eeeeeee.......................");
        return { code: -2, msg: "创建订单失败" };
      }
    } else {
      return { code: -1, msg: "用户数据为空" };
    }
  }
  async aiadive(obj, pobj, req) {
    var nclinfo = await this.service.aiadive(obj);
    return system.getResult2(nclinfo, null);
  }
  //创建icp订单
  async createIcpOrder(obj, qobj, req){
    var user = req.session.user;
    if (user) {
      qobj["user"] = user;
      try {
        var result = await this.service.createIcpOrder(qobj);
        return result;
      } catch (e) {
        //日志记录
        logCtl.error({
          optitle: "提交商标订单错误---error",
          op: "/base/controller/impl/orderCtl.js/createTmOrder",
          content: e.stack,
          clientIp: req.clientIp
        });
        return { code: -2, msg: "创建订单失败" };
      }
    } else {
      return { code: -1, msg: "未知用户" };
    }
  }
  //获取icp订单详情
  async getIcpOrderDetail(obj) {
    var orderNum = obj.orderNum;
    if (orderNum) {
      return this.service.getIcpOrderDetail(orderNum);
    } else {
      return { code: -100, mag: "订单号不能为空" }
    }
  }
  //修改Icp订单
  async updateIcpOrder(obj, qobj, req) {
    var user = req.session.user;
    if (user) {
      qobj["user"] = user;
      try {
        var result = await this.service.updateIcpOrder(qobj);
        return result;
      } catch (e) {
        //日志记录
        logCtl.error({
          optitle: "修改商标订单错误---error",
          op: "/base/controller/impl/orderCtl.js/updateTmOrder",
          content: e.stack,
          clientIp: req.clientIp
        });
        return { code: -2, msg: "修改订单失败" };
      }
    } else {
      return { code: -1, msg: "用户数据为空" };
    }
  }

  async saveIcpOrder(pobj,obj,req){
    var user = req.session.user;
    if (user) {
      try {
        var result = await this.service.saveIcpOrder(obj,user);
        return result;
      } catch (e) {
        return { code: -2, msg: "修改订单失败" };
      }
    } else {
      return { code: -1, msg: "用户数据为空" };
    }
  }
  //创建商标订单
  async createTmOrder(obj, qobj, req) {
    // console.log(qobj);
    // console.log(req);
    var user = req.session.user;
    if (user) {
      qobj["user"] = user;
      try {
        var result = await this.service.createTmOrder(qobj);
        return result;
      } catch (e) {
        //日志记录
        logCtl.error({
          optitle: "提交商标订单错误---error",
          op: "/base/controller/impl/orderCtl.js/createTmOrder",
          content: e.stack,
          clientIp: req.clientIp
        });
        return { code: -2, msg: "创建订单失败" };
      }
    } else {
      return { code: -1, msg: "用户数据为空" };
    }
  }
  //获取商标订单详情
  async getTmOrderDetail(obj) {
    var orderNum = obj.orderNum;
    if (orderNum) {
      return this.service.getTmOrderDetail(orderNum);
    } else {
      return { code: -100, mag: "订单号不能为空" }
    }
  }
  //获取商标订单详情
  async getItemTmOrderDetail(obj) {
    try {
      var orderNum = obj.orderNum;
      if (!orderNum) {
        return { code: -100, mag: "订单号不能为空" }
      }
      var result = await this.service.findItemByCode(orderNum);
      return { code: 1, data: result };
    } catch (error) {
      return { code: -200, msg: "操作失败", error: error };
    }
  }
  //修改商标订单
  async updateTmOrder(obj, qobj, req) {
    console.log(qobj);
    console.log(req);
    var user = req.session.user;
    if (user) {
      qobj["user"] = user;
      try {
        var result = await this.service.updateTmOrder(qobj);
        return result;
      } catch (e) {
        //日志记录
        logCtl.error({
          optitle: "修改商标订单错误---error",
          op: "/base/controller/impl/orderCtl.js/updateTmOrder",
          content: e.stack,
          clientIp: req.clientIp
        });
        return { code: -2, msg: "修改订单失败" };
      }
    } else {
      return { code: -1, msg: "用户数据为空" };
    }
  }
  //
  //修改平台商机订单订单
  async updatePtsjOrder(obj, qobj, req) {
    console.log(qobj);
    console.log(req);
    var user = req.session.user;
    if (user) {
      qobj["user"] = user;
      try {
        var result = await this.service.updatePtsjOrder(qobj);
        return result;
      } catch (error) {
        return { code: -2, msg: "修改订单失败" };
      }
    } else {
      return { code: -1, msg: "用户数据为空" };
    }
  }

  //删除平台商机订单订单
  async deletePtsjOrder(obj, qobj, req) {
    console.log(qobj);
    console.log(req);
    var user = req.session.user;
    if (user) {
      qobj["user"] = user;
      try {
        var result = await this.service.deletePtsjOrder(qobj);
        return result;
      } catch (error) {
        return { code: -2, msg: "删除订单失败" };
      }
    } else {
      return { code: -1, msg: "用户数据为空" };
    }
  }
  // 线下支付
  async offlinePay(obj, req) {
    console.log(obj);
    var user = req.session.user;
    if (user) {
      obj["user"] = user;
      try {
        var result = await this.service.offlinePay(obj);
        return result;
      } catch (error) {
        console.log(error);
        return { code: -1, mag: "操作失败" };
      }
    } else {
      return { code: -1, mag: "用户信息为空" };
    }
  }
  //撤销审核 用于交付管理》材料审核页面
  async cancelAudit(pobj, obj, req) {
    var user = req.session.user;
    if (!user) {
      return { code: -1, msg: "用户数据不存在" };
    }
    obj["user"] = user;
    try {
      return this.service.cancelAudit(obj);
    } catch (error) {
      return { code: -200, msg: "操作失败" };
    }
  }
  //订单流程审核
  async blukupdate(obj, qobj, req) {
    if (req.codepath) {
      qobj.codepath = req.codepath;
    }
    if (req && req.companyid && req.companyid != "") {
      qobj.company_id = req.companyid;
    }
    if (!qobj.selectedRows || qobj.selectedRows.length == 0) {
      return { status: -100, msg: "审核失败，数据为空!", data: null }
    }
    var tmpFilter = qobj.selectedRows.filter(f => f.orderStatus != "３");
    if (!tmpFilter || tmpFilter.length == 0) {
      return { status: -101, msg: "目前只能对订单状态为【待审核】的数据进行审核!", data: null }
    }
    if (qobj.selectedRows.length != tmpFilter.length) {
      return { status: -102, msg: "选择的订单数据中包含订单状态不是【待审核】的订单!", data: null }
    }
    var otherOrderFilter = qobj.selectedRows.filter(f => f.sveItemCode != "dlrfzzc" && f.sveItemCode != "zzsbzc" && f.sveItemCode != "dbsbzc");
    if (!otherOrderFilter && otherOrderFilter.length > 0) {
      return { status: -101, msg: "目前只能对服务项目含有【商标注册】的数据进行审核!", data: null }
    }
    qobj.updator = qobj.nickName;
    qobj.updateuser_id = qobj.id;
    return await this.service.blukupdate(qobj);
  }

  //交付数统计
  async officialCountByCompany(o, p, r) {
    if (!r.session.user) {
      return { code: -201, msg: "请登录" }
    }
    var companyId = r.session.user.company_id;
    var officialsql = "SELECT COUNT(*) b from (SELECT count(*) from biz_tmofficial where company_id=" + companyId + " and deleted_at is null GROUP BY code) a; "
    var wscsql = "SELECT count(*) b from biz_order where company_id=" + companyId + " and deleted_at is null;"
    var officialCount = await this.service.dao.customQuery(officialsql);
    var wscCount = await this.service.dao.customQuery(wscsql);
    var data = { officialCount: officialCount[0].b, wscCount: wscCount[0].b }
    return { code: 1, msg: "成功", data: data }
  }

  //交付数统计(已审核，未审核)
  async shCountByCompany(o, p, r) {
    if (!r.session.user) {
      return { code: -201, msg: "请登录" }
    }
    var companyId = r.session.user.company_id;
    var ysh = "SELECT count(*) b FROM `biz_order` where orderFlowStatus in ('3','4','5') and company_id=" + companyId + " and deleted_at is null;"
    var wsh = "SELECT count(*) b FROM `biz_order` where orderFlowStatus in ('1','2') and company_id=" + companyId + " and deleted_at is null;"
    var yshCount = await this.service.dao.customQuery(ysh);
    var wshCount = await this.service.dao.customQuery(wsh);
    return { code: 1, msg: "成功", data: { yshCount: yshCount[0].b, wshCount: wshCount[0].b } }
  }

  //交付数统计(按日期)
  async yshCountByCompany(o, p, r) {
    if (!r.session.user) {
      return { code: -201, msg: "请登录" }
    }
    var companyId = r.session.user.company_id;
    var monthysh = "SELECT count(*) b FROM `biz_order` where orderFlowStatus in ('3','4','5') and company_id=" + companyId + " and deleted_at is null and DATE_FORMAT( updated_at, '%Y%m' ) = DATE_FORMAT( CURDATE( ) , '%Y%m' );"
    var allysh = "SELECT count(*) b FROM `biz_order` where orderFlowStatus in ('3','4','5') and company_id=" + companyId + " and deleted_at is null;"
    var monthyshCount = await this.service.dao.customQuery(monthysh);
    var allyshCount = await this.service.dao.customQuery(allysh);
    return { code: 1, msg: "成功", data: { monthyshCount: monthyshCount[0].b, allyshCount: allyshCount[0].b } }
  }

  async findOne(pobj, obj, req) {
    var code = obj.code;
    if (!code) {
      return { code: -1, msg: code参数错误 };
    }
    try {
      var result = await this.service.findOneByCode(code);
      return { code: 1, data: result };
    } catch (error) {
      return { code: -200, msg: "操作失败", error: error };
    }
  }
  async findItemByCode(pobj, obj, req) {
    var wxPayOrderCode = obj.wxPayOrderCode;
    if (!wxPayOrderCode) {
      return { code: -1, msg: "wxPayOrderCode参数错误" };
    }
    var aliPayOrderCode = obj.aliPayOrderCode;
    if (!aliPayOrderCode) {
      return { code: -1, msg: "aliPayOrderCode参数错误" };
    }
    try {
      // var result = await this.service.findItemByCode(code);
      // return { code: 1, data: result };
      obj["client_ip"] = req.clientIp;
      return await this.service.checkPayStatus(obj);
    } catch (error) {
      return { code: -200, msg: "操作失败", error: error };
    }
  }
  async findItemByCodeTl(pobj, obj, req) {
    try {
      obj["client_ip"] = req.clientIp;
      return await this.service.checkPayStatusTl(obj);
    } catch (error) {
      return { code: -200, msg: "操作失败", error: error };
    }
  }
  //取消订单
  async cancelOrderByCode(pobj, obj, req) {
    var user = req.session.user;
    if (user) {
      obj["user"] = user;
      try {
        return this.service.cancelOrderByCode(obj);
      } catch (error) {
        return { code: -100, msg: "操作失败", error: error };
      }
    } else {
      return { code: -1, msg: "用户数据为空" };
    }
  }
  //上传材料(订单列表页直接上传材料)
  async uploadStuffs(pobj, obj, req) {
    var user = req.session.user;
    if (user) {
      obj["user"] = user;
      try {
        return this.service.uploadStuffs(obj);
      } catch (error) {
        return { code: -200, msg: "操作失败", err: error };
      }
    } else {
      return { code: -201, msg: "用户数据为空" };
    }
  }
  //订单结算分润
  async orderSettlement(qobj, obj, req) {
    var user = req.session.user;
    if (user) {
      obj["user"] = user;
      try {
        var result = await this.service.orderSettlement(obj);
        return result;
      } catch (e) {
        //日志记录
        logCtl.error({
          optitle: "订单结算分润---error",
          op: "/base/controller/impl/orderCtl.js/orderSettlement",
          content: e.stack,
          clientIp: req.clientIp
        });
        return { code: -201, msg: "操作异常" };
      }
    } else {
      return { code: -200, msg: "用户数据为空" };
    }
  }
  async getQrCode(qobj, obj, req) {//获取中信支付二维码信息
    try {
      obj["client_ip"] = req.clientIp;
      return await this.service.getQrCodeInfo(obj);
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "获取支付二维码错误---error",
        op: "/base/controller/impl/orderCtl.js/getQrCode",
        content: e.stack,
        clientIp: req.clientIp
      });
    }
  }
  async getQrCodeTl(qobj, obj, req) {//获取通联支付二维码信息
    try {
      obj["client_ip"] = req.clientIp;
      return await this.service.getQrCodeInfoTl(obj);
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "获取支付二维码错误---error",
        op: "/base/controller/impl/orderCtl.js/getQrCode",
        content: e.stack,
        clientIp: req.clientIp
      });
    }
  }
  async getOrderTotal(gobj, pobj, req) {//获得订单某一状态下的订单列表数据统计-(待付款，已付款，已完成)
    try {
      var user = req.session.user;
      if (!user) {
        return { code: -100, msg: "用户未登录", data: {} };
      }
      var productonetypeid_list = pobj.productonetypeid_list || "";
      if (!productonetypeid_list) {
        return { code: -110, msg: "productonetypeid_list不能为空", data: {} };
      }
      return await this.service.getOrderInfo(user.mobile, user.id, user.company_id, productonetypeid_list);
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "获得订单统计信息异常---error",
        op: "/base/controller/impl/orderCtl.js/getOrderTotal",
        content: e.stack,
        clientIp: req.clientIp
      });
      return { code: -200, msg: "error", data: {} };
    }
  }

  async getOrderListByStatus(gobj, pobj, req) {//获得订单某一状态下的订单列表数据-(待付款，已付款，已完成)
    try {
      var user = req.session.user;
      if (!user) {
        return { code: -100, msg: "用户未登录", data: {} };
      }
      var page_index = pobj.page_index || 1;
      var page_size = pobj.page_size || 10;
      var productonetypeid_list = pobj.productonetypeid_list || "";
      if (!productonetypeid_list) {
        return { code: -110, msg: "productonetypeid_list不能为空", data: {} };
      }
      var flow_status = pobj.flow_status || "-1";
      return await this.service.getOrderList(page_index, page_size, user.mobile, user.id, user.company_id, productonetypeid_list, flow_status);
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "获得订单统计信息异常---error",
        op: "/base/controller/impl/orderCtl.js/getOrderListByStatus",
        content: e.stack,
        clientIp: req.clientIp
      });
    }
    return { code: -200, msg: "error", data: [] };
  }
}
module.exports = OrderCtl;
