var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class MoneyAccountCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(MoneyAccountCtl));
    this.companySve = system.getObject("service.companySve");
  }
  async fetchAccountForBoss(qobj, obj, req) {//公司账户列表余额展示-------============XXXX
    var result = await this.service.fetchAccountForBoss(req.companyid);
    return system.getResult2(result);
  }
  async findAllByCompanyId(qobj, obj, req) {
    var user = req.session.user;
    if (!user) {
      return { code: -1, msg: "操作失败,用户信息为空" };
    }
    if (!obj.company_id) {
      return { code: -2, msg: "参数错误" };
    }
    try {
      var data = await this.service.findAllByCompanyId(obj.company_id);
      return { code: 1, data: data };
    } catch (error) {
      return { code: -1, msg: "操作失败" };
    }
  }
  async findAll(qobj, obj, req) {
    var user = req.session.user;
    if (user) {
      try {
        var data = await this.service.dao.model.findAll({ where: { company_id: user.company_id }, raw: true });
        return { code: 1, data: data };
      } catch (error) {
        return { code: -1, msg: "操作失败" };
      }

    } else {
      return { code: -1, msg: "操作失败,用户信息为空" };
    }

  }
  async findAllOfflineAccount(qobj, obj, req) {
    var user = req.session.user;
    if (user) {
      try {
        if (!user.company_id) {
          return { code: -3, msg: "company_id参数错误" };
        }
        var company = await this.companySve.dao.model.findOne({ where: { id: user.company_id, isEnabled: 1 }, raw: true });
        if (!company) {
          return { code: -2, msg: "操作失败,公司信息为空" };
        }
        var data = null;
        if (company.companyType == "self") {
          data = await this.service.dao.model.findAll({ where: { company_id: user.company_id, isOfflinePay: 1 }, 'order': [['created_at', 'ASC']], raw: true });
        } else {
          data = await this.service.dao.model.findAll({ where: { company_id: 1, isOfflinePay: 1 }, 'order': [['created_at', 'ASC']], raw: true });
        }
        if (!data) {
          return { code: -4, msg: "账户信息不存在" };
        }
        return { code: 1, data: data };
      } catch (error) {
        return { code: -1, msg: "操作失败" };
      }

    } else {
      return { code: -1, msg: "操作失败,用户信息为空" };
    }

  }
}
module.exports = MoneyAccountCtl;
