var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class LoopplayCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(LoopplayCtl));
    //this.appS=system.getObject("service.appSve");
  }
  async initNewInstance(queryobj, req) {
    var rtn = {};
    var vcode = await this.service.getBusUid("lx");
    rtn.code = vcode;
    return system.getResult2(rtn, null);
  }
  async  findById(q, oid) {
    return super.findById(Number(oid.id));
  }
  async findByChannelcode(qobj, obj, req) {
    if (obj.channelcode == null || obj.channelcode == "" || obj.channelcode == "undefined") {
      return { code: -1, msg: "参数channelcode错误" };
    }
    obj.company_id = req.companyid;
    var result = await this.service.findByChannelcode(obj);
    return { code: 1, msg: "success", data: result };
  }

  async findAll2(hostname, themename) {
    var lbs = await this.cacheManager["LoopbackCache"].cacheLoopback(hostname, themename);
    return lbs;
  }

  async findAll(queryobj, obj, req) {
    var lbs = await this.cacheManager["LoopbackCache"].cacheLoopback(req.hostname, req.theme);
    return system.getResult2(lbs, null);
  }
  async findAndCountAll(queryobj, obj, req) {
    obj.codepath = req.codepath;
    if (req.companyid && req.companyid != "" && obj.search) {
      obj.search.company_id = req.companyid;
    }
    if (req.session.user) {
      obj.uid = req.session.user.id;
      obj.appid = req.session.user.app_id;
      obj.onlyCode = req.session.user.unionId;
      obj.account_id = req.session.user.account_id;
      obj.ukstr = req.session.user.app_id + "￥" + req.session.user.id + "￥" + req.session.user.nickName + "￥" + req.session.user.headUrl;
    }

    var apps = await this.service.findAndCountAll(obj);
    return system.getResult2(apps, null);
  }
  //获取轮播图列表
  async getLooppayList(gobj, pobj, req) {
    try {
      var hostname = req.hostname;
      var themename = pobj.theme_name || "";
      var loopType = pobj.loop_type || ["PC"];
      var returnList = [];
      if (loopType.length) {
        for (let index = 0; index < loopType.length; index++) {
          const element = loopType[index];
          if (element) {
            var list = await this.cacheManager["LoopbackCache"].cacheLoopback(hostname, themename, loopType);
            if (list.length > 0) {
              returnList.push.apply(returnList, list);
            }
          }
        }
      }
      return { code: 1, msg: "ok", data: returnList };
    } catch (e) {
      return { code: -200, msg: "error", data: [] };
    }

  }
}
module.exports = LoopplayCtl;
