var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class companyCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(companyCtl));
    this.userSve = system.getObject("service.userSve");
    this.footerinfoSve = system.getObject("service.footerinfoSve");
    this.moneyaccountS = system.getObject("service.moneyaccountSve");
  }
  //初始化产品类型和产品 角色 默认授权
  async initdata(pobj, obj, req) {
    if (obj.isEnabled) {
      await this.service.companyInitdata(obj);
    }
    //更新公司启用
    var rd = await this.service.update(obj);
    return system.getResult2(rd, null);
  };
  async siteupdate(qobj, pobj, req) {
    //创建管理员用户
    var userReg = {
      id: req.session.user.id,
      userName: pobj.u.userName,
      password: super.encryptPasswd(pobj.u.password),
      nickName: pobj.u.nickName,
      mobile: pobj.u.mobile,
      isAdmin: true,
      companyName: pobj.u.companyName,
    };
    var user = await this.userSve.update(userReg);
    var companyInfo = {
      id: pobj.u.id,
      name: pobj.u.companyName,
      sitename: pobj.u.sitename,
      domainname: pobj.u.domainname,
      subdomainname: pobj.u.domainname,
      contact: pobj.u.nickName,
      contactmobile: pobj.u.mobile,
      logo: pobj.u.logo,
      serviceqq: pobj.u.serviceqq,
      zipCode: pobj.u.zipCode,
      isEnabled: false,
    };
    var bankaccountinfo = {
      code: pobj.u.moneyaccountcode,
      name: pobj.u.moneyaccountname,
      payeeName: pobj.u.payeeName,
      id: pobj.u.moneyaccountid,
    };
    var user = await this.service.siteupdate(companyInfo, bankaccountinfo);
    return system.getResult2(pobj.u, null);
  }
  async siteapply(qobj, pobj, req) {
    // console.log(pobj.u);
    //创建管理员用户
    var userReg = {
      userName: pobj.u.userName,
      password: super.encryptPasswd(pobj.u.password),
      nickName: pobj.u.nickName,
      mobile: pobj.u.mobile,
      isAdmin: true,
      companyName: pobj.u.companyName,
    };
    var user = await this.userSve.findOne({ userName: pobj.u.userName });
    if (user) {
      return system.getErrResult2("帐号已存在, 请修改并重试");
    }
    //检查域名唯一性，子域名唯一性
    var comtmp = await this.service.findOne({ domainname: pobj.u.domainname });
    if (comtmp) {
      return system.getErrResult2("域名已存在, 请修改并重试");
    }
    var comtmp2 = await this.service.findOne({ subdomainname: pobj.u.subdomainname });
    if (comtmp2) {
      return system.getErrResult2("子域名已存在, 请修改并重试");
    }
    var companyInfo = {
      name: pobj.u.companyName,
      sitename: pobj.u.sitename,
      domainname: pobj.u.domainname,
      subdomainname: pobj.u.domainname,
      contact: pobj.u.nickName,
      contactmobile: pobj.u.mobile,
      logo: pobj.u.logo,
      serviceqq: pobj.u.serviceqq,
      zipCode: pobj.u.zipCode,
      // wxappid:pobj.u.wxappid,
      // wxsecstr:pobj.u.wxsecstr,
      // wxsectoken:pobj.u.wxsectoken,
      // wxseccert:pobj.u.wxseccert,
      // mechantid:pobj.u.mechantid,
      // mechantkey:pobj.u.mechantkey,
      // mechantcerturl:pobj.u.mechantcerturl,
      isEnabled: false,
    };
    var bankaccountinfo = {
      code: pobj.u.moneyaccountcode,
      name: pobj.u.moneyaccountname,
      payeeName: pobj.u.payeeName,
    };
    var companyInfo = await this.service.siteapply(userReg, companyInfo, bankaccountinfo);
    return system.getResult2(companyInfo, null);
  }
  async getInitCompanyInfo(qobj, pobj, req) {
    var rtn = {};
    var footerinfo = await this.footerinfoSve.findOne({ company_id: pobj.id });
    var c = await this.service.findById(pobj.id);
    rtn.footerinfo = footerinfo;
    rtn.company = c;
    return system.getResult2(rtn, null);
  }
  async findById(obj, req) {
    var cid = obj.cid
    var rd = await this.service.findById(cid);
    return system.getResult2(rd, null);
  }
  async findById2(obj, req) {
    var user = req.session.user;
    if (!user) {
      return { code: -1, mag: "用户信息为空" }
    }
    var oid = user.company_id
    var rd = await this.service.findById(oid);
    return system.getResult2(rd, null);
  }
  //站点统计站点订单合计
  async findAndCountAll2(queryobj, obj, req) {
    obj.codepath = req.codepath;
    if (req.session.user) {
      obj.uid = req.session.user.id;
    }
    if (req.codepath.indexOf("pmg") < 0 && req.companyid && req.companyid != "" && obj.search) {
      obj.search.company_id = req.companyid;
    }
    var apps = await this.service.siteOrderStatistic(obj);
    // apps = apps.get({raw:true});
    console.log(system.getResult2(apps, null));
    return system.getResult2(apps, null);
  }
  //站点线索统计
  async siteBusinessStatistic(queryobj, obj, req) {
    try {
      var apps = await this.service.siteBusinessStatistic(obj);
      return system.getResult2(apps, null);
    } catch (error) {
      return system.getResult2(null, null);
    }
  }
  async getCompanyTheme(qobj, pobj, req) {
    try {
      if (!req.session.user) {
        return { code: -100, msg: "用户未登录" }
      }
      return await this.service.getCompanyThemeById(req.session.user.company_id);
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "查询公司主题异常error",
        op: "/base/controller/impl/companyCtl.js/getCompanyTheme",
        content: e.stack,
        clientIp: ""
      });
      return { code: -200, msg: "操作异常" }
    }
  }
  async putCompanyTheme(qobj, pobj, req) {
    try {
      var sitetheme = pobj.siteTheme || "";
      if (!req.session.user) {
        return { code: -100, msg: "用户未登录" }
      }
      if (!sitetheme) {
        return { code: -101, msg: "主题参数有误" }
      }
      return await this.service.putCompanyThemeById(req.session.user.company_id, req.session.user.id, sitetheme);
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "修改公司主题异常error",
        op: "/base/controller/impl/companyCtl.js/putCompanyTheme",
        content: e.stack,
        clientIp: ""
      });
      return { code: -200, msg: "操作异常" }
    }

  }
}
module.exports = companyCtl;
