var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class BusinessCompanyCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(BusinessCompanyCtl));
  }
  async getBusinessDetail(qobj,obj,req){
    var user = req.session.user;
    if(user){
      obj["user"]=user;
      try {
        return this.service.getBusinessDetail(obj);
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "获取商机详情getBusinessDetail异常error",
          op: "base/controller/impl/businesscompanyCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-200,msg:"操作失败"};
      }
      
    }else{
      return {code:-201,msg:"用户数据为空"};
    }
  }
  async updateBusinessStatus(qobj,obj,req){
    var user = req.session.user;
    if(user){
      // user：用好
      // code：商机公司code
      // opType：操作类型（1无效电话，2商机无效）
      if(!obj.code){
        return {code:-202,msg:"code参数错误"};
      }
      if(!obj.opType){
        return {code:-203,msg:"opType参数错误"};
      }
      try {
        return this.service.updateBusinessStatus(user,obj.code,obj.opType);
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "修改商机状态updateBusinessStatus异常error",
          op: "base/controller/impl/businesscompanyCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-200,msg:"操作失败"};
      }
      
    }else{
      return {code:-201,msg:"用户数据为空"};
    }
  }
  //免费认领商机
  async freeClaimOperation(pobj,obj,req){
    var user = req.session.user;
    if(user){
      try {
        var bus_type = obj.bus_type;
        var ids = obj.ids;
        if(!bus_type){
          return {code:-1,msg:"bus_type参数错误"};
        }
        if(!ids || ids.length<1){
          return {code:-2,msg:"ids参数错误"};
        }
        var result = await this.service.freeClaimOperation(user,bus_type,ids);
        return result;
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "免费认领商机freeClaimOperation异常error",
          op: "base/controller/impl/businesscompanyCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-100,msg:"操作失败"};
      }
    }else{
      return {code:-200,msg:"用户数据为空"};
    }
  }
  //保护商机操作
  async protectBus(pobj,obj,req){
    var user = req.session.user;
    if(user){
      try {
        var bus_type = obj.bus_type;
        var code_list = obj.code_list;
        if(!bus_type){
          return {code:-1,msg:"bus_type参数错误"};
        }
        if(!code_list || code_list.length<1){
          return {code:-2,msg:"code_list参数错误"};
        }
        var result = await this.service.protectBus(user,bus_type,code_list);
        return result;
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "保护商机操作protectBus异常error",
          op: "base/controller/impl/businesscompanyCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-100,msg:"操作失败"};
      }
    }else{
      return {code:-200,msg:"用户数据为空"};
    }
  }
  //修改客户意向
  async updateCustomerIntention(pobj,obj,req){
    var user = req.session.user;
    if(user){
      if(!obj.customer_intention){
        return {code:-201,msg:"customer_intention参数错误"};
        
      }
      if(!obj.code){
        return {code:-202,msg:"code参数错误"};
      }
      try {
        return this.service.updateCustomerIntention(obj);
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "修改客户意向updateCustomerIntention异常error",
          op: "base/controller/impl/businesscompanyCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-203,msg:"操作失败"};
      }
    }else{
      return {code:-200,msg:"用户数据为空"};
    }
  }
  //提交客户意向
  async submitCustomerIntention(pobj,obj,req){
    var user = req.session.user;
    if(user){
      obj["user"]=user;
      if(!obj.customer_intention){
        return {code:-201,msg:"customer_intention参数错误"};
        
      }
      if(!obj.code){
        return {code:-202,msg:"code参数错误"};
      }
      try {
        return this.service.submitCustomerIntention(obj);
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "修改客户意向updateCustomerIntention异常error",
          op: "base/controller/impl/businesscompanyCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-203,msg:"操作失败"};
      }
    }else{
      return {code:-200,msg:"用户数据为空"};
    }
  }
  //获取该业务员累计商机数量 商标数量 下单数量
  async getBusinessStatisticForSalesman(obj,req) {//obj.statisticType: 1累计统计，2当月统计
    var user = req.session.user;
    if(user){
      try {
        return this.service.getBusinessStatisticForSalesman(user.company_id,user.id,obj.statisticType || null);
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "获取该业务员累计商机数量 商标数量 下单数量getBusinessStatisticForSalesman异常error",
          op: "base/controller/impl/businesscompanyCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-203,msg:"操作失败"};
      }
    }else{
      return {code:-200,msg:"用户数据为空"};
    }
  }

   //获取该公司所有员工累计商机数量 商标数量 下单数量============XXXX
   async getBusinessStatisticForBoss(obj,req) {//obj.statisticType: 1累计统计，2当月统计
    var user = req.session.user;
    if(user){
      try {
        return this.service.getBusinessStatisticForBoss(user.company_id,obj.statisticType || null);
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "获取该公司所有员工累计商机数量 商标数量 下单数量getBusinessStatisticForBoss异常error",
          op: "base/controller/impl/businesscompanyCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-203,msg:"操作失败"};
      }
    }else{
      return {code:-200,msg:"用户数据为空"};
    }

  }
}
module.exports = BusinessCompanyCtl;
