var System=require("../../system");
var settings=require("../../../config/settings");
var moment=require('moment');
const ApiBase =require("../api.base");
class MagicSearchApi extends ApiBase{
    constructor(){
      super();
      this.msgicSearchUrl=settings.apiconfig.magicSearchUrl();
    };

    async magiccompanyname(obj){//工商数据名字查询
      console.log("---------------------------------------");
      console.log(obj);
      // var usc_code=obj.usc_code;
      var company_name=obj.company_name;
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "should":[]
           }
         },
         "_source": [
           "company_name",//公司名称
           "english_company_name",//公司英文名称
           "old_company_name",//公司曾用名
           "legal_persion_id",//法人ID
           "legal_persion_name",//法人姓名
           "legal_persion_type",//法人类型
           "usc_code",//统一社会信用代码
           "reg_number",//注册号
           "company_org_type",//公司类型
           "reg_location",//注册地址
           "establish_time",//公司注册时间
           "business_scope",//经营范围
           "from_time",//营业期限开始日期
           "to_time",//营业期限终止日期
           "reg_institute",//登记机关
           "reg_status",//企业状态
           "reg_capital",//注册资金
           "reg_capital_unit",//注册资金货币单位
           "actual_capital",//实收注册资金
           "org_number",//组织机构代码
           "list_code",//上市代码
           "cancel_time",//注销时间
           "approved_time",//核准日期
           "legal_persion_type",//法人类型，1 人 2 公司
           "new_company_name_id",// 变更后新公司的名字
           "company_province",//公司省份
           "company_city",//公司二级市
           "company_cate_1",//行业类别
           "company_cate_2",
           "company_cate_3",
         ]
      };
      if(company_name!=""&&company_name!=null){
        var param=  {
            "term": {
              "company_name.raw": company_name
            }
        }
        params.query.bool.should.push(param)
      }

      // if(usc_code!=""&&usc_code!=null){
      //   var param=  {
      //     "term": {
      //         "usc_code": usc_code
      //     }
      //   }
      //   params.query.bool.should.push(param)
      // }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
    async magicEssearch(obj){//数据魔方查询
      console.log("---------------------------------------");
      console.log(obj);
      var datestart=obj.datestart;
      var dateend=obj.dateend;
      var checkedStatu=obj.checkedStatu;
      var companyType=obj.companyType;
      var industry=obj.industry;
      var province=obj.province;
      var capitalstart=obj.capitalstart;
      var capitalend=obj.capitalend;
      var businessScope=obj.businessScope;
      var pagesize=obj.pagesize==null?15:obj.pagesize;
      if(obj.page==null){
        var from = 0;
      }else{
        var from = Number((obj.page-1)*obj.pagesize);
      }
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "must":[]
           }
         },
         "from": from,
         "size": pagesize,
         "_source": [
           "company_name",//公司名称
           "english_company_name",//公司英文名称
           "old_company_name",//公司曾用名
           "legal_persion_id",//法人ID
           "legal_persion_name",//法人姓名
           "legal_persion_type",//法人类型
           "usc_code",//统一社会信用代码
           "reg_number",//注册号
           "company_org_type",//公司类型
           "reg_location",//注册地址
           "establish_time",//公司注册时间
           "business_scope",//经营范围
           "from_time",//营业期限开始日期
           "to_time",//营业期限终止日期
           "reg_institute",//登记机关
           "reg_status",//企业状态
           "reg_capital",//注册资金
           "reg_capital_unit",//注册资金货币单位
           "actual_capital",//实收注册资金
           "org_number",//组织机构代码
           "list_code",//上市代码
           "cancel_time",//注销时间
           "approved_time",//核准日期
           "legal_persion_type",//法人类型，1 人 2 公司
           "new_company_name_id",// 变更后新公司的名字
           "company_province",//公司省份
           "company_city",//公司二级市
           "company_cate_1",//行业类别
         ],
         "sort":{
           "establish_time":"desc"
         }
      };
      if(datestart!=""&&dateend!=""){
        var datestart=datestart.replace("-", "");
        var dateend=dateend.replace("-", "");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      if(datestart==""&&dateend==""){
        var nowdate = new Date();
        var dateend = new Date();
        var datestart=nowdate.setMonth(nowdate.getMonth()-6);
        datestart = moment(datestart).format("YYYYMM");
        dateend = moment(dateend).format("YYYYMM");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      // if(datestart!=""&&dateend==""){
      //   var dateend = new Date();
      //   dateend = moment(dateend).format("YYYY-MM");
      //   var param=  {
      //       "range": {
      //         "establish_month":{
      //           "gte": datestart,
      //           "lte":dateend
      //         }
      //       }
      //   }
      //   params.query.bool.must.push(param)
      // }
      if(checkedStatu.length>0){
        var param=  {
            "terms": {
              "reg_status": checkedStatu
            }
        }
        params.query.bool.must.push(param)
      }
      if(companyType.length>0){
        var param=  {
            "terms": {
              "company_org_type": companyType
            }
        }
        params.query.bool.must.push(param)
      }
      if(industry.length>0){
        var param=  {
            "terms": {
              "company_cate_1": industry
            }
        }
        params.query.bool.must.push(param)
      }
      if(province.length>0){
        var param=  {
            "terms": {
              "company_province": province
            }
        }
        params.query.bool.must.push(param)
      }
      if(capitalstart!=""&&capitalend!=""){
        var param=  {
          "range": {
            "reg_capital":{
              "gte": capitalstart,
              "lte":capitalend
            }
          }
        }
        params.query.bool.must.push(param)
      }
      if(businessScope!=""&&businessScope!=null){
        var param=  {
          "query_string": {
              "default_field": "business_scope",
              "query": "\""+businessScope+"\""
          }
        }
        params.query.bool.must.push(param)
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
    async magicEssearchJuhe(obj){//数据魔方查询日期聚合
      console.log("---------------------------------------");
      console.log(obj);
      var datestart=obj.datestart;
      var dateend=obj.dateend;
      var checkedStatu=obj.checkedStatu;
      var companyType=obj.companyType;
      var industry=obj.industry;
      var province=obj.province;
      var capitalstart=obj.capitalstart;
      var capitalend=obj.capitalend;
      var businessScope=obj.businessScope;
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "must":[]
           }
         },
         "aggregations": {
           "types": {
             "terms": {
               "field": "establish_month",
               "size":1000,
               "order": { "_term" : "asc" }
             }
           }
         }
      };
      if(datestart!=""&&dateend!=""){
        var datestart=datestart.replace("-", "");
        var dateend=dateend.replace("-", "");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      if(datestart==""&&dateend==""){
        var nowdate = new Date();
        var dateend = new Date();
        var datestart=nowdate.setMonth(nowdate.getMonth()-6);
        datestart = moment(datestart).format("YYYYMM");
        dateend = moment(dateend).format("YYYYMM");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      // if(datestart!=""&&dateend==""){
      //   var dateend = new Date();
      //   dateend = moment(dateend).format("YYYY-MM");
      //   var param=  {
      //       "range": {
      //         "establish_month":{
      //           "gte": datestart,
      //           "lte":dateend
      //         }
      //       }
      //   }
      //   params.query.bool.must.push(param)
      // }
      if(checkedStatu.length>0){
        var param=  {
            "terms": {
              "reg_status": checkedStatu
            }
        }
        params.query.bool.must.push(param)
      }
      if(companyType.length>0){
        var param=  {
            "terms": {
              "company_org_type": companyType
            }
        }
        params.query.bool.must.push(param)
      }
      if(industry.length>0){
        var param=  {
            "terms": {
              "company_cate_1": industry
            }
        }
        params.query.bool.must.push(param)
      }
      if(province.length>0){
        var param=  {
            "terms": {
              "company_province": province
            }
        }
        params.query.bool.must.push(param)
      }
      if(capitalstart!=""&&capitalend!=""){
        var param=  {
          "range": {
            "reg_capital":{
              "gte": capitalstart,
              "lte":capitalend
            }
          }
        }
        params.query.bool.must.push(param)
      }
      if(businessScope!=""&&businessScope!=null){
        var param=  {
          "query_string": {
              "default_field": "business_scope",
              "query": "\""+businessScope+"\""
          }
        }
        params.query.bool.must.push(param)
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResultjuhe(j,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }

    async magicEssearchmonth(obj){//根据月份查询数据
      console.log("---------------------------------------");
      console.log(obj);
      var monthtime=obj.monthtime;
      var checkedStatu=obj.checkedStatu;
      var companyType=obj.companyType;
      var industry=obj.industry;
      var province=obj.province;
      var capitalstart=obj.capitalstart;
      var capitalend=obj.capitalend;
      var businessScope=obj.businessScope;
      var pagesize=obj.pagesize==null?15:obj.pagesize;
      if(obj.page==null){
        var from = 0;
      }else{
        var from = Number((obj.page-1)*obj.pagesize);
      }
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "must":[]
           }
         },
         "from": from,
         "size": pagesize,
         "_source": [
           "company_name",//公司名称
           "english_company_name",//公司英文名称
           "old_company_name",//公司曾用名
           "legal_persion_id",//法人ID
           "legal_persion_name",//法人姓名
           "legal_persion_type",//法人类型
           "usc_code",//统一社会信用代码
           "reg_number",//注册号
           "company_org_type",//公司类型
           "reg_location",//注册地址
           "establish_time",//公司注册时间
           "business_scope",//经营范围
           "from_time",//营业期限开始日期
           "to_time",//营业期限终止日期
           "reg_institute",//登记机关
           "reg_status",//企业状态
           "reg_capital",//注册资金
           "reg_capital_unit",//注册资金货币单位
           "actual_capital",//实收注册资金
           "org_number",//组织机构代码
           "list_code",//上市代码
           "cancel_time",//注销时间
           "approved_time",//核准日期
           "legal_persion_type",//法人类型，1 人 2 公司
           "new_company_name_id",// 变更后新公司的名字
           "company_province",//公司省份
           "company_city",//公司二级市
           "company_cate_1",//行业类别
         ]
      };
      if(monthtime!=""&&monthtime!=null){
        var param=  {
            "term": {
              "establish_month": monthtime
            }
        }
        params.query.bool.must.push(param)
      }
      if(checkedStatu.length>0){
        var param=  {
            "terms": {
              "reg_status": checkedStatu
            }
        }
        params.query.bool.must.push(param)
      }
      if(companyType.length>0){
        var param=  {
            "terms": {
              "company_org_type": companyType
            }
        }
        params.query.bool.must.push(param)
      }
      if(industry.length>0){
        var param=  {
            "terms": {
              "company_cate_1": industry
            }
        }
        params.query.bool.must.push(param)
      }
      if(province.length>0){
        var param=  {
            "terms": {
              "company_province": province
            }
        }
        params.query.bool.must.push(param)
      }
      if(capitalstart!=""&&capitalend!=""){
        var param=  {
          "range": {
            "reg_capital":{
              "gte": capitalstart,
              "lte":capitalend
            }
          }
        }
        params.query.bool.must.push(param)
      }
      if(businessScope!=""&&businessScope!=null){
        var param=  {
          "query_string": {
              "default_field": "business_scope",
              "query": "\""+businessScope+"\""
          }
        }
        params.query.bool.must.push(param)
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
    async magicdetailapi(obj){//工商数据详情信息查询
      console.log("---------------------------------------");
      console.log(obj);
      var usc_code=obj.usc_code;
      var company_name=obj.company_name;
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "should":[]
           }
         },
         "_source": [
           "company_name",//公司名称
           "english_company_name",//公司英文名称
           "old_company_name",//公司曾用名
           "legal_persion_id",//法人ID
           "legal_persion_name",//法人姓名
           "legal_persion_type",//法人类型
           "usc_code",//统一社会信用代码
           "reg_number",//注册号
           "company_org_type",//公司类型
           "reg_location",//注册地址
           "establish_time",//公司注册时间
           "business_scope",//经营范围
           "from_time",//营业期限开始日期
           "to_time",//营业期限终止日期
           "reg_institute",//登记机关
           "reg_status",//企业状态
           "reg_capital",//注册资金
           "reg_capital_unit",//注册资金货币单位
           "actual_capital",//实收注册资金
           "org_number",//组织机构代码
           "list_code",//上市代码
           "cancel_time",//注销时间
           "approved_time",//核准日期
           "legal_persion_type",//法人类型，1 人 2 公司
           "new_company_name_id",// 变更后新公司的名字
           "company_province",//公司省份
           "company_city",//公司二级市
           "company_cate_1",//行业类别
         ]
      };
      if(company_name!=""&&company_name!=null){
        var param=  {
            "term": {
              "company_name.raw": company_name
            }
        }
        params.query.bool.should.push(param)
      }

      if(usc_code!=""&&usc_code!=null){
        var param=  {
          "term": {
              "usc_code": usc_code
          }
        }
        params.query.bool.should.push(param)
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
    async comparetimeEssearch(obj){//工商数据时间对比
      console.log("---------------------------------------");
      console.log(obj);
      var datestart=obj.datestart;
      var dateend=obj.dateend;
      var checkedStatu=obj.checkedStatu;
      var companyType=obj.companyType;
      var industry=obj.industry;
      var province=obj.province;
      var capitalstart=obj.capitalstart;
      var capitalend=obj.capitalend;
      var businessScope=obj.businessScope;
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "must":[]
           }
         },
         "size": 0
      };
      if(datestart!=""&&dateend!=""){
        var datestart=datestart.replace("-", "");
        var dateend=dateend.replace("-", "");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      if(checkedStatu.length>0){
        var param=  {
            "terms": {
              "reg_status": checkedStatu
            }
        }
        params.query.bool.must.push(param)
      }
      if(companyType.length>0){
        var param=  {
            "terms": {
              "company_org_type": companyType
            }
        }
        params.query.bool.must.push(param)
      }
      if(industry.length>0){
        var param=  {
            "terms": {
              "company_cate_1": industry
            }
        }
        params.query.bool.must.push(param)
      }
      if(province.length>0){
        var param=  {
            "terms": {
              "company_province": province
            }
        }
        params.query.bool.must.push(param)
      }
      if(capitalstart!=""&&capitalend!=""){
        var param=  {
          "range": {
            "reg_capital":{
              "gte": capitalstart,
              "lte":capitalend
            }
          }
        }
        params.query.bool.must.push(param)
      }
      if(businessScope!=""&&businessScope!=null){
        var param=  {
          "query_string": {
              "default_field": "business_scope",
              "query": "\""+businessScope+"\""
          }
        }
        params.query.bool.must.push(param)
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
    async compareprovinceEssearch(obj){//工商数据地区对比
      console.log("---------------------------------------");
      console.log(obj);
      var datestart=obj.datestart;
      var dateend=obj.dateend;
      var checkedStatu=obj.checkedStatu;
      var companyType=obj.companyType;
      var industry=obj.industry;
      var province=obj.province;
      var capitalstart=obj.capitalstart;
      var capitalend=obj.capitalend;
      var businessScope=obj.businessScope;
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "must":[]
           }
         },
         "size": 0
      };
      if(datestart!=""&&dateend!=""){
        var datestart=datestart.replace("-", "");
        var dateend=dateend.replace("-", "");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      if(datestart==""&&dateend==""){
        var nowdate = new Date();
        var dateend = new Date();
        var datestart=nowdate.setMonth(nowdate.getMonth()-6);
        datestart = moment(datestart).format("YYYYMM");
        dateend = moment(dateend).format("YYYYMM");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      // if(datestart!=""&&dateend==""){
      //   var dateend = new Date();
      //   dateend = moment(dateend).format("YYYY-MM");
      //   var param=  {
      //       "range": {
      //         "establish_month":{
      //           "gte": datestart,
      //           "lte":dateend
      //         }
      //       }
      //   }
      //   params.query.bool.must.push(param)
      // }
      if(checkedStatu.length>0){
        var param=  {
            "terms": {
              "reg_status": checkedStatu
            }
        }
        params.query.bool.must.push(param)
      }
      if(companyType.length>0){
        var param=  {
            "terms": {
              "company_org_type": companyType
            }
        }
        params.query.bool.must.push(param)
      }
      if(industry.length>0){
        var param=  {
            "terms": {
              "company_cate_1": industry
            }
        }
        params.query.bool.must.push(param)
      }
      if(province!=""&&province!=null){
        var param=  {
            "term": {
              "company_province": province
            }
        }
        params.query.bool.must.push(param)
      }
      if(capitalstart!=""&&capitalend!=""){
        var param=  {
          "range": {
            "reg_capital":{
              "gte": capitalstart,
              "lte":capitalend
            }
          }
        }
        params.query.bool.must.push(param)
      }
      if(businessScope!=""&&businessScope!=null){
        var param=  {
          "query_string": {
              "default_field": "business_scope",
              "query": "\""+businessScope+"\""
          }
        }
        params.query.bool.must.push(param)
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
    async compareindustryEssearch(obj){//工商数据行业对比
      console.log("---------------------------------------");
      console.log(obj);
      var datestart=obj.datestart;
      var dateend=obj.dateend;
      var checkedStatu=obj.checkedStatu;
      var companyType=obj.companyType;
      var industry=obj.industry;
      var province=obj.province;
      var capitalstart=obj.capitalstart;
      var capitalend=obj.capitalend;
      var businessScope=obj.businessScope;
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "must":[]
           }
         },
         "size": 0
      };
      if(datestart!=""&&dateend!=""){
        var datestart=datestart.replace("-", "");
        var dateend=dateend.replace("-", "");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      if(datestart==""&&dateend==""){
        var nowdate = new Date();
        var dateend = new Date();
        var datestart=nowdate.setMonth(nowdate.getMonth()-6);
        datestart = moment(datestart).format("YYYYMM");
        dateend = moment(dateend).format("YYYYMM");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      // if(datestart!=""&&dateend==""){
      //   var dateend = new Date();
      //   dateend = moment(dateend).format("YYYY-MM");
      //   var param=  {
      //       "range": {
      //         "establish_month":{
      //           "gte": datestart,
      //           "lte":dateend
      //         }
      //       }
      //   }
      //   params.query.bool.must.push(param)
      // }
      if(checkedStatu.length>0){
        var param=  {
            "terms": {
              "reg_status": checkedStatu
            }
        }
        params.query.bool.must.push(param)
      }
      if(companyType.length>0){
        var param=  {
            "terms": {
              "company_org_type": companyType
            }
        }
        params.query.bool.must.push(param)
      }
      if(industry!=""&&industry!=null){
        var param=  {
            "term": {
              "company_cate_1": industry
            }
        }
        params.query.bool.must.push(param)
      }
      if(province.length>0){
        var param=  {
            "terms": {
              "company_province": province
            }
        }
        params.query.bool.must.push(param)
      }
      if(capitalstart!=""&&capitalend!=""){
        var param=  {
          "range": {
            "reg_capital":{
              "gte": capitalstart,
              "lte":capitalend
            }
          }
        }
        params.query.bool.must.push(param)
      }
      if(businessScope!=""&&businessScope!=null){
        var param=  {
          "query_string": {
              "default_field": "business_scope",
              "query": "\""+businessScope+"\""
          }
        }
        params.query.bool.must.push(param)
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
    async compareEssearch(obj){//对比数据查询
      console.log("---------------------------------------");
      console.log(obj);
      var datestart=obj.datestart;
      var dateend=obj.dateend;
      var checkedStatu=obj.checkedStatu;
      var companyType=obj.companyType;
      var industry=obj.industry;
      var province=obj.province;
      var capitalstart=obj.capitalstart;
      var capitalend=obj.capitalend;
      var businessScope=obj.businessScope;
      var pagesize=obj.pagesize==null?15:obj.pagesize;
      if(obj.page==null){
        var from = 0;
      }else{
        var from = Number((obj.page-1)*obj.pagesize);
      }
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "must":[]
           }
         },
         "from": from,
         "size": pagesize,
         "_source": [
           "company_name",//公司名称
           "english_company_name",//公司英文名称
           "old_company_name",//公司曾用名
           "legal_persion_id",//法人ID
           "legal_persion_name",//法人姓名
           "legal_persion_type",//法人类型
           "usc_code",//统一社会信用代码
           "reg_number",//注册号
           "company_org_type",//公司类型
           "reg_location",//注册地址
           "establish_time",//公司注册时间
           "business_scope",//经营范围
           "from_time",//营业期限开始日期
           "to_time",//营业期限终止日期
           "reg_institute",//登记机关
           "reg_status",//企业状态
           "reg_capital",//注册资金
           "reg_capital_unit",//注册资金货币单位
           "actual_capital",//实收注册资金
           "org_number",//组织机构代码
           "list_code",//上市代码
           "cancel_time",//注销时间
           "approved_time",//核准日期
           "legal_persion_type",//法人类型，1 人 2 公司
           "new_company_name_id",// 变更后新公司的名字
           "company_province",//公司省份
           "company_city",//公司二级市
           "company_cate_1",//行业类别
         ],
         "sort":{
           "establish_time":"desc"
         }
      };
      if(datestart!=""&&dateend!=""){
        var datestart=datestart.replace("-", "");
        var dateend=dateend.replace("-", "");
        var param=  {
            "range": {
              "establish_month":{
                "gte":datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      if(datestart==""&&dateend==""){
        var nowdate = new Date();
        var dateend = new Date();
        var datestart=nowdate.setMonth(nowdate.getMonth()-6);
        datestart = moment(datestart).format("YYYYMM");
        dateend = moment(dateend).format("YYYYMM");
        var param=  {
            "range": {
              "establish_month":{
                "gte": datestart,
                "lte":dateend
              }
            }
        }
        params.query.bool.must.push(param)
      }
      if(checkedStatu.length>0){
        var param=  {
            "terms": {
              "reg_status": checkedStatu
            }
        }
        params.query.bool.must.push(param)
      }
      if(companyType.length>0){
        var param=  {
            "terms": {
              "company_org_type": companyType
            }
        }
        params.query.bool.must.push(param)
      }
      if(industry.length>0){
        var param=  {
            "terms": {
              "company_cate_1": industry
            }
        }
        params.query.bool.must.push(param)
      }
      if(province.length>0){
        var param=  {
            "terms": {
              "company_province": province
            }
        }
        params.query.bool.must.push(param)
      }
      if(capitalstart!=""&&capitalend!=""){
        var param=  {
          "range": {
            "reg_capital":{
              "gte": capitalstart,
              "lte":capitalend
            }
          }
        }
        params.query.bool.must.push(param)
      }
      if(businessScope!=""&&businessScope!=null){
        var param=  {
          "query_string": {
              "default_field": "business_scope",
              "query": "\""+businessScope+"\""
          }
        }
        params.query.bool.must.push(param)
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
    async magicbaseEssearch(obj){//基本查询
      console.log("----------------------basemagic-----------------");
      console.log(obj);
      var selectvalue=obj.selectvalue;
      var mark=obj.mark;
      var pagesize=obj.pagesize==null?15:obj.pagesize;
      if(obj.page==null){
        var from = 0;
      }else{
        var from = Number((obj.page-1)*obj.pagesize);
      }
      var reqUrl=this.msgicSearchUrl;
      var params = {
         "query": {
           "bool": {
             "must":[]
           }
         },
         "from": from,
         "size": pagesize,
         "_source": [
           "company_name",//公司名称
           "english_company_name",//公司英文名称
           "old_company_name",//公司曾用名
           "legal_persion_id",//法人ID
           "legal_persion_name",//法人姓名
           "legal_persion_type",//法人类型
           "usc_code",//统一社会信用代码
           "reg_number",//注册号
           "company_org_type",//公司类型
           "reg_location",//注册地址
           "establish_time",//公司注册时间
           "business_scope",//经营范围
           "from_time",//营业期限开始日期
           "to_time",//营业期限终止日期
           "reg_institute",//登记机关
           "reg_status",//企业状态
           "reg_capital",//注册资金
           "reg_capital_unit",//注册资金货币单位
           "actual_capital",//实收注册资金
           "org_number",//组织机构代码
           "list_code",//上市代码
           "cancel_time",//注销时间
           "approved_time",//核准日期
           "legal_persion_type",//法人类型，1 人 2 公司
           "new_company_name_id",// 变更后新公司的名字
           "company_province",//公司省份
           "company_city",//公司二级市
           "company_cate_1",//行业类别
         ],
         "sort":{
           "establish_time":"desc"
         }
      };
      if(mark!=""&&mark!=null){
        if(selectvalue=='all'){
          var param={
            "query_string": {
                 "fields":["company_name","reg_location"],
                 "query": "\""+mark+"\""
            }
          }
          var param1 ={
            "term":{
              "legal_persion_name":mark
            }
          }
          var param2={
            "term":{
              "usc_code":mark
            }
          }
          var pa={
            "bool":{
              "should":[]
            }
          }
          pa.bool.should.push(param)
          pa.bool.should.push(param1)
          pa.bool.should.push(param2)
          params.query.bool.must.push(pa)
        }else if(selectvalue=='companyname'){
          var param={
            "query_string": {
                 "default_field":"company_name.raw",
                 "query": "*"+mark+"*"
            }
          }
          params.query.bool.must.push(param)
        }else if(selectvalue=='legalpersionname'){
          var param={
            "term":{
              "legal_persion_name":mark
            }
          }
          params.query.bool.must.push(param)
        }else if(selectvalue=='usccode'){
          var param={
            "term":{
              "usc_code":mark
            }
          }
          params.query.bool.must.push(param)
        }else if(selectvalue=='reglocation'){
          var param={
            "query_string": {
                 "default_field":"reg_location.raw",
                 "query": "*"+mark+"*"
            }
          }
          params.query.bool.must.push(param)
        }
      }
      var rc=System.getObject("util.execClient");
      var rtn=null;
      try{
        rtn=await rc.execPost(params,reqUrl);
        var j=JSON.parse(rtn.stdout);
        return System.getResult3(j.hits,null);
      }catch(e){
        return rtn=System.getResult2(null,null);
      }
    }
}
module.exports=MagicSearchApi;
