var system = require("../../../system");
const AppServiceBase = require("../../app.base");
var settings = require("../../../../config/settings");
const {json} = require("sequelize");
const {AREACOMM} = require("../../../../config/businessConfig");

//此类用来db中配置来进行调用-主要功能是推送蜂擎业务
class UtilsFqAliyunService extends AppServiceBase {
    constructor() {
        super();
        this.centerOrderUrl = settings.centerOrderUrl();
        this.ucommuneOperatorPhone = settings.ucommuneOperatorPhone()
    }

    async pushOrderBusinessByProductCode2Fq(pobj) {//推送自定义产品码的订单商机到峰擎（订单已经支付成功才推送）
        console.log(JSON.stringify(pobj), ".................pushOrderBusinessByProductCode2Fq...............pobj");
        var verifyResult = await this.verifyParam(pobj);
        var orderInfo = pobj.actionBody.order_info;
        var orderContact = pobj.actionBody.order_contact ? pobj.actionBody.order_contact : pobj.actionBody.delivery_content.orderContact;
        var productInfo = pobj.actionBody.product_info;
        if (!orderInfo) {
            verifyResult = system.getResult(null, "orderInfo can not be empty，100420");
        }
        if (!orderInfo.orderStatus || orderInfo.orderStatus < 2) {
            verifyResult = system.getResult(null, "orderInfo status must be paid，100423");
        }
        if (!orderContact || !orderContact.mobile) {
            verifyResult = system.getResult(null, "orderInfo.orderContact.mobile can not be empty，100425");
        }
        if (!productInfo || !productInfo.service_business_code) {
            verifyResult = system.getResult(null, "orderInfo.productInfo.service_business_code can not be empty，100427");
        }
        if (!['360.icp', '360.edi'].includes(productInfo.service_business_code)) {
            if (!productInfo || !productInfo.price_item || !productInfo.price_item.service_code) {
                verifyResult = system.getResult(null, "orderInfo.productInfo.price_item.service_code can not be empty，100430");
            }
        }
        if (verifyResult.status != 0) {
            return await this.disposePushResultFail(pobj, verifyResult, "fq->pushOrderBusinessByProductCode2Fq->verifyResult", this.pushlogFailType.FQ);
        }

        var interface_params_info = verifyResult.data;
        var ucommuneOperatorPhone = pobj.appInfo && pobj.appInfo.contact_mobile ? pobj.appInfo.contact_mobile : this.ucommuneOperatorPhone
        console.log("推送的业务员手机号为:", ucommuneOperatorPhone)
        var params = {
            idempotentId: orderInfo.orderNo,// 是 业务 ID
            idempotentSource: productInfo.service_business_code,// 是 业务来源（ic_jdyun、ic_ali）
            idempotentSourceName: productInfo.service_business_name || productInfo.service_business_code,// 是 京东云应用、阿里云应用
            area: productInfo.price_item.price_desc,// 否 所属城市
            phone: orderContact.mobile,// 是 手机号
            userId: orderInfo.channelUserId,// 否 用户 ID
            companyName: "",// 否 公司名称
            orderNo: orderInfo.orderNo,
            orderPrice: orderInfo.totalSum,// 是 订单金额
            productId: productInfo.price_item.service_code,// 是 产品 ID
            productQuantity: orderInfo.quantity,// 是 产品数量
            operator_phone: ucommuneOperatorPhone, // 2020 0704 推送fq 必填字段 这里以下为新增 7.7修改由写死改为从settings获取
            createdat: orderInfo.created_at,// 2020 0722 lin新增 张超推送文档新增必填字段
            thirdPartyCustomerId: orderInfo.channelUserId,
            pay_flow_no: orderInfo.pay_flow_no,// 支付流水号
            pay_channel: orderInfo.pay_channel,// 支付渠道(微信、支付宝)(必填)
            pay_time: orderInfo.pay_time,//付款时间
            pay_payer_bank_no: orderInfo.pay_payer_bank_no,//付款人账号
            sku: productInfo.price_item.service_code,
            appName: pobj.appInfo.app_name
        };
        // var result = await this.opAliyunClientPost(pobj, "pushOrderBusiness", interface_params_info.opUrl, interface_params_info.key, interface_params_info.secret, params);
        var result = await this.opAliyunClientPost(pobj, interface_params_info.opUrl, interface_params_info.key, interface_params_info.secret, params);
        return await this.disposePushResult(pobj, result, "fq->pushOrderBusinessByProductCode2Fq->result", this.pushlogFailType.FQ);
    }

    /**
     * 推送阿里信息操作到峰擎
     * 阿里操作的信息不变外加增加组装的一些参数（推送工商需求商机、推送工商订单商机、推送关闭工商需求）
     * @param {*} pobj
     */
    async pushAliBusiness2Fq(pobj) {//推送阿里信息操作到峰擎
        var verifyResult = await this.verifyParam(pobj);
        if (verifyResult.status != 0) {
            return await this.disposePushResultFail(pobj, verifyResult, "fq->pushAliBusiness2Fq->verifyResult", this.pushlogFailType.FQ);
        }
        var interface_params_info = verifyResult.data;
        if (interface_params_info.opUrl.indexOf("/cts-open-agency/crm/opportunity/submit") >= 0) {
            await this.transformNeedActionBody(pobj);
        }
        let result = await this.opAliyunClientPost(pobj, interface_params_info.opUrl, interface_params_info.key, interface_params_info.secret, pobj.actionBody);
        return await this.disposePushResult(pobj, result, "fq->pushAliBusiness2Fq->result", this.pushlogFailType.FQ);
    }

    async transformNeedActionBody(pobj) {
        if (!pobj.actionBody.area || pobj.actionBody.area === "null") {
            pobj.actionBody.area = "全国";
        }
        if (pobj.actionBody.area != "全国" && pobj.actionBody.area.indexOf("市") < 0 && pobj.actionBody.area.indexOf("省") < 0) {
            pobj.actionBody.area = AREACOMM.areaTransform[pobj.actionBody.area] || pobj.actionBody.area;
        }
        if (pobj.actionBody.intentionBizId && (!pobj.actionBody.appName || !pobj.actionBody.productId)) {
            //获取需求信息
            let tmpActionBody = {
                actionBody: {needNo: pobj.actionBody.intentionBizId}
            }
            var reqUrl = this.centerOrderUrl + "action/need/getNeedItemByChannelNeedNo";
            var itemResult = await this.restPostUrl(tmpActionBody, reqUrl);
            if (itemResult.status == 0 && itemResult.data) {
                pobj.actionBody.appName = itemResult.data.appName;
                pobj.actionBody.productId = itemResult.data.serviceProductId;
            }
        }
    }

    //--------------------------------------------------内部辅助方法-------------------start-----------------

    async opAliyunClientPost(pobj, url, key, secret, params) {
        try {
            var rc = system.getObject("util.aliyunClient");
            var rtn = await rc.post(url, key, secret, params);
            if (typeof (rtn) == "string") {
                rtn = JSON.parse(rtn);
            }
            this.execClientNew.execLogs(`utilsFqAliyunSve-opAliyunClientPost-result:url=${url}`, pobj, "center-channel-opAliyunClientPost", rtn, null);
            if (rtn.success && rtn.code == 200) {
                return system.getResultSuccess(rtn.data, "推送成功");
            } else {
                let errorMsg = "";
                if (rtn.errorMessage && rtn.errorMessage.indexOf("请与服务产品确认该产品是否上架") >= 0) {
                    errorMsg = "请与服务产品确认该产品是否上架";
                }
                return system.getResultNewFail(-1, `推送失败，失败原因11：${JSON.stringify(rtn)}`, null, errorMsg);
            }
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs(`utilsFqAliyunSve-opAliyunClientPost-error:url=${url}`, pobj, "center-channel-opAliyunClientPost", null, stackStr);
            return system.getResult(null, "推送操作异常->fq->opAliyunClientPost->error：" + e.stack);
        }
    }

    async verifyParam(pobj) {//参数信息验证
        var verify = system.getResultSuccess();
        if (!pobj.interface_params) {
            verify = system.getResult(null, "interface_params can not be empty，100400");
        }
        var interface_params_info = JSON.parse(pobj.interface_params);
        if (!interface_params_info || !interface_params_info.opUrl || !interface_params_info.key || !interface_params_info.secret) {
            verify = system.getResult(null, "interface_params（opUrl、key、secret） can not be empty，100410");
        }
        verify.data = interface_params_info;
        return verify;
    }

    //下订单到ic
    async pushOrder2IC(pobj, opType) {
        console.log(JSON.stringify(pobj), ".................pushOrderBusinessByProductCode2Fq...............pobj");
        var interface_list = pobj.interface_info ? pobj.interface_info : pobj.actionBody.product_info.interface_info;
        if (!interface_list) {
            return system.getResult(null, "暂无推送配置");
        }
        var interface_list_temp = interface_list.filter(f => f.op_type == opType)
        if (!interface_list_temp || interface_list_temp.length == 0) {
            return system.getResult(null, "暂无【" + opType + "】的推送配置");
        }
        var verifyResult = system.getResultSuccess();
        var productInfo = pobj.actionBody.product_info;
        if (!productInfo || !productInfo.service_business_code) {
            verifyResult = system.getResult(null, "orderInfo.productInfo.service_business_code can not be empty，100427");
        }
        if (!productInfo || !productInfo.price_item || !productInfo.price_item.service_code) {
            verifyResult = system.getResult(null, "orderInfo.productInfo.price_item.service_code can not be empty，100430");
        }
        var interface_params_info = JSON.parse(interface_list_temp[0].params);
        //新增订单(商标自助注册) IC
        let icOrderParams = {
            "idempotentSource": "pcwebsbzc",// 来源编号，写死：pcwebsbzc，必填
            "idempotentSourceName": "PC官网",// 来源编号，写死：PC官网，必填
            "product_img_url": pobj.actionBody.deliveryData.tm.picUrl,//产品图片
            "productId": productInfo.price_item.service_code,// 云服产品skuid，必填
            "goodsId": pobj.actionBody.goodsId,// 官网产品id
            "customerId": pobj.actionBody.customerId, //客户Id，必填
            "product_item": pobj.actionBody.product_item,
            "device_token": pobj.actionBody.device_token //设备编号参数
        }
        pobj.params = icOrderParams;
        var result = await this.opAliyunClientPost(pobj, interface_params_info.opUrl, interface_params_info.key, interface_params_info.secret, icOrderParams);
        return await this.disposePushResult(pobj, result, "fq->pushOrder2IC->result", this.pushlogFailType.FQ);
    }

    //--------------------------------------------------内部辅助方法-------------------end-----------------

    // async tttt(){
    //     let rtn={
    //         "requestId":null,
    //         "code":"500",
    //         "data":null,
    //         "success":false,
    //         "errorCode":"PARAMETER.ILLEGAL",
    //         "errorMessage":"创建订单信息失败，下单失败，参数：{\"channelOrderNo\":[\"209314121310072\"],\"itemCreateRequest\":[{\"buyPrice\":2500,\"contactsId\":349905785792376832,\"createdBy\":124496450905186304,\"createdByName\":\"系统用户\",\"quantity\":1,\"serviceTypeChannelId\":0,\"serviceTypeChannelName\":\"阿里云商机\",\"serviceTypeId\":2,\"skuId\":232882795415017472}],\"orderInfoCreateRequest\":{\"businessCompanyCode\":\"C0000647942\",\"businessCompanyId\":349905787570761728,\"businessCompanyName\":\"广州市万合软件有限公司\",\"channelState\":3,\"contactsCode\":\"C0000647941\",\"contactsId\":349905785792376832,\"contactsMobile\":\"13829927400\",\"contactsName\":\"个人\",\"createdBy\":124496450905186304,\"createdByName\":\"系统用户\",\"customerCode\":\"C0000647942\",\"customerId\":349905787570761728,\"customerName\":\"广州市万合软件有限公司\",\"dealDescription\":\"公司经营范围：应用软件服务、基础软件服务；互联网信息服务；数据处理；计算机系统服务；计算机系统集成；技术开发；技术咨询；技术推广；技术转让；技术服务；\",\"employeeId\":124496450905186304,\"employeeName\":\"系统用户\",\"idempotentNo\":\"209314121310072\",\"payState\":1,\"payType\":1,\"price\":2500,\"scene\":5,\"serviceTypeChannelName\":\"阿里云商机\",\"sourceId\":100000000008068552,\"sourceName\":\"阿里云商机\",\"totalPrice\":2500}}，error：下单产品有误，请与服务产品确认该产品是否上架!",
    //         "timestamp":"2021-05-30T14:00:11.100+0800"
    //     }
    //     if (rtn.success && rtn.code == 200) {
    //         return system.getResultSuccess(rtn.data, "推送成功");
    //     } else {
    //         let errorMsg = "";
    //         if (rtn.errorMessage && rtn.errorMessage.indexOf("请与服务产品确认该产品是否上架") >= 0) {
    //             console.log("11111111111111");
    //             errorMsg = "请与服务产品确认该产品是否上架";
    //         }
    //         return system.getResultNewFail(-1, `推送失败，失败原因11：${JSON.stringify(rtn)}`, null, errorMsg);
    //     }
    // }
    // async ddd(){
    //     var pobj={opType:1,pushNumber:9,actionBody:{pushStatus:2}}
    //     var result=await this.tttt();
    //     await this.disposePushResult(pobj, result, "fq->pushOrderBusinessByProductCode2Fq->result", this.pushlogFailType.FQ);
    // }

}

module.exports = UtilsFqAliyunService;
//
//
// let tmp=new UtilsFqAliyunService();
// tmp.ddd();