let system = require("../../../system");
let settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");

class IcpOrderService extends AppServiceBase {
    constructor() {
        super();
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    }

    async submitOrder(pobj) {
        pobj.province = pobj.area;
        if (pobj.appInfo.uapp_id == "52") { // 易名渠道
            if (pobj.consultType == "5" || pobj.consultType == "7") { // ICP 申请
                pobj.province = pobj.area + '-申请';
            }
        }
        let sobj = {
            actionType: "getIcpProduce",
            actionBody: {typeCode: pobj.consultType, province: pobj.province},
            appInfo: pobj.appInfo,
            actionProcess: pobj.actionProcess
        }
        if (pobj.param1 || pobj.param2) {
            sobj.additionsDesc = pobj.param1 + pobj.param2;
        }//附加参数
        let productUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
        let rtn = await this.execClient.execPost(sobj, productUrl);
        if (!rtn || !rtn.stdout) {
            return system.getResultFail(-5010, "产品查询失败，6100001");
        }
        let productItem = JSON.parse(rtn.stdout);
        if (productItem.status != 0) {
            return system.getResultFail(-5010, "产品查询失败，6100002");
        }
        pobj.userInfo = {channel_userid: pobj.userName || ""}

        pobj.actionBody = {
            totalSum: productItem.data.price,
            orderPrice: productItem.data.price,
            payTotalSum: productItem.data.price,
            payCode: productItem.data.payCode,
            productPriceId: productItem.data.productPriceId,
            channelItemCode: productItem.data.channelItemCode,
            channelNeedNo: pobj.orderNo,
            needNo: pobj.orderNo,
            bizId: pobj.orderNo,//适应之前的逻
            quantity: 1,
            channelOrder: {
                channelServiceNo: pobj.orderNo,
                channelOrderNo: pobj.orderNo,
                orderStatus: 2
            }
        }
        let orderItem = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
        console.log("orderItem.........................................................", JSON.stringify(orderItem))
        if (orderItem.status != 0 && orderItem.status != -1) {
            return system.getResultFail(-5010, "订单创建失败，6100003");
        }
        if (orderItem.data) {
            pobj.actionBody.orderNo = pobj.actionBody.channelOrder.channelOrderNo;
        }
        pobj.actionBody.channelSolutionNo = pobj.actionBody.channelOrder.channelOrderNo;
        pobj.actionBody.channelSolutionNo = pobj.actionBody.channelOrder.channelOrderNo;
        pobj.actionType = "receiveSolutionPayInfoNew";
        let url = settings.centerOrderUrl() + "action/icapi/springBoard";
        let solutionRes = await this.execClient.execPost(pobj, url);
        console.log("solutionRes......................................................", JSON.stringify(solutionRes))
        if (!solutionRes || !solutionRes.stdout) {
            return system.getResultFail(-5010, "方案创建失败，6100004");
        }
        let solutionItem = JSON.parse(solutionRes.stdout);
        if (solutionItem.status != 0) {
            return system.getResultFail(-5010, "方案创建失败，6100005");
        }
        // if (!solutiondata.data) {
        //     return system.getResultFail(-5012, "方案查询数据为空");
        // }
        // if (solutiondata.data && solutiondata.data.channelNeedNo) {
        //     pobj.actionBody.needId = solutiondata.data.channelNeedNo;
        // }
        // if (pobj.actionBody.channelItemCode == '5') {
        //     pobj.actionBody.regType = "baidu.icp";
        // } else if (pobj.actionBody.channelItemCode == '7') {
        //     pobj.actionBody.regType = "baidu.edi";
        // } else if (pobj.actionBody.channelItemCode == 'NC') {
        //     pobj.actionBody.regType = "baidu.wangwen";
        // } else if (pobj.actionBody.channelItemCode == 'RT') {
        //     pobj.actionBody.regType = "baidu.radiotv";
        // }
        //
        // if (pobj && pobj.appInfo && pobj.appInfo.uapp_id && pobj.appInfo.uapp_id == '52') {
        //     if (pobj.actionBody.channelItemCode == '5') {
        //         pobj.actionBody.regType = "yiming.icp";
        //     } else if (pobj.actionBody.channelItemCode == '7') {
        //         pobj.actionBody.regType = "yiming.edi";
        //     } else if (pobj.actionBody.channelItemCode == 'ICPXQ') {
        //         pobj.actionBody.regType = "yiming.icpxq";
        //     } else if (pobj.actionBody.channelItemCode == 'EDIXQ') {
        //         pobj.actionBody.regType = "yiming.edixq";
        //     } else if (pobj.actionBody.channelItemCode == 'ICPNB') {
        //         pobj.actionBody.regType = "yiming.icpnb";
        //     } else if (pobj.actionBody.channelItemCode == 'EDINB') {
        //         pobj.actionBody.regType = "yiming.edinb";
        //     } else if (pobj.actionBody.channelItemCode == 'ICPWZ') {
        //         pobj.actionBody.regType = "yiming.icpwz";
        //     } else if (pobj.actionBody.channelItemCode == 'EDIWZ') {
        //         pobj.actionBody.regType = "yiming.ediwz";
        //     }
        // }
        let yfObj = {
            actionBody: {
                area: pobj.province,
                idempotentSource: pobj.regType || "",//之前推送参数，待验证是否有用
                orderNo: pobj.actionBody.channelOrder.channelOrderNo,
                orderPrice: Number(pobj.actionBody.orderPrice / 100),
                phone: pobj.publishMobile || pobj.phone,
                needId: pobj.actionBody.channelOrder.channelOrderNo,
                companyName: pobj.CompanyName || '',
                appName: pobj.appInfo.app_name || '',
                sku: productItem.data.service_code || ''
            },
            appInfo: pobj.appInfo
        }
        console.log("yfObj......................................................", JSON.stringify(yfObj))
        let yunfuPushRes = await this.utilsPushSve.business2Channel(yfObj, "pushOrderICPBusinessNew");
        if (pobj.actionBody.isDirectBuy && pobj.actionBody.isDirectBuy == 1) {//直接下单需执行添加订单业务员操作
            if (yunfuPushRes && yunfuPushRes.status == 0) {
                if (yunfuPushRes.data && yunfuPushRes.data.data) {
                    let deliveryObj = {
                        actionBody: {
                            orderNo: yunfuPushRes.data.orderNo,
                            needsolution: yunfuPushRes.data.solutionContent,
                            channelNeedNo: yunfuPushRes.data.channelNeedNo,
                            channelSolutionNo: yunfuPushRes.data.channelSolutionNo,
                            skuCode: productItem.data.payCode,
                            servicer: {
                                code: 'gsb',
                                name: '公司宝'
                            }
                        },
                        appInfo: pobj.appInfo
                    };
                    let resData = yunfuPushRes.data.data;
                    let salesmanInfo = {
                        salesmanName: resData.orderList && resData.orderList.length > 0 ? resData.orderList[0].operatorName : "",
                        salesmanChannelId: resData.orderList && resData.orderList.length > 0 ? resData.orderList[0].operator : "",
                    };
                    deliveryObj.actionBody.needsolution = {salesmanInfo: salesmanInfo, orderNo: orderrtn.data.orderNo}
                    console.log("deliveryObj......................................................", JSON.stringify(deliveryObj))
                    this.utilsPushSve.business2Channel(deliveryObj, "pushDeliveryOrder");
                }
            }
        }
        return system.getResultSuccess(null);
    }

    async closeOrder(pobj) {
        let url = settings.centerOrderUrl() + "action/qcapi/springBoard";
        let rtn = await this.restPostUrl(pobj, url);
        if (rtn.status == 0 && rtn.data) {
            let channelOrderNo = pobj.orderNo;
            pobj.actionBody.orderNo = rtn.data.orderNo;
            pobj.actionType = "delOrder";
            let orderRes = await this.utilsOrderSve.delOrder(pobj, pobj.actionBody);
            if (orderRes.status < 0) {
                return system.getResultFail(-5022, "订单关闭失败");
            }
            let tmpObj = {
                actionBody: {
                    orderNo: rtn.data.orderNo,
                    channelNeedNo: rtn.data.channelNeedNo,
                    needsolution: rtn.data.solutionContent
                },
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(tmpObj, "pushDeliveryStatusNotify");
            // tmpObj.actionBody.orderNo = channelOrderNo;
            let tmpObj2 = {
                actionBody: {
                    orderNo: channelOrderNo,
                    channelNeedNo: rtn.data.channelNeedNo || channelOrderNo,//做云服和企服通没有渠道需求号的兼容
                    needsolution: rtn.data.solutionContent
                },
                appInfo: pobj.appInfo
            };
            this.utilsPushSve.business2Channel(tmpObj2, "pushOrderICPClose");
        }//通知更新状态
        return rtn;
    }
}

module.exports = IcpOrderService;