const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
class BizOptService extends ServiceBase {
    constructor() {
        super("bizchance", ServiceBase.getDaoName(BizOptService));
        this.bizbatchDao = system.getObject("db.bizchance.bizbatchDao");

    }
    async statBizChanceCountBySp(bizStatus, betweenTime) {
        let params = {}
        params.group = {
            byFields: ['facilitator_name'],
            actionType: 'count',
            aggField: 'id',
            aliasField: ' as  chanceCount',
            tblName: 'bussiness_opportunity',
            where: bizStatus != "" ? `where business_status='${bizStatus}'` : '',
            having: '',
        }
        if (betweenTime.length > 0) {
            params.group.where = `${params.group.where} ${params.group.where ? 'AND' : "WHERE"} (created_at BETWEEN '${betweenTime[0]}' AND '${betweenTime[1]}')`
        }
        let s = await this.dao.statGroupBy(params, null)
        return s
    }
    /**
     * 公司id,平台公司ID为1
     * @param {*} companyId 
     * @param {*} opath 
     * @param {*} username 
     * @param {*} userid 
     */
    async statBizChance(companyId, opath, username, userid, betweenTime) {

        // 时间 筛选
        let andWhere = [];
        if (betweenTime.length > 0) {
            andWhere.push({
                "created_at": { [this.db.Op.between]: betweenTime }
            })
        }
        //如果当前登录人是平台,返回所有商机
        let waittoHandledCount = 0
        let handlingCount = 0
        let finishedCount = 0
        let closedCount = 0
        let followingUpCount = 0;
        if (companyId == 1) {
            waittoHandledCount = await this.dao.findCount({ where: { business_status: 'beforeSubmission', [this.db.Op.and]: andWhere } })
            followingUpCount = await this.dao.findCount({ where: { business_status: 'followingUp', [this.db.Op.and]: andWhere } })
            handlingCount = await this.dao.findCount({ where: { business_status: 'beforeConfirmation', [this.db.Op.and]: andWhere } })
            finishedCount = await this.dao.findCount({ where: { business_status: 'isFinished', [this.db.Op.and]: andWhere } })
            closedCount = await this.dao.findCount({ where: { business_status: 'isClosed', [this.db.Op.and]: andWhere } })
        } else {
            let opathstr = ''
            if (opath) {
                opathstr = opath
                waittoHandledCount = await this.dao.findCount({ where: { business_status: 'beforeSubmission', salesman_opcode: { [this.db.Op.like]: `%${opathstr}%` }, 'facilitator_id': companyId, [this.db.Op.and]: andWhere } })
                followingUpCount = await this.dao.findCount({ where: { business_status: 'followingUp', salesman_opcode: { [this.db.Op.like]: `%${opathstr}%` }, 'facilitator_id': companyId, [this.db.Op.and]: andWhere } })
                handlingCount = await this.dao.findCount({ where: { business_status: 'beforeConfirmation', salesman_opcode: { [this.db.Op.like]: `%${opathstr}%` }, 'facilitator_id': companyId, [this.db.Op.and]: andWhere } })
                finishedCount = await this.dao.findCount({ where: { business_status: 'isFinished', salesman_opcode: { [this.db.Op.like]: `%${opathstr}%` }, 'facilitator_id': companyId, [this.db.Op.and]: andWhere } })
                closedCount = await this.dao.findCount({ where: { business_status: 'isClosed', salesman_opcode: { [this.db.Op.like]: `%${opathstr}%` }, 'facilitator_id': companyId, [this.db.Op.and]: andWhere } })
            } else {
                waittoHandledCount = await this.dao.findCount({ where: { business_status: 'beforeSubmission', 'facilitator_id': companyId, [this.db.Op.and]: andWhere } })
                followingUpCount = await this.dao.findCount({ where: { business_status: 'followingUp', 'facilitator_id': companyId, [this.db.Op.and]: andWhere } })
                handlingCount = await this.dao.findCount({ where: { business_status: 'beforeConfirmation', 'facilitator_id': companyId, [this.db.Op.and]: andWhere } })
                finishedCount = await this.dao.findCount({ where: { business_status: 'isFinished', 'facilitator_id': companyId }, [this.db.Op.and]: andWhere })
                closedCount = await this.dao.findCount({ where: { business_status: 'isClosed', 'facilitator_id': companyId }, [this.db.Op.and]: andWhere })
            }

        }
        //成单率
        let allChance = waittoHandledCount + handlingCount + finishedCount + closedCount
        let successRadio = Math.ceil((finishedCount / allChance) * 100)
        //如果当前登录人不是平台,那么需要按照opath查询
        return { waittoHandledCount: waittoHandledCount, followingUpCount, handlingCount: handlingCount, finishedCount: finishedCount, closedCount: closedCount, successRadio: successRadio }
    }
    async findAndCountAll(obj) {
        var self = this;
        const apps = await this.dao.findAndCountAll(obj);
        return apps;
    }

    /*根据商机编号获取商机详情*/
    async findInfoByDemandCode(qobj) {
        return await this.dao.findInfoByDemandCode(qobj);
    }

    /* 根据商机编号更新商机状态 */
    async updateStatusByDemandCode(qobj) {
        var self = this;
        return self.db.transaction(async function (t) {
            return await self.dao.updateStatusByDemandCode(qobj, t);
        });
    }

    /*更新业务员信息*/
    async updateSalesmanInfoByDemandCode(qobj) {
        var self = this;
        return self.db.transaction(async function (t) {
            return await self.dao.updateSalesmanInfoByDemandCode(qobj, t);
        });
    }

    /*插入商机信息*/
    async insertInfo(qobj) {
        var self = this;
        return self.db.transaction(async function (t) {
            return await self.dao.insertInfo(qobj, t);
        });
    }
    /*更新商机批次信息*/
    async batchChanceUpdate(qobj) {
        let data = await this.bizbatchDao.findOne({
            batchNumber: qobj.batchNumber
        });
        if (!data) {
            throw new Error("查不到商机批次信息")
        }
        if (data.processingStatus === "success") {
            return "已处理成功,重复请求"
        }
        let demandObj = {};
        for (let val of qobj.demands) {
            demandObj[val.uniqueCode] = val.demandCode;
        }
        await this.bizbatchDao.updateByWhere({
            processingStatus: "success",
            paymentLink: qobj.paymentLink,
            batchInfo: data.batchInfo.map(item => {
                item.demandCode = demandObj[item.uniqueCode] || ''
                return item
            })
        }, {
            id: data.id
        })
        return "SUCESS"
    }

}
module.exports = BizOptService;