const system=require("../../../system");
const settings=require("../../../../config/settings");
const appconfig=system.getSysConfig();
module.exports = (db, DataTypes) => {
  return db.define("user", {
    userName: {
      type:DataTypes.STRING,
      allowNull: false,
    },
    password: {
      type:DataTypes.STRING,
      allowNull: false,
    },
    nickName: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    sex: {
      type:DataTypes.ENUM,
      allowNull: true,
      values: Object.keys(appconfig.pdict.sex),
    },
    mobile:DataTypes.STRING,
    mail: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    headUrl: DataTypes.STRING,
    isAdmin:{
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
    isSuper:{
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
    isSystem:{
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
    center_id:DataTypes.STRING,
    jwtkey:DataTypes.STRING,
    jwtsecret:DataTypes.STRING,
    isEnabled:{
      type:DataTypes.BOOLEAN,
      defaultValue: true
    },
    opath:DataTypes.STRING,//作业务时，需要在业务表冗余当前处理人的opath
    ptags:DataTypes.STRING,//权限标签，逗号分隔，可以按照标签查看opath中含有标签的数据
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'p_user',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
