const system = require("../../../system");
const Dao = require("../../dao.base");
class MaterialDao extends Dao {
  constructor() {
    super(Dao.getModelName(MaterialDao));
  }

  /*根据交付单编号获取注册材料信息详情*/
  async findInfoByDeliverNumber(qobj) {
    var qcwhere = { "delivery_code": qobj.deliverNumber };
    return await this.findOne(qcwhere);
  }
  /* 根据id更新zip信息 */
  async updateZipById(qobj, t) {
    try{
      var whereobj = { "id": qobj.id };
      var setobj= {
        "is_download":1,
        "download_url":qobj.url
      };
      return await this.updateByWhere(setobj, whereobj, t);
    }
    catch(error){
      console.log("error----------" + error);
      return error;
    }
   
  }

  /*根据交付单编号更新交材料详情*/
  async updateInfoByDeliverNumber(qobj, t) {
    var whereobj = { "delivery_code": qobj.deliverNumber };
    var setobj = {};
    if (qobj.companyInfo && qobj.companyInfo != 'undefined') {
      setobj.company_info = qobj.companyInfo;
    }
    if (qobj.registeredInfo && qobj.registeredInfo != 'undefined') {
      setobj.registered_info = qobj.registeredInfo;
    }
    if (qobj.contributionInfo && qobj.contributionInfo != 'undefined') {
      setobj.contribution_info = qobj.contributionInfo;
    }
    if (qobj.positionInfo && qobj.positionInfo != 'undefined') {
      setobj.position_info = qobj.positionInfo;
    }
    if (qobj.managerInfo && qobj.managerInfo != 'undefined') {
      setobj.position_info = qobj.managerInfo;
    }
    if (qobj.regInfo && qobj.regInfo != 'undefined') {
      setobj.file_info = qobj.regInfo;
    }
    if (qobj.expressInfo && qobj.expressInfo != 'undefined') {
      setobj.express_info = qobj.expressInfo;
    }
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /*插入注册材料信息*/
  async insertInfo(pobj, t) {//公司注册，云上园区注册时的信息
    var obj = {
      "delivery_code": pobj.deliverNumber
    };
    if (pobj.deliverId && pobj.deliverId != 'undefined') {
      obj["delivery_id"] = pobj.deliverId;
    }
    if (pobj.companyInfo && pobj.companyInfo != 'undefined') {
      obj.company_info = pobj.companyInfo;
    }
    if (pobj.registeredInfo && pobj.registeredInfo != 'undefined') {
      obj.registered_info = pobj.registeredInfo;
    }
    if (pobj.positionInfo && pobj.positionInfo != 'undefined') {
      obj.position_info = pobj.positionInfo;
    }
    if (pobj.regInfo && pobj.regInfo != 'undefined') {
      obj.file_info = pobj.regInfo;
    }
    if (pobj.expressInfo && pobj.expressInfo != 'undefined') {
      obj.express_info = pobj.expressInfo;
    }
    return await this.create(obj, t);
  }


}
module.exports = MaterialDao;
