<a name="menu" href="/doc">返回主目录</a>
1. [尼斯查询（一）](#getNcl)
1. [尼斯查询（二）](#getNclTwo)
1. [文字转图片](#word2pic)
1. [商标样式转换](#uploadStandardTm)
1. [图片转pdf](#pic2pdf)
1. [企业近似查询](#getCompanyInfoByLikeName)
1. [企业注册信息查询](#getEntregistryByCompanyName)
1. [调整委托书](#adjustWTSSize)
1. [接入方提供查询订单接口](#getInfo)
1. [商标提报](#subTmOrder)
1. [商标交付列表](#getTmOrderList)
1. [商标交付信息](#getTmOrderInfo)
1. [商标订单-申请信息](#getTmApplyInfo)
1. [商标订单-商标尼斯信息](#getTmNclList)
1. [创建需求方案](#subNeed)
1. [需求方案-商标信息](#getNeedInfo)
1. [商标方案确认](#tmConfirm)
1. [商标订单修改-商标信息修改](#updateTmInfo)
1. [商标订单修改-商标尼斯信息修改](#updateNclInfo)
1. [商标订单修改-修改商标交付单联系人](#updateContacts)
1. [商标订单修改-修改申请人信息](#updateCustomerInfo)
1. [商标订单修改-修改交官文件](#updateCustomerInfo)
1. [产品详情](#getProductDetail)
1. [产品列表-根据产品大类获取](#getProductListByTypeOneCode)
1. [产品列表-根据产品二类获取](#getProductListByTypeCode)
1. [产品详情-应用中心](#getCAProductDetail)
1. [产品列表-根据产品大类获取-应用中心](#getCAProductListByTypeOneCode)
1. [产品列表-根据产品二类获取-应用中心](#getCAProductListByTypeCode)

## **<a name="getNcl"> 尼斯查询（一）</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getNcl
``` javascript
    {
        "nclcode": "01"   //Y string 尼斯编号（尼斯大类类别获取群组类别）
    }
```

#### 返回结果
```javascript
    {
        "status": 0,//操作状态0:操作成功-1:操作失败
        "msg": "操作成功",//操作信息
        "data": [
            {
                "code": "01",//尼斯大类编码
                "name": "",//大类名称
                "pcode": "",//父类编码 大类要为父类则为空
                "type": 1,
                "children": [//尼斯群组信息
                    {
                        "code": "0106",//群组编码
                        "name": "化学试剂",//群组名称
                        "pcode": "01",//群组父类编码 即其所属大类编码
                        "type": 1,
                        "children": [//尼斯小类
                            {
                                "code": "010122",//小类编码
                                "name": "生物化学催化剂",//小类名称
                                "pcode": "0106"//小类父类编码 即其所属群组编码
                            }
                        ]
                    }
                ]
            },
            {
                "code": "42",
                "name": "",
                "pcode": "",
                "type": 1,
                "children": [
                    {
                        "code": "4211",
                        "name": "提供化学研究服务",
                        "pcode": "42",
                        "type": 1,
                        "children": [
                            {
                                "code": "",
                                "name": "生物化学研究和分析",
                                "pcode": "4211"
                            }
                        ]
                    }
                ]
            }
        ],
        "requestId": "8cd7e91ec607453c805da8302f3e068c"
    }
```

## **<a name="getNclTwo"> 尼斯查询（二）</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getNcl

``` javascript
    {
        "name": "生物化学",//Y strin 尼斯名称
        "ncls ": ["01"]//N List 尼斯大类编码列表
    }
```

#### 返回结果
```javascript
    {
        "status": 0,//操作状态0:操作成功-1:操作失败
        "msg": "操作成功",//操作信息
        "data": [
            {
                "code": "01",//尼斯大类编码
                "name": "",//大类名称
                "pcode": "",//父类编码 大类要为父类则为空
                "type": 1,
                "children": [//尼斯群组信息
                    {
                        "code": "0106",//群组编码
                        "name": "化学试剂",//群组名称
                        "pcode": "01",//群组父类编码 即其所属大类编码
                        "type": 1,
                        "children": [//尼斯小类
                            {
                                "code": "010122",//小类编码
                                "name": "生物化学催化剂",//小类名称
                                "pcode": "0106"//小类父类编码 即其所属群组编码
                            }
                        ]
                    }
                ]
            },
            {
                "code": "42",
                "name": "",
                "pcode": "",
                "type": 1,
                "children": [
                    {
                        "code": "4211",
                        "name": "提供化学研究服务",
                        "pcode": "42",
                        "type": 1,
                        "children": [
                            {
                                "code": "",
                                "name": "生物化学研究和分析",
                                "pcode": "4211"
                            }
                        ]
                    }
                ]
            }
        ],
        "requestId": "8cd7e91ec607453c805da8302f3e068c"
    }
```


## **<a name="word2pic"> 文字转图片</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：word2pic

``` javascript
    {
        "word": "235"
    }
```

#### 返回结果
```javascript
    {
        "status":0,
        "msg":"操作成功",
        "data":{
            "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2pic0310054131e546c68e572e72845e10ed.jpg"
        },
        "requestId":"289fc8efa0ca4db79affc34dc0b78b9e"
    }

```


## **<a name="uploadStandardTm"> 商标样式转换</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：uploadStandardTm

``` javascript
    {
        "key": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_picUrl295615693112289552019824.jpg"
    }
```

#### 返回结果
```javascript
    {
        "status":0,
        "msg":"操作成功",
        "data":{
            "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_picUrl295652019824.jpg",
            "url2":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/6tkoZLO7vLzvFpzP2sOo.jpg"
        },
        "requestId":"610fa9e864014d9b92bb63bb28eab6df"

    }

```

## **<a name="pic2pdf"> 图片转pdf</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：pic2pdf

``` javascript
    {
        "key": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_picUrl295615693112289552019824.jpg"
    }
```

#### 返回结果
```javascript
    {
        "status":0,
        "msg":"操作成功",
        "data":{
            "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz23491569102019824.pdf"
        },
        "requestid":"0f6a38044034475eb47e80a78d3bdd6c"

    }

```

## **<a name="getCompanyInfoByLikeName"> 企业近似查询</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getCompanyInfoByLikeName

``` javascript
    {
        "likestr": "北京"
    }
```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "操作成功",
        "data": [
            {
                "entId": 188568958,
                "province": "北京",
                "domainEntName": "爱陌客(北京)文化传媒有限责任公司",
                "entName": "爱陌客(北京)文化传媒有限责任公司",
                "entLegalperson": "王林",
                "entStatus": "存续",
                "capitalUnit": "万人民币",
                "capitalStandard": "50000000.000",
                "foundedTime": "2019-4-24",
                "regLocation": "北京市顺义区高丽营镇北高路99号4号楼2层202室",
                "creditCode": "91110113MA01JPD53X"
            },
            {
                "entId": 140981646,
                "province": "北京",
                "domainEntName": "中国铁路北京局集团有限公司",
                "entName": "中国铁路北京局集团有限公司",
                "entLegalperson": "赵春雷",
                "entStatus": "存续",
                "capitalUnit": null,
                "capitalStandard": "24895969.000",
                "foundedTime": "1993-4-22",
                "regLocation": "北京市海淀区复兴路6号",
                "creditCode": "91110000100013669B"
            }
        ],
        "requestid": "0f6a38044034475eb47e80a78d3bdd6c"

    }

```

## **<a name="getEntregistryByCompanyName"> 企业注册信息查询</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getEntregistryByCompanyName

``` javascript
    {
        "companyName":"北京创知厚德科技有限公司"
    }
```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "name": "北京创知厚德科技有限公司",
            "legalRepresentative": "王静波",
            "managementState": "存续",
            "registeredCapital": "100.000null",
            "foundedTime": "2016-7-20",
            "creditCode": "91110105MA00723E4F",
            "registrID": null,
            "organizationCode": "MA00723E4",
            "companyType": "0",	
            "registerOffice": "朝阳分局",
            "businessAddress": "北京市朝阳区创远路36号院10号楼1层102",
            "scope": "技术开发、技术咨询、技术服务；商标代理；版权贸易；经济贸易咨询；企业策划；设计、制作、代理、发布广告；市场调查；企业管理咨询；组织文化艺术交流活动（不含演出）；承办展览展示活动；影视策划；翻译服务；酒店管理；销售文具用品、体育用品、机械设备、五金交电（不从事实体店铺经营）、电子产品、通讯设备、计算机、软件及辅助设备；工程和技术研究；计算机系统服务；基础软件服务；应用软件服务（不含医用软件）；软件开发；出租办公用房；机动车公共停车场服务；会议服务；房地产信息咨询；房地产开发；物业管理。（企业依法自主选择经营项目，开展经营活动；依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）",
            "dateIssue": "2018-3-9",
            "businessTerm": "2016-7-20至2036-7-19"
        },
        "requestId": "2016c54abe7249a2a1195d236b333f79"
    }

```

## **<a name="adjustWTSSize"> 调整委托书</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：adjustWTSSize

``` javascript
    {
        "key":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2pic0310054131e546c68e572e72845e10ed.jpg"
    }
```

#### 返回结果
```javascript
    {
        "status":0,
        "msg":"操作成功",
        "data":{
            "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_wts745215693150065342019824.jpg"
        },
        "bizmsg":"empty",
        "requestid":"10fc80d7084549238ad59a1016a92c5f"
    }

```

## **<a name="getInfo"> 接入方提供查询订单接口</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求地址：/openapi/order/getInfo

``` javascript
    {
         "order_no": "1000053513"
    }
```

#### 返回结果
```javascript
    {
        "code": 200,
        "message": "success",
        "data": {
            "org_name": "汉唐集团",
            "order_state": "待办理",
            "order_company_name": "王朋",
            "customer_phone": "18191765160",
            "customer_name": "无",
            "customer_email": "",
            "order_price": 899,
            "needId": "5d24470fd9f9340009f3528a",
            "threeClassCount": 10,
            "order_nos": [
                "1000053513"
            ],
            "oneClassCount": 1
        }
    }


```

## **<a name="subTmOrder"> 商标提报</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：subTmOrder

``` javascript
    {
        "itemCode": "zzsbzc",
        "channelParams": {},
        "channelUser": {
            "channelUserId": "z1203155540315474420",
            "channelUserName": "testUser",
            "channelUserMoblie": "15010929368",
            "nickname": "",
            "orgName": "",
            "orgPath": ""
        },
        "channelOrder": {
            "channelServiceNo": "z1203155540315474420",
            "channelOrderNo": "z12031,z1203d1",
            "needNo": "z120303d1",
            "quantity": 1,
    "nclCount": 10,
            "payStatus": "yfk",
            "payTime": "2019-09-11 10:23:21"
        },
        "apply": {
            "applyAddr": "上海市杨浦区国定路346号三楼0624室",
            "applyArea": "",
            "businessLicensePic": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.jpg",
        "businessLicensePdf": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.pdf",
            "code": "91310110398635929J",
            "contacts": "宋毅",
            "customerType": "ent",
            "email": "songyi@gongsibao.com",
            "fax": "",
            "identityCardNo": "",
            "identityCardPic": "",
    "identityCardPdf": "",
            "mobile": "15010929368",
            "name": "上海辰者信息科技有限公司",
            "notes": "订单备注信息",
            "gzwtsUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_wts863215710393842862019914.jpg",
            "smwjUrl":"",
            "zipCode": "100000"
        },
        "tm": {
            "colorizedPicUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",
            "tmName": "testbiao",
            "picUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",
            "selecttype": "自主选择",
            "tmFormType": "3",
            "totalPublicExpense": 270,
            "totalServiceCharge": 0,
            "totalSum": 270,
            "totalTaxes": "0.00"
        },
        "nclones": [
            {
                "code": "02",
                "name": "颜料油漆",
                "nclThree": [
                    {
                        "code": "020008",
                        "disabled": false,
                        "fullname": "020008 绘画用铝粉",
                        "name": "绘画用铝粉",
                        "pcode": "0202"
                    },
                    {
                        "code": "020005",
                        "disabled": false,
                        "fullname": "020005 食品用着色剂",
                        "name": "食品用着色剂",
                        "pcode": "0203"
                    }
                ]
            }
        ]
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            " deliveryOrderNo": "346c3091684e4e57a7639bec30eef5f7",
            " channelServiceNo": "346c3091684e4e0eef",
            "channelParams":{}
        },
        "requestid": "2016c54abe7249a2a1195d236b333f79"
    }

```

## **<a name="getTmOrderList"> 商标交付列表</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getTmOrderList

``` javascript
    {
    "channelUserId": "channelUserIdtest01",    
    "channelServiceNo": "346c3091684e4e0eef",
        "deliveryOrderNo": "346c3091684e4e0eef",
        "itemCode": "",
        "deliveryStatus": "",
        "payStatus": "",
        "tmName": "",
        "name": "",
        "startTime": "2019-10-27",
        "entTime": "2019-10-31",
        "pageIndex ": 1,
        "pageSize": 10
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": [
            {
                "channelServiceNo": "z1203155540315474420",
                "deliveryOrderNo": "JF201910301606zlBced",
                "tmName": "testbiao",
                "nclOneCount": 1,
                "nclOneCodes": "02",
                "itemCode": "zzsbzc",
                "itemName": "商标自主注册",
                "totalSum": "270.00",
                "name": "上海辰者信息科技有限公司",
                "deliveryStatus": "dsccl",
                "deliveryStatusName":"待上传材料",
                "payStatus": "yfk",
                "payStatusName": "已付款",
                "CreateDate": "2019-10-30T08:06:02.000Z",
                "submitTime": null,
    "notes": null
            }
        ],
        "requestId": "6bcec4c156844858b82aa804e7df7923"
    }


```

## **<a name="getTmOrderInfo"> 商标交付信息</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getTmOrderInfo

``` javascript
    {
    "channelUserId": "channelUserIdtest01",
    "deliveryOrderNo":"JF201910301606zlBced",
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "tm": {
                "itemCode": " zzsbzc",
                "itemName": "商标自主注册",
                "tmName": "testbiao",
                "picUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",
                "colorizedPicUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",
                "tmType": "p",
                "tmFormType": "3",
                "nclOneCodes": "02",
                "gzwtsUrl": null,
                "smwjUrl": null,
                "deliveryStatus": "dsccl",
                "notes": ""
            },
            "orderFlow": [
                {
                    "opContent": "订单已付款待上传材料",
                    " createDate": "2019-10-30T08:06:03.000Z"
                }
            ],
            "receiptVoucher": [
                {
                    "payAccountType": "other",
                    "payDate": "2019-08-07T06:30:06.000Z",
                    "wxPayOrderCode": "TMO2019081213508t9GH",
                    "aliPayOrderCode": "TMO2019081213508t9GH",
                    "busPayOrderCode": "TMO2019081213508t9GH",
                    "certifyFileUrl": "",
                    "totalSum": 270
                }
            ]
        },
        "requestId": "6b58931813284878aaee3a601db4a33f"
    }

```

## **<a name="getTmApplyInfo"> 商标订单-申请信息</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getTmApplyInfo

``` javascript
    {
        "channelUserId": "channelUserIdtest01",
        "deliveryOrderNo":"346c3091684e4e0eef"
    }

```

#### 返回结果
```javascript
    {
    "status": 0,
    "msg": "success",
    "data": {
        "applyAddr": "上海市杨浦区国定路346号三楼0624室",
        "applyArea": "",
        "businessLicensePic": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.pdf",
      "businessLicensePdf": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.pdf",
        "code": "91310110398635929J",
        "customerType": "ent",
        "identityCardNo": null,
        "identityCardPic": null,
"identityCardPdf": null,
        "name": "上海辰者信息科技有限公司",
        "contacts": "宋毅",
        "mobile": "15010929368",
        "email": "songyi@gongsibao.com",
        "fax": "",
        "zipCode": "100000"
    },
    "requestId": "c0241b9f1467437490264eb44f009699"
}

```

## **<a name="getTmNclList"> 商标订单-商标尼斯信息</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getTmNclList

``` javascript
{
"channelUserId": "channelUserIdtest01",
"deliveryOrderNo":"346c3091684e4e0eef"
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": [
        {
            "nclOneCodes": "02",
            "nclSmallCodes": "[{\"code\":\"020008\",\"disabled\":false,\"fullname\":\"020008 绘画用铝粉\",\"name\":\"绘画用铝粉\",\"pcode\":\"0202\"},{\"code\":\"020005\",\"disabled\":false,\"fullname\":\"020005 食品用着色剂\",\"name\":\"食品用着色剂\",\"pcode\":\"0203\"}]",
            "officialType": "dsccl",
            "officialTypeName": "待上传材料",
            "tmRegistNum": null,
            "submitTime": null,
            "tmOfficials": [
                {
                    "officialType": "1",
                    "officialTypeName": "商标注册申请书",
                    "officialFileUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_38715656607601102019139460110TMZC40280354.pdf",
                    "createDate": "2019-08-12T06:13:45.000Z"
                }
            ]
        }
    ],
    "requestId": "4bd42193408a48aab1f3930162c3eb6e"
}

```

## **<a name="subNeed"> 创建需求方案</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：subNeed

``` javascript
{
    "channelUser": {
        "channelUserId": "z1203155540315474420",
        "channelUserName": "testUser",
        "channelUserMoblie": "15010929368",
        "nickname": "",
        "orgName": "",
        "orgPath": ""
    },
	" channelNeedNo":"346c3091684e4e0eef",
	"needUserMoblie":"15010929361",
	"needDesc":"想申请一个  关于 鲸鱼  的商标，用于教育行业",
	"city":"北京市"
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "data": {
        "needNo": " e392dc87c70"
    },
    "msg": "需求方案创建成功",
    "requestId": "0c14f04dc187486b829e392dc87c70c6"
}

```

## **<a name="getNeedInfo"> 需求方案-商标信息</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getNeedInfo

``` javascript
{
"channelUserId": "channelUserIdtest01",
"needNo":"346c3091684e4e0eef"
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": [
        {
            "id": 955,
            "tbCode": "2019040114280983097851",
            "tmType": "p",
            "tmFormTypeName": "字",
            "tmFormType": "3",
            "itemCode": 33,
            "itemName": "",
            "nclOneCodes": "25",
            "nclSmallCodes": "[{\"code\":\"C250005\",\"name\":\"童装\",\"pcode\":\"2501\"},{\"code\":\"250057\",\"name\":\"成品衣\",\"pcode\":\"2501\"},{\"code\":\"250013\",\"name\":\"袜\",\"pcode\":\"2509\"},{\"code\":\"250045\",\"name\":\"服装\",\"pcode\":\"2505\"},{\"code\":\"250130\",\"name\":\"鞋\",\"pcode\":\"2507\"},{\"code\":\"250046\",\"name\":\"帽\",\"pcode\":\"2508\"},{\"code\":\"250092\",\"name\":\"婴儿全套衣\",\"pcode\":\"2502\"},{\"code\":\"250018\",\"name\":\"衣服吊带\",\"pcode\":\"2512\"},{\"code\":\"250155\",\"name\":\"T恤衫\",\"pcode\":\"2501\"}]",
            "submitTime": "",
            "tmRegistNum": "",
            "officialTypeName": "",
            "officialType": "",
            "notes": "",
            "opNotes": "",
            "subErrorMsg": "",
            "nclPublicExpense": "300.00",
            "tmName": "梦想真美好",
            "auditStatus": "00",
            "channelServiceNo": "2019081213508t9",
            "sourceOrderNo": "TMO2019081213508t9GH",
            "created_at": "2019-08-12T06:13:45.000Z",
            "tmOfficials": [
                {
                    "id": 226,
                    "officialTypeName": "商标注册申请书",
                    "officialType": "1",
                    "tmRegistNum": "40280354",
                    "officialFileName": "商标注册申请书_40280354_喜得益_33.pdf",
                    "officialFileUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_38715656607601102019139460110TMZC40280354.pdf",
                    "notes": "",
                    "name": "",
                    "code": "",
                    "created_at": "2019-08-12T06:13:45.000Z"
                }
            ]
        }
    ],
    "requestId": "2016c54abe7249a2a1195d236b333f79"
}

```

## **<a name="tmConfirm"> 商标方案确认</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：tmConfirm

``` javascript
{
	"channelUserId":"testUser",
    "deliveryOrderNo ":"346c3091684e4e0eef",
    "isConfirm ":"1",
    "notes ":"",

}

```

#### 返回结果
```javascript
{
    "status":0,
    "data":null,
    "msg":"商标方案确认成功",
    "requestId":"0c14f04dc187486b829e392dc87c70c6"
}

```

## **<a name="updateTmInfo"> 商标订单修改-商标信息修改</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：updateTmInfo

``` javascript
{
"channelUserId": "channelUserIdtest01",
	    "deliveryOrderNo":"JF201910301606zlBced",
	    "tmName":"测试修改",
	    "tmFormType":"7",
	    "picUrl":"http://www.2345.com/images/logo/logo_normal_20181008.png",
	    "colorizedPicUrl":"http://e.hiphotos.baidu.com/image/h%3D300/sign=a9e671b9a551f3dedcb2bf64a4eff0ec/4610b912c8fcc3cef70d70409845d688d53f20f7.jpg",
	    "notes":"测试说明"
}

```

#### 返回结果
```javascript
{
"status":0,
"msg":"success",
"data":null,
"requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="updateNclInfo"> 商标订单修改-商标尼斯信息修改</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：updateNclInfo

``` javascript
{
        "channelUserId": "channelUserIdtest01",
	    "deliveryOrderNo":"JF201910301606zlBced",
	    "tbCode":"TB201910301606SFn4MO",
	    "nclOneCodes":"01",
	    "nclSmallCodes":[{"code":"","name":"工业用人造石墨","fullname":" 工业用人造石墨","pcode":"0101","disabled":false}]
}

```

#### 返回结果
```javascript
{
"status":0,
"msg":"success",
"data":null,
"requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="updateContacts"> 商标订单修改-修改商标交付单联系人</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：updateContacts

``` javascript
{
"channelUserId": "channelUserIdtest01",	    
"deliveryOrderNo":"JF201910301606zlBced",
	    "name":"测试联系人",
	    "mobile":"13075556666",
	    "email":"257111114@qq.com",
	    "tel":"0531255555"
}

```

#### 返回结果
```javascript
{
"status":0,
"msg":"success",
"data":null,
"requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="updateCustomerInfo"> 商标订单修改-修改申请人信息</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：updateCustomerInfo

``` javascript
{
"channelUserId": "channelUserIdtest01",
        "deliveryOrderNo":"JF201910301606zlBced",
	    "customerType":"person",
	    "name":"测试申请人名称",
	    "code":"111222333444",
	    "applyAddr":"北京市测试地址",
	    "zipCode":"261514",
	    "identityCardPic":"http://f.hiphotos.baidu.com/image/h%3D300/sign=0c78105b888ba61ec0eece2f713597cc/0e2442a7d933c8956c0e8eeadb1373f08202002a.jpg",
	    "businessLicensePic":"http://f.hiphotos.baidu.com/image/h%3D300/sign=d985fb87d81b0ef473e89e5eedc551a1/b151f8198618367aa7f3cc7424738bd4b31ce525.jpg",
"identityCardPdf":"http://f.hiphotos.baidu.com/image/h%3D300/sign=0c78105b888ba61ec0eece2f713597cc/0e2442a7d933c8956c0e8eeadb1373f08202002a.jpg",
	    "businessLicensePdf":"http://f.hiphotos.baidu.com/image/h%3D300/sign=d985fb87d81b0ef473e89e5eedc551a1/b151f8198618367aa7f3cc7424738bd4b31ce525.jpg"

}

```

#### 返回结果
```javascript
{
"status":0,
"msg":"success",
"data":null,
"requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="updateOfficial"> 商标订单修改-修改交官文件</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：updateOfficial

``` javascript
{
"channelUserId": "channelUserIdtest01",         
"deliveryOrderNo":"JF201910301606zlBced",
	    "gzwtsUrl":"http://a.hiphotos.baidu.com/image/h%3D300/sign=a62e824376d98d1069d40a31113eb807/838ba61ea8d3fd1fc9c7b6853a4e251f94ca5f46.jpg",
	"smwjUrl":"http://b.hiphotos.baidu.com/image/h%3D300/sign=92afee66fd36afc3110c39658318eb85/908fa0ec08fa513db777cf78376d55fbb3fbd9b3.jpg",	    "identityCardPic":"http://f.hiphotos.baidu.com/image/h%3D300/sign=0c78105b888ba61ec0eece2f713597cc/0e2442a7d933c8956c0e8eeadb1373f08202002a.jpg",
	    "businessLicensePic":"http://f.hiphotos.baidu.com/image/h%3D300/sign=d985fb87d81b0ef473e89e5eedc551a1/b151f8198618367aa7f3cc7424738bd4b31ce525.jpg",
"identityCardPdf":"http://f.hiphotos.baidu.com/image/h%3D300/sign=0c78105b888ba61ec0eece2f713597cc/0e2442a7d933c8956c0e8eeadb1373f08202002a.jpg",
	    "businessLicensePdf":"http://f.hiphotos.baidu.com/image/h%3D300/sign=d985fb87d81b0ef473e89e5eedc551a1/b151f8198618367aa7f3cc7424738bd4b31ce525.jpg"

}

```

#### 返回结果
```javascript
{
"status":0,
"msg":"success",
"data":null,
"requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="getProductDetail"> 产品详情</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getProductDetail

``` javascript
{
    "channelUserId": "testUserId01",
	"channelItemCode":"3492659"
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":{
        "id":4,
        "app_id":2,
        "itemCode":"fzsbzc",
        "itemName":"商标注册-专家辅助申请",
        "picUrl":null,
        "channelItemCode":"3492659",
        "channelItemName":"【商标注册】专家辅助申请",
        "serviceItemCode":"autosubmit_tm_1688",
        "proPrice":0,
        "serviceCharge":0,
        "publicExpense":0,
        "rateConfig":"0.00",
        "discountsRateConfig":"0.00"
    },
    "requestId":"8f35053243f14958828b3f378fa5828b"
}

```

## **<a name="getProductListByTypeOneCode"> 产品列表-根据产品大类获取</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getProductListByTypeOneCode

``` javascript
{
     "channelUserId": "testUserId01",
	"itemCode":"sbfu"
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":3,
            "app_id":2,
            "itemCode":"zzsbzc",
            "itemName":"商标注册-自助注册申请",
            "picUrl":null,
            "channelItemCode":"1406046",
            "channelItemName":"【商标注册】自助注册申请",
            "serviceItemCode":"zzsbzc",
            "proPrice":0,
            "serviceCharge":0,
            "publicExpense":0,
            "rateConfig":"0.00",
            "discountsRateConfig":"0.00"
        },
        {
            "id":4,
            "app_id":2,
            "itemCode":"fzsbzc",
            "itemName":"商标注册-专家辅助申请",
            "picUrl":null,
            "channelItemCode":"3492659",
            "channelItemName":"【商标注册】专家辅助申请",
            "serviceItemCode":"autosubmit_tm_1688",
            "proPrice":0,
            "serviceCharge":0,
            "publicExpense":0,
            "rateConfig":"0.00",
            "discountsRateConfig":"0.00"
        }
    ],
    "requestId":"407622edd9ca4772a4eb40a54e488fac"
}

```

## **<a name="getProductListByTypeCode"> 产品列表-根据产品二类获取</a>**
[返回到目录](#menu)
##### URL
[/action/tmOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getProductListByTypeCode

``` javascript
{
     "channelUserId": "testUserId01",
	"itemCode":"sbzc"
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":3,
            "app_id":2,
            "itemCode":"zzsbzc",
            "itemName":"商标注册-自助注册申请",
            "picUrl":null,
            "channelItemCode":"1406046",
            "channelItemName":"【商标注册】自助注册申请",
            "serviceItemCode":"zzsbzc",
            "proPrice":0,
            "serviceCharge":0,
            "publicExpense":0,
            "rateConfig":"0.00",
            "discountsRateConfig":"0.00"
        },
        {
            "id":4,
            "app_id":2,
            "itemCode":"fzsbzc",
            "itemName":"商标注册-专家辅助申请",
            "picUrl":null,
            "channelItemCode":"3492659",
            "channelItemName":"【商标注册】专家辅助申请",
            "serviceItemCode":"autosubmit_tm_1688",
            "proPrice":0,
            "serviceCharge":0,
            "publicExpense":0,
            "rateConfig":"0.00",
            "discountsRateConfig":"0.00"
        }
    ],
    "requestId":"407622edd9ca4772a4eb40a54e488fac"
}

```

## **<a name="getCAProductDetail"> 产品详情-应用中心</a>**
[返回到目录](#menu)
##### URL
[/action/product/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getCAProductDetail

``` javascript
{
	"channelItemCode":"FW_GOODS-581976-1"
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":1,
            "uapp_id":16,
            "path_code":"sbfu/sbzc",
            "path_name":"商标服务/商标注册",
            "item_code":"zzsbzc",
            "item_name":"商标注册【自助申请】",
            "pic_url":null,
            "product_desc":"{"logo":"","desc":["自己检索商标,准备官方所需注册材料","提交迅速,及时反馈","全流程跟踪,掌握申请进度"]}",
            "channel_item_code":"FW_GOODS-581976-1",
            "channel_item_name":"商标注册【自助申请】",
            "sort":0,
            "productType_id":2,
            "created_at":"2020-01-07T15:29:57.000Z",
            "product_id":1,
            "price":300,
            "supply_price":0,
            "service_charge":0,
            "public_expense":0,
            "channel_profit_rate":0,
            "price_type":"mj",
            "price_type_name":"每件",
            "price_desc":null,
            "min_qty":1,
            "max_qty":100,
            "type_id":2,
            "p_id":1,
            "type_code":"sbzc",
            "type_name":"商标注册",
            "type_pic":null,
            "type_desc":null,
            "type_icon":null,
            "p_type_id":1,
            "p_type_code":"sbfu",
            "p_type_name":"商标服务",
            "p_type_pic":null,
            "p_type_desc":null,
            "p_type_icon":null,
            "productPriceList":[
                {
                    "price":300,
                    "supply_price":0,
                    "service_charge":0,
                    "public_expense":0,
                    "is_default":1,
                    "price_type":"mj",
                    "price_type_name":"每件",
                    "sort":1,
                    "price_desc":null,
                    "min_qty":1,
                    "max_qty":100
                }
            ]
        }
    ],
    "requestId":"0f2cad6ead8f4788b61bdd619f45732e"
}

```

## **<a name="getCAProductListByTypeOneCode"> 产品列表-根据产品大类获取-应用中心</a>**
[返回到目录](#menu)
##### URL
[/action/product/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getCAProductListByTypeOneCode

``` javascript
{
    "typeOneCode":"sbfu"
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":1,
            "uapp_id":16,
            "path_code":"sbfu/sbzc",
            "path_name":"商标服务/商标注册",
            "item_code":"zzsbzc",
            "item_name":"商标注册【自助申请】",
            "pic_url":null,
            "product_desc":"{"logo":"","desc":["自己检索商标,准备官方所需注册材料","提交迅速,及时反馈","全流程跟踪,掌握申请进度"]}",
            "channel_item_code":"FW_GOODS-581976-1",
            "channel_item_name":"商标注册【自助申请】",
            "sort":0,
            "productType_id":2,
            "created_at":"2020-01-07T15:29:57.000Z",
            "product_id":1,
            "price":300,
            "supply_price":0,
            "service_charge":0,
            "public_expense":0,
            "channel_profit_rate":0,
            "price_type":"mj",
            "price_type_name":"每件",
            "price_desc":null,
            "min_qty":1,
            "max_qty":100,
            "type_id":2,
            "p_id":1,
            "type_code":"sbzc",
            "type_name":"商标注册",
            "type_pic":null,
            "type_desc":null,
            "type_icon":null,
            "p_type_id":1,
            "p_type_code":"sbfu",
            "p_type_name":"商标服务",
            "p_type_pic":null,
            "p_type_desc":null,
            "p_type_icon":null
        },
        {
            "id":2,
            "uapp_id":16,
            "path_code":"sbfu/sbzc",
            "path_name":"商标服务/商标注册",
            "item_code":"fzsbzc",
            "item_name":"商标注册【专家辅助申请】",
            "pic_url":null,
            "product_desc":"{"logo":"","desc":["由专业代理人帮您检索分析,成功率高","为您优化注册方案,全方位保护","代理人全流程服务,24小时拿到官方申请号"]}",
            "channel_item_code":"FW_GOODS-580010-1",
            "channel_item_name":"商标注册【专家辅助申请】",
            "sort":0,
            "productType_id":2,
            "created_at":"2020-01-07T15:30:34.000Z",
            "product_id":2,
            "price":699,
            "supply_price":0,
            "service_charge":0,
            "public_expense":0,
            "channel_profit_rate":0,
            "price_type":"mj",
            "price_type_name":"每件",
            "price_desc":null,
            "min_qty":1,
            "max_qty":100,
            "type_id":2,
            "p_id":1,
            "type_code":"sbzc",
            "type_name":"商标注册",
            "type_pic":null,
            "type_desc":null,
            "type_icon":null,
            "p_type_id":1,
            "p_type_code":"sbfu",
            "p_type_name":"商标服务",
            "p_type_pic":null,
            "p_type_desc":null,
            "p_type_icon":null
        },
        {
            "id":3,
            "uapp_id":16,
            "path_code":"sbfu/sbzc",
            "path_name":"商标服务/商标注册",
            "item_code":"dbsbzc",
            "item_name":"商标注册【担保申请】",
            "pic_url":"",
            "product_desc":"{"logo":"","desc":["专业代理人精准评估,风险共担","注册不成功,全额退款","24小时拿到官方申请号"]}",
            "channel_item_code":"FW_GOODS-581978-1",
            "channel_item_name":"商标注册【担保申请】",
            "sort":0,
            "productType_id":2,
            "created_at":"2020-01-07T15:30:34.000Z",
            "product_id":3,
            "price":1380,
            "supply_price":0,
            "service_charge":0,
            "public_expense":0,
            "channel_profit_rate":0,
            "price_type":"mj",
            "price_type_name":"每件",
            "price_desc":"",
            "min_qty":1,
            "max_qty":100,
            "type_id":2,
            "p_id":1,
            "type_code":"sbzc",
            "type_name":"商标注册",
            "type_pic":null,
            "type_desc":null,
            "type_icon":null,
            "p_type_id":1,
            "p_type_code":"sbfu",
            "p_type_name":"商标服务",
            "p_type_pic":null,
            "p_type_desc":null,
            "p_type_icon":null
        }
    ],
    "requestId":"cb12e4a2f91440ab8f0d79b6845298e8"
}
```

## **<a name="getCAProductListByTypeCode"> 产品列表-根据产品二类获取-应用中心</a>**
[返回到目录](#menu)
##### URL
[/action/product/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getCAProductListByTypeCode

``` javascript
{
    "typeCode":"sbzc"
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":1,
            "uapp_id":16,
            "path_code":"sbfu/sbzc",
            "path_name":"商标服务/商标注册",
            "item_code":"zzsbzc",
            "item_name":"商标注册【自助申请】",
            "pic_url":null,
            "product_desc":"{"logo":"","desc":["自己检索商标,准备官方所需注册材料","提交迅速,及时反馈","全流程跟踪,掌握申请进度"]}",
            "channel_item_code":"FW_GOODS-581976-1",
            "channel_item_name":"商标注册【自助申请】",
            "sort":0,
            "productType_id":2,
            "created_at":"2020-01-07T15:29:57.000Z",
            "product_id":1,
            "price":300,
            "supply_price":0,
            "service_charge":0,
            "public_expense":0,
            "channel_profit_rate":0,
            "price_type":"mj",
            "price_type_name":"每件",
            "price_desc":null,
            "min_qty":1,
            "max_qty":100,
            "type_id":2,
            "p_id":1,
            "type_code":"sbzc",
            "type_name":"商标注册",
            "type_pic":null,
            "type_desc":null,
            "type_icon":null,
            "p_type_id":1,
            "p_type_code":"sbfu",
            "p_type_name":"商标服务",
            "p_type_pic":null,
            "p_type_desc":null,
            "p_type_icon":null
        },
        {
            "id":2,
            "uapp_id":16,
            "path_code":"sbfu/sbzc",
            "path_name":"商标服务/商标注册",
            "item_code":"fzsbzc",
            "item_name":"商标注册【专家辅助申请】",
            "pic_url":null,
            "product_desc":"{"logo":"","desc":["由专业代理人帮您检索分析,成功率高","为您优化注册方案,全方位保护","代理人全流程服务,24小时拿到官方申请号"]}",
            "channel_item_code":"FW_GOODS-580010-1",
            "channel_item_name":"商标注册【专家辅助申请】",
            "sort":0,
            "productType_id":2,
            "created_at":"2020-01-07T15:30:34.000Z",
            "product_id":2,
            "price":699,
            "supply_price":0,
            "service_charge":0,
            "public_expense":0,
            "channel_profit_rate":0,
            "price_type":"mj",
            "price_type_name":"每件",
            "price_desc":null,
            "min_qty":1,
            "max_qty":100,
            "type_id":2,
            "p_id":1,
            "type_code":"sbzc",
            "type_name":"商标注册",
            "type_pic":null,
            "type_desc":null,
            "type_icon":null,
            "p_type_id":1,
            "p_type_code":"sbfu",
            "p_type_name":"商标服务",
            "p_type_pic":null,
            "p_type_desc":null,
            "p_type_icon":null
        },
        {
            "id":3,
            "uapp_id":16,
            "path_code":"sbfu/sbzc",
            "path_name":"商标服务/商标注册",
            "item_code":"dbsbzc",
            "item_name":"商标注册【担保申请】",
            "pic_url":"",
            "product_desc":"{"logo":"","desc":["专业代理人精准评估,风险共担","注册不成功,全额退款","24小时拿到官方申请号"]}",
            "channel_item_code":"FW_GOODS-581978-1",
            "channel_item_name":"商标注册【担保申请】",
            "sort":0,
            "productType_id":2,
            "created_at":"2020-01-07T15:30:34.000Z",
            "product_id":3,
            "price":1380,
            "supply_price":0,
            "service_charge":0,
            "public_expense":0,
            "channel_profit_rate":0,
            "price_type":"mj",
            "price_type_name":"每件",
            "price_desc":"",
            "min_qty":1,
            "max_qty":100,
            "type_id":2,
            "p_id":1,
            "type_code":"sbzc",
            "type_name":"商标注册",
            "type_pic":null,
            "type_desc":null,
            "type_icon":null,
            "p_type_id":1,
            "p_type_code":"sbfu",
            "p_type_name":"商标服务",
            "p_type_pic":null,
            "p_type_desc":null,
            "p_type_icon":null
        }
    ],
    "requestId":"3708d266442a45edbfedaf87d26f6400"
}
```

