﻿var url = require("url");
var system = require("../../base/system");
var utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
module.exports = function (app) {
	//-----------------------新的模式------------------开始
	app.use('/tlpay/notify', function (req, res) {
		// var client_ip = system.get_client_ip(req);
		// // req.body["client_ip"]=client_ip;
		// var orderSve = system.getObject("service.dborder.orderSve");
		// var p = orderSve.receiveTlCallBackNotify(req.body);
		// p.then(r => {
		// 	res.end(JSON.stringify(r));
		// });
	});

	app.all("/web/*", async function (req, res, next) {
		var result = system.getResult(null, "req method must is post");
		if (req.method != "POST") {
			res.end(JSON.stringify(result));
			return;
		}
		if (!req.body.actionType) {
			result.msg = "actionType can not be empty";
			res.end(JSON.stringify(result));
			return;
		}
		if (["getAppTokenByHosts", "getAppTokenByAppKey"].indexOf(req.body.actionType) >= 0) {
			req.body.actionBody.appHosts = req.host;
			next();
			return;
		}
		if (req.body.actionType == "receiveCallBackNotify") {
			req.body.actionBody.app_hosts = req.host;
			next();
			return;
		}
		var token = req.headers["token"] || "";
		if (!token) {
			result.msg = "req headers token can not be empty";
			res.end(JSON.stringify(result));
			return;
		}
		var cacheManager = system.getObject("db.common.cacheManager");
		var result = await cacheManager["AppTokenByHostsCache"].getCache(token, system.exTime);
		if (result.status != 0) {
			res.end(JSON.stringify(result));
			return result;
		}
		req.body.appInfo = result.data;
		req.body.actionProcess = result.data.app_code;
		var lst = [
			"addOrder", "getH5PayUrl", "getOrderQrCode", "queryOrderStatus", "getOrderInfo","getOrderDeliveryInfo",
			"getTmNclList", "getNeedInfo",
			"tmConfirm", "updateTmInfo",
			"updateNclInfo", "updateContacts",
			"updateCustomerInfo", "addOrderAndDelivery",
			"updateOrderPayStatus", "getPolicyNeedList", "submitPolicyNeedNotes"
		];
		if (lst.indexOf(req.body.actionType) >= 0) {
			var userpin = req.headers["userpin"] || "";
			if (!userpin) {
				result.status = system.noLogin;
				result.msg = "req headers userpin can not be empty";
				res.end(JSON.stringify(result));
				return;
			} else {
				var params = {
					"appInfo": req.body.appInfo,
					"actionType": "getLoginInfo",
					"actionBody": {
						"userpin": userpin
					}
				}
				result = await utilsAuthSve.getLoginInfo(params, params.actionBody);
				if (result.status != 0) {
					result.status = system.noLogin;
					result.msg = "user login is invalidation";
					res.end(JSON.stringify(result));
					return result;
				}
				req.body.userInfo = result.data;
			}
		}//需要用户登录
		next();
	});

	app.get('/web/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];

		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);
		req.clientIp = tClientIp; req
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		var params = [];
		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexecMethod"]) {
			p = invokeObj["doexecMethod"].apply(invokeObj, params); req
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
	app.post('/web/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];
		var params = [];
		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);

		req.clientIp = tClientIp;
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexecMethod"]) {
			p = invokeObj["doexecMethod"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});

	//-----------------------新的模式------------------结束
};
