var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
//商标查询操作
class UtilsProductSve extends AppServiceBase {
  constructor() {
    super();
  }

  //--------------------------------应用中心获取产品信息-start-----------------------------------------------------


  /**
   * 通过产品类别编码路径获取产品列表
   * @param {*} pobj 
   * @param {*} actionBody pathCode 为类别编码路径，一级类下产品列表 sbfu，二级类下产品列表sbfu/sbzc
   */
  async getProductList(pobj, actionBody) {
    if (!actionBody.pathCode) {
      return system.getResult(null, "actionBody.pathCode can not be empty");
    }
    pobj.actionBody.pathCode = "/" + actionBody.pathCode + "/";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    return await this.restPostUrl(pobj, url);
  }
  /**
   * 获取产品详情
  * @param {*} pobj 
   * @param {*} actionBody channelItemCode 渠道产品编码
   */
  async getProductDetail(pobj, actionBody) {
    if (!actionBody.channelItemCode) {
      return system.getResult(null, "actionBody.channelItemCode can not be empty");
    }
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    return await this.restPostUrl(pobj, url);
  }

  //--------------------------------应用中心获取产品信息--end----------------------------------------------------

}
module.exports = UtilsProductSve;

