const system = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const AppServiceBase = require("../../app.base");
class UtilsOrderService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.tlPayNotifyUrl = settings.tlPayNotifyUrl();
    this.centerAppPayUrl = settings.centerAppUrl() + "payment/paymentApi/springBoard";
  };
  /*
* 订单验证
*/
  async isOrderVerify(pobj, actionBody) {
    var price_list = actionBody.product_info.price_list;
    if (!price_list) {
      return system.getResult(null, "产品价格列表信息有误，10080");
    }
    var product_price = price_list.filter(f => f.pay_code == actionBody.payCode);
    if (!product_price || product_price.length == 0) {
      return system.getResult(null, "支付价格payCode信息有误，10110");
    }
    var totalSum = Number(product_price[0].price) * Number(actionBody.quantity);
    var buyTotalSum = Number(actionBody.totalSum || 0);
    var buyPayTotalSum = Number(actionBody.payTotalSum || 0);
    if (buyTotalSum == 0) {
      actionBody.totalSum = totalSum;
    }
    if (buyPayTotalSum == 0) {
      actionBody.payTotalSum = totalSum;
    }
    if (Number(actionBody.totalSum || 0) < totalSum) {
      return system.getResult(null, "订单金额有误，10130");
    }
    pobj.actionBody.product_info.price_item = product_price[0];
    return system.getResultSuccess();
  }
  /**
   * 创建订单
   * @param {*} pobj 
   * @param {*} actionBody {channelItemCode:渠道产品的编码，id:定价id,quantity:订单数量,totalSum:300}
   */
  async addOrder(pobj, actionBody) {
    if (!actionBody.channelItemCode) {
      return system.getResult(null, "产品编码有误，10010");
    }
    if (!actionBody.payCode) {
      return system.getResult(null, "支付价格payCode有误，10030");
    }
    if (!actionBody.quantity || Number(actionBody.quantity) <= 0) {
      return system.getResult(null, "订单数量有误，10050");
    }
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    pobj.actionType = "getProductDetail";
    var productItemResult = await this.restPostUrl(pobj, url);
    if (productItemResult.status != 0) {
      return productItemResult;
    }
    pobj.actionBody.product_info = productItemResult.data;
    var verifyResult = await this.isOrderVerify(pobj, pobj.actionBody);
    if (verifyResult.status != 0) {
      return verifyResult;
    }

    pobj.actionType = "getProductInterface";
    pobj.actionBody.productPriceId = pobj.actionBody.product_info.price_item.id;
    var productItemInterfaceResult = await this.restPostUrl(pobj, url);
    // if (productItemInterfaceResult.status != 0) {
    //   return productItemInterfaceResult;
    // }
    productItemResult.data.interface_info = productItemInterfaceResult.data;

    pobj.actionType = "addOrder";
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    console.log(pobj);
    var result = await this.restPostUrl(pobj, reqUrl);
    result.serviceCode = pobj.actionBody.product_info.price_item.service_code;
    result.totalSum = actionBody.totalSum;
    return result;
  }
  async getOrderInfo(pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async getOrderDeliveryInfo(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty");
    }
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async icOrderStatusNotify(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty");
    }
    var reqUrl = this.centerOrderUrl + "notifyaction/oporder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }


  /**
   * 获取H5支付地址
   * @param {*} pobj 
   * @param {*} actionBody {orderNo:XXXX}
   */
  async getH5PayUrl(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty");
    }
    pobj.actionType = "getPayOrderInfo";
    var orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
    var orderResult = await this.restPostUrl(pobj, orderUrl);
    if (orderResult.status != 0) {
      return orderResult;
    }
    // pobj.actionBody.body_desc, pobj.actionBody.total_fee, pobj.actionBody.order_num, pobj.actionBody.returl
    pobj.actionBody.body_desc = orderResult.data.orderProduct.channelItemName;
    pobj.actionBody.total_fee = Number(orderResult.data.receiptVoucher.totalSum) * 100;
    pobj.actionBody.order_num = orderResult.data.receiptVoucher.sourceOrderNo;
    pobj.actionBody.returl = this.tlPayNotifyUrl;
    pobj.actionType = "getH5PayUrl";

    var result = await this.restPostUrl(pobj, this.centerAppPayUrl);
    if (result.status != 0) {
      return result;
    }
    await this.cacheManager["TlPayLocker"].init(orderResult.data.receiptVoucher.sourceOrderNo);
    return result;
  }
  /**
   * 获取二维码
   * @param {*} pobj 
   * @param {*} actionBody {orderNo:XXXX,opType:"wx"}---"wx":"微信","alipay":"支付宝"
   */
  async getOrderQrCode(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty");
    }
    pobj.actionType = "getPayOrderInfo";
    var orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
    var orderResult = await this.restPostUrl(pobj, orderUrl);
    if (orderResult.status != 0) {
      return orderResult;
    }
    //查询支付流水号是否已经支付
    var receiptVoucher = orderResult.data.receiptVoucher;
    pobj.actionType = "queryOrderStatus";
    var url = this.centerAppUrl + "payment/paymentApi/queryOrder";
    if (receiptVoucher.busPayOrderCode != receiptVoucher.wxPayOrderCode) {
      pobj.actionBody.trxid = wxPayOrderCode;
      var wxPayStatus = await this.restPostUrl(pobj, url);
      if (wxPayStatus && wxPayStatus.code == 1 && wxPayStatus.data.trxstatus == "0000") {
        return system.getResultFail(-140, "订单已支付，请勿重复付款");
      }
    }
    if (receiptVoucher.busPayOrderCode != receiptVoucher.aliPayOrderCode) {
      pobj.actionBody.trxid = aliPayOrderCode;
      var aliPayStatus = await this.restPostUrl(pobj, url);
      if (aliPayStatus && aliPayStatus.code == 1 && aliPayStatus.data.trxstatus == "0000") {
        return system.getResultFail(-150, "订单已支付，请勿重复付款");
      }
    }

    // pobj.actionBody.body_desc, pobj.actionBody.total_fee, pobj.actionBody.order_num, pobj.actionBody.op_type
    pobj.actionBody.body_desc = orderResult.data.orderProduct.channelItemName;
    pobj.actionBody.total_fee = Number(receiptVoucher.totalSum) * 100;
    pobj.actionBody.order_num = receiptVoucher.sourceOrderNo;
    pobj.actionBody.op_type = actionBody.opType;
    pobj.actionType = "getOrderQrCode";

    var result = await this.restPostUrl(pobj, this.centerAppPayUrl);
    if (result.status != 0) {
      return result;
    }
    //更新DB付款信息
    var isPut = 0;
    var setField = {};
    if (opType == "wx") {
      if (actionBody.trxid != receiptVoucher.wxPayOrderCode) {
        setField.wxPayOrderCode = tResult.data.trxid;
        receiptVoucher.wxPayOrderCode = tResult.data.trxid;
        isPut = 1;
      }
    } else {
      //支付宝
      if (actionBody.trxid != receiptVoucher.aliPayOrderCode) {
        setField.aliPayOrderCode = tResult.data.trxid;
        receiptVoucher.aliPayOrderCode = tResult.data.trxid;
        isPut = 1;
      }
    }
    pobj.actionBody.isPut;
    pobj.actionBody.setField = setField;
    pobj.actionBody.receiptVoucherId = receiptVoucher.id;
    pobj.actionBody.trxid = result.data.trxid;
    pobj.actionType = "putReceiptVoucherInfo";
    var putOrderResult = await this.restPostUrl(pobj, orderUrl);
    if (putOrderResult.status != 0) {
      return putOrderResult;
    }
    if (isPut > 0) {
      await this.cacheManager["TlPayLocker"].init(receiptVoucher.sourceOrderNo);
    }
    result.wxPayOrderCode = receiptVoucher.wxPayOrderCode;
    result.aliPayOrderCode = receiptVoucher.aliPayOrderCode;
    return result;
  }
  /**
   * 查询订单状态
   * @param {*} pobj 
   * @param {*} actionBody {orderNo:XXXX,opType:"wx"}---"wx":"微信","alipay":"支付宝"
   */
  async queryOrderStatus(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty");
    }
    if (!actionBody.opType) {
      return system.getResult(null, "actionBody.opType can not be empty");
    }
    pobj.actionType = "getPayOrderInfo";
    var orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
    var orderResult = await this.restPostUrl(pobj, url);
    if (orderResult.status != 0) {
      return orderResult;
    }
    //检查流水号是否已经支付
    var receiptVoucher = orderResult.data.receiptVoucher;
    var payTrxid = opType == "wx" ? receiptVoucher.wxPayOrderCode : receiptVoucher.aliPayOrderCode;
    pobj.actionBody.trxid = payTrxid;
    pobj.actionType = "queryOrderStatus";

    var payStatus = await this.restPostUrl(pobj, this.centerAppPayUrl);

    if (payStatus.data && payStatus.data.trxstatus == "0000") {
      //TODO:处理支付成功的业务逻辑
      // payStatus.data.client_ip = obj.client_ip || "";
      // let attachList = [];
      // if (payStatus.data.reqsn.indexOf("_") >= 0) {
      //   attachList = payStatus.data.reqsn.split("_");
      // }
      // else {
      //   attachList.push(payStatus.data.reqsn);
      // }
      // if (attachList.length != 2) {
      //   return {  -120, msg: "reqsn参数错误，没有_标识" };
      // }
      // payStatus.data.out_trade_no = attachList[0];
      // payStatus.data.company_id = attachList[1];
      // return await this.utilstlbankSve.opBackNotify(payStatus.data, "页面回调");
    }
    else if (payStatus.data && payStatus.data.trxstatus == "3045") {
      return system.getResultFail(-330, "超时未支付，请刷新页面");
    }
    return system.getResultFail(-130, "请及时支付");
  }
  /**
   * 只是获取二维码--不跟订单关联
   * @param {*} pobj 
   * @param {*} actionBody 
   * "actionBody": {
        "order_num": order.orderNo,
        "total_fee": Number(order.totalSum) * 100,
        "body_desc": order.itemName,
        "op_type": obj.opType
      }
   */
  async getQrCode(pobj, actionBody) {
    if (!actionBody.order_num) {
      return system.getResult(null, "actionBody.order_num can not be empty");
    }
    if (!actionBody.total_fee) {
      return system.getResult(null, "actionBody.total_fee can not be empty");
    }
    if (!actionBody.body_desc) {
      return system.getResult(null, "actionBody.body_desc can not be empty");
    }
    if (!actionBody.op_type) {
      return system.getResult(null, "actionBody.op_type can not be empty");
    }
    if (actionBody.op_type != "wx" && actionBody.op_type != "alipay") {
      return system.getResult(null, "actionBody.op_type param error");
    }

    return await this.restPostUrl(pobj, this.centerAppPayUrl);
  }
  /**
   * 只是检查支付状态--不跟订单关联
   * @param {*} pobj 
   * @param {*} actionBody { "trxid": payTrxid 支付流水号}
   */
  async queryOrder(pobj, actionBody) {
    if (!actionBody.trxid) {
      return system.getResult(null, "actionBody.trxid can not be empty");
    }

    return await this.restPostUrl(pobj, this.centerAppPayUrl);
  }
  async receiveCallBackNotify(pobj, actionBody) {//---暂时没有用到
    var url = this.centerAppUrl + "payment/paymentApi/receiveCallBackNotify";
    return await this.restPostUrl(pobj, url);
  }
}
module.exports = UtilsOrderService;
