const system = require("../../../system");
const crypto = require('crypto');
var settings = require("../../../../config/settings");
class PolicyService{
  constructor() {
    this.centerOrderUrl = settings.centerOrderUrl();
    this.execClient = system.getObject("util.execClient");
    this.cacheManager = system.getObject("db.common.cacheManager");
  };
  // sha1加密
  sha1(str) {
    let shasum = crypto.createHash("sha1")
    shasum.update(str)
    str = shasum.digest("hex")
    return str
  }

  /**
   * 生成签名的时间戳
   * @return {字符串}
   */
  createTimestamp() {
    return parseInt(new Date().getTime() / 1000) + ''
  }

  /**
   * 生成签名的随机串
   * @return {字符串}
   */
  createNonceStr() {
    return Math.random().toString(36).substr(2, 15)
  }

  /**
   * 对参数对象进行字典排序
   * @param  {对象} args 签名所需参数对象
   * @return {字符串}    排序后生成字符串
   */
  raw(args) {
    var keys = Object.keys(args)
    keys = keys.sort()
    var newArgs = {}
    keys.forEach(function (key) {
      newArgs[key.toLowerCase()] = args[key]
    })

    var string = ''
    for (var k in newArgs) {
      string += '&' + k + '=' + newArgs[k]
    }
    string = string.substr(1)
    return string
  }
  async getWxSign(url){
    try {
      if(!url){
        return system.getResult("url不能为空");
      }
      var tokenRes =  await this.cacheManager["WxTokenCache"].get();
      if(tokenRes){
        if(tokenRes.access_token){
          var ticketRes =  await this.cacheManager["WxJsapiTicketCache"].get(tokenRes.access_token);
          if(ticketRes){
            if(ticketRes.ticket){
              var ret = {
                jsapi_ticket: ticketRes.ticket,
                nonceStr: "zhengcepolicy",
                timestamp: parseInt(new Date().getTime() / 1000),
                url: url
              };
              var string = this.raw(ret)
              ret.signature = this.sha1(string)
              ret.appId = "wx8aa8a8d4ff3da8bd";
              console.log('ret', ret)
              return system.getResultSuccess(ret);
            }else{
              return system.getResultFail(-2,"获取微信配置参数失败",ticketRes);
            }
          }
        }else{
          return system.getResultFail(-1,"获取微信配置参数失败",tokenRes);
        }
        
      }
      return system.getResult("获取微信配置参数失败");
    } catch (e) {
      return system.getResult(e.stack);
    }
    
  }
  async reqPolicyApi(pobj){
    var url = this.centerOrderUrl + "action/policy/springBoard";
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }
  async policyQuery(pobj) {
    var url = this.centerOrderUrl + "action/policy/springBoard";
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }
  async submitPolicyNeed(pobj) {
    var url = this.centerOrderUrl + "action/policy/springBoard";
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }
  async getPolicyNeedList(pobj){
    var url = this.centerOrderUrl + "action/policy/springBoard";
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }
  async submitPolicyNeedNotes(pobj){
    var url = this.centerOrderUrl + "action/policy/springBoard";
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }
  async submitPolicysubscribe(pobj){
    var url = this.centerOrderUrl + "action/policy/springBoard";
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }
}
module.exports = PolicyService;
