const system = require("../../../system");
var settings = require("../../../../config/settings");
/**
 * 微信token
 * zhuangbing
 * 2020.02.17
 */
class WxTokenService{
    constructor(){
        this.rc=system.getObject("util.execClient");
        this.logDao = system.getObject("db.common.oplogDao");
    }
    /**
     * 获取微信access_token
     * 返回结果：
     * component_access_token	第三方平台access_token
     * expires_in	有效期
     */
    async getToken(){
        try{
            var url="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=wx8aa8a8d4ff3da8bd&secret=5b64d43832cfd08327e9369aa455f799";
            var rtn=await this.rc.execGet({},url);
            console.log(rtn);
            this.logDao.create({
                op: "WxTokenService/getToken",
                content: JSON.stringify(rtn),
                optitle: "获取政策微信access_token",
            });
            var result=JSON.parse(rtn.stdout);
            return result;
        }catch(e){
            return null;
        }
    }
    /**
     * 获取微信getJsapiTicket
     */
    async getJsapiTicket(access_token){
        try{
            var url="https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + access_token + "&type=jsapi";
            var rtn=await this.rc.execGet({},url);
            console.log(rtn);
            this.logDao.create({
                op: "WxTokenService/getJsapiTicket",
                content: JSON.stringify(rtn),
                optitle: "获取政策微信getJsapiTicket",
            });
            var result=JSON.parse(rtn.stdout);
            return result;
        }catch(e){
            return null;
        }
    }
    
}
module.exports=WxTokenService;