var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class IcbcOrderNotify extends APIBase {
    constructor() {
        super();
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        this.logCtl.info({
            appid: pobj.appInfo.uapp_id,
            appkey: pobj.appInfo.uapp_key,
            requestId: req.requestId,
            op: pobj.actionType,
            content: JSON.stringify(pobj),
            clientIp: req.clientIp,
            agent: req.uagent,
            optitle: "icbcOrderNotify信息通知记录",
        });
        switch (action_type) {
            case "icOrderStatusNotify"://工商状态通知
                opResult = await this.utilsOrderSve.icOrderStatusNotify(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = IcbcOrderNotify;