var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
/**
 * 接收远程推送的商标数据api
 */
class ReceiveDataAPI extends APIBase {
    constructor() {
        super();
        this.ordertmproductSve = system.getObject("service.dborder.ordertmproductSve");
        this.customerinfoSve = system.getObject("service.dborder.customerinfoSve");
        this.customercontactsSve = system.getObject("service.dborder.customercontactsSve");
        this.trademarkSve = system.getObject("service.dbtrademark.trademarkSve");
        this.zcApiUrl = settings.reqZcApi();
        this.pushFqbossDataUrl = settings.pushFqbossDataUrl();
        this.pushlogSve = system.getObject("service.common.pushlogSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
        return result;
    }
    async opActionProcess(action_process, action_type, action_body, pobj, req) {
        // var logParam = {
        //     appid: req.app.id,
        //     appkey: req.app.uappKey,
        //     requestId: req.requestId || "",
        //     op: "/igirl-channel/zhichan/igirl-channel/app/base/api/impl/action/receiveData.js/opActionProcess",
        //     content: "参数信息：" + JSON.stringify(action_body),
        //     clientIp: pobj.clientIp,
        //     optitle: "接收推送过来的数据处理=>action_type=" + action_type,
        // };
        var opResult = null;
        switch (action_type) {
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        logParam.resultInfo = JSON.stringify(opResult);
        this.logCtl.info(logParam);
        return opResult;
    }

}
module.exports = ReceiveDataAPI;