var APIBase = require("../../api.base");
var system = require("../../../system");
class PolicyAPI extends APIBase {
    constructor() {
        super();
        this.policySve = system.getObject("service.policy.policySve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj,pobj.actionProcess, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj,action_process, action_type, action_body, req) {
        var opResult = null;
        switch (action_type) {
            // sy
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "policyQuery"://政策检索
                opResult = await this.policySve.policyQuery(pobj);
                break;
            case "submitPolicyNeed"://政策申请提报
                opResult = this.policySve.submitPolicyNeed(pobj);
                break;
            case "getPolicyNeedList"://政策需求列表
                opResult = this.policySve.getPolicyNeedList(pobj);
                break;
            case "submitPolicyNeedNotes"://申请信息备注提交
                opResult = this.policySve.submitPolicyNeedNotes(pobj);
                break;
            case "getWxSign"://获取微信签名信息
                opResult = this.policySve.getWxSign(action_body.url);
                break;
            case "submitPolicysubscribe"://提交政策订阅
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "delPolicysubscribe"://取消政策订阅
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "getPolicysubscribeList"://获取政策订阅列表
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = PolicyAPI;