var APIBase = require("../../api.base");
var system = require("../../../system");
class LicenseQueryAPI extends APIBase {
    constructor() {
        super();
        this.liecseSve = system.getObject("service.licenses.licenseSve");
    }

    /**
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }

    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "getLicenses"://根据公司得到推荐要办的证书
                //opResult = await this.liecseSve.getLicenses(action_body);
                opResult = await this.liecseSve.opReqResult(pobj, req);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = LicenseQueryAPI;