const system = require("../system");
const settings = require("../../config/settings");
const DocBase = require("./doc.base");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
class APIBase {
    constructor() {
        this.restClient = system.getObject("util.restClient");
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.logCtl = system.getObject("service.common.oplogSve");
        this.toolSve = system.getObject("service.trademark.toolSve");
        this.exTime = 6 * 3600;//缓存过期时间，6小时
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    /**
     * 验证签名
     * @param {*} params 要验证的参数 
     * @param {*} app_key 应用的校验key
     */
    async verifySign(params, app_key) {
        if (!params) {
            return system.getResult(null, "请求参数为空");
        }
        if (!params.sign) {
            return system.getResult(null, "请求参数sign为空");
        }
        if (!params.timestamp) {
            return system.getResult(null, "请求参数timestamp为空");
        }
        var signArr = [];
        var keys = Object.keys(params).sort();
        if (keys.length == 0) {
            return system.getResult(null, "请求参数信息为空");
        }
        for (let k = 0; k < keys.length; k++) {
            const tKey = keys[k];
            if (tKey != "sign" && params[tKey]) {
                signArr.push(tKey + "=" + params[tKey]);
            }
        }
        if (signArr.length == 0) {
            return system.getResult(null, "请求参数组装签名参数信息为空");
        }
        var resultSignStr = signArr.join("&") + "&key=" + app_key;
        var resultTmpSign = md5(resultSignStr).toUpperCase();
        if (params.sign != resultTmpSign) {
            return system.getResult(null, "签名验证失败");
        }
        return system.getResultSuccess();
    }
    //-----------------------新的模式------------------开始

    async doexecMethod(gname, methodname, pobj, query, req) {
        req.requestId = this.getUUID();
        try {
            // //验证accesskey或验签
            // var isPassResult = await this.checkAcck(gname, methodname, pobj, query, req);
            // if (isPassResult.status != 0) {
            //     isPassResult.requestId = "";
            //     return isPassResult;
            // }
            var rtn = await this[methodname](pobj, query, req);
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(rtn),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务提供方appKey:" + settings.appKey,
            });
            rtn.requestId = req.requestId;
            return rtn;
        } catch (e) {
            console.log(e.stack, "api调用出现异常，请联系管理员..........")
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(e.stack),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api调用出现异常，请联系管理员error，appKey:" + settings.appKey,
            });
            this.logCtl.error({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: pobj.classname + "/" + methodname,
                content: e.stack,
                clientIp: pobj.clientIp,
                agent: req.uagent,
                optitle: "api调用出现异常，请联系管理员",
            });
            var rtnerror = system.getResultFail(-200, "出现异常，error：" + e.stack);
            rtnerror.requestId = req.requestId;
            return rtnerror;
        }
    }

    //-----------------------新的模式------------------结束

    async restPostUrl(pobj, url) {
        var rtn = await this.restClient.execPost(pobj, url);
        if (!rtn || !rtn.stdout) {
          return system.getResult(null, "restPost data is empty");
        }
        var result = JSON.parse(rtn.stdout);
        return result;
      }
}
module.exports = APIBase;
