{
  template: '${tmpl}',
    data: function() {

      return {
        useAcquiescentSpecialperformance: true,
        form: {
          siteTheme: "default",
          themeAddr: ""
        },
        startSiteTheme: "",
        startThemeAddr: "",
        theme: {
          info: '',
          img: ''
        }
      }
    },
  mounted: function() {
    this.fetchCompanyInfo();
  },
  created: function() {

  },
  methods: {
    toSpecialperformance(){
      this.$root.pushx({
        title: "交易专场",
        name: "/transactionspecialperformance"
      });
    },
    fetchCompanyInfo(){
      var that = this;
      this.$root.postReq("/web/companyCtl/getCompanyTheme").then(function (d) {
        console.log(d.data,'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        switch (d.data.sitetheme.siteTheme) {
          case 'default':
            that.theme.info = '提示：该主题首页偏科技、简约风格，类似阿里云商标注册页面。';
            that.theme.img = '/imgs/theme/default.png';
            break;
          case 'spring':
            that.theme.info = '提示：该主题首页突出服务产品，在首页是以九宫格样式展示服务产品。';
            that.theme.img = '/imgs/theme/spring.png';
            break;
          case 'summer':
            that.theme.info = '提示：该主题首页突出了工商、代账业务，包括各相关服务项目及工商核名等功能。';
            that.theme.img = '/imgs/theme/summer.png';
            break;
          case 'autumn':
            that.theme.info = '提示：该主题首页突出了商标交易业务，首页展示各商标交易专场及热门、精品等商标。';
            that.theme.img = '/imgs/theme/autumn.png';
            break;
          case 'winter':
            that.theme.info = '提示：该主题首页突出了专利服务，集成了专利检索、分析、专利大数据等功能。';
            that.theme.img = '/imgs/theme/winter.png';
            break;
        };
        /** */
        if (d.code == 1) {
          that.form.siteTheme = d.data.sitetheme.siteTheme;
          that.form.themeAddr = d.data.sitetheme.themeAddr;
          that.startSiteTheme = d.data.sitetheme.siteTheme;
          that.startThemeAddr = d.data.sitetheme.themeAddr;
        }
      })
    },
    siteThemeQuery(key){
      console.log(key, '1232132132131');
      switch (key) {
        case 'default':
          this.theme.info = '提示：该主题首页偏科技、简约风格，类似阿里云商标注册页面。';
          this.theme.img = '/imgs/theme/default.png';
          break;
        case 'spring':
          this.theme.info = '提示：该主题首页突出服务产品，在首页是以九宫格样式展示服务产品。';
          this.theme.img = '/imgs/theme/spring.png';
          break;
        case 'summer':
          this.theme.info = '提示：该主题首页突出了工商、代账业务，包括各相关服务项目及工商核名等功能。';
          this.theme.img = '/imgs/theme/summer.png';
          break;
        case 'autumn':
          this.theme.info = '提示：该主题首页突出了商标交易业务，首页展示各商标交易专场及热门、精品等商标。';
          this.theme.img = '/imgs/theme/autumn.png';
          break;
        case 'winter':
          this.theme.info = '提示：该主题首页突出了专利服务，集成了专利检索、分析、专利大数据等功能。';
          this.theme.img = '/imgs/theme/winter.png';
          break;
      };
      var obj = {
        siteTheme: key
      };
      var that = this;
      this.$root.postReq("/web/sitethemeCtl/getTheme", obj).then(function (d) {
        console.log(d);
        if (d.code == 1) {
          that.form.themeAddr = d.data.themeAddr;
        }
        else {
          that.$message.warning("操作失败，" + d.msg);
          that.form.siteTheme = that.startSiteTheme;
          that.form.themeAddr = that.startThemeAddr;
        }
      })
    },
    submit(){
      var obj = {
        siteTheme: this.form.siteTheme
      };
      var that = this;
      this.$root.postReq("/web/companyCtl/putCompanyTheme", obj).then(function (d) {
        console.log(d);
        if (d.code == 1) {
          that.$message.success("设在站点主题成功");
        }
      })
    },
    reset(){
      this.form.siteTheme = "";
      this.form.themeAddr = "";
    }

  },
  computed: {

  },
  vname: "gsb-footerinfo"
}
