const system = require("../../system");
const ServiceBase = require("../sve.base")
const settings = require("../../../config/settings")
const logCtl = system.getObject("web.oplogCtl");
class companyportraitService {
  constructor() {
    this.byTmSearchApi = system.getObject("api.bytmsearch");
    this.GsbByChinaAggApi = system.getObject("api.cpatentaggregations");
  }


  //商标数据分析
  async yearlist(lis) {
    var count2014 = 0;
    var count2015 = 0;
    var count2016 = 0;
    var count2017 = 0;
    var count2018 = 0;
    var count2019 = 0;
    var sqcount = 0;
    var yxcount = 0;
    var wxcount = 0;
    var otcount = 0;
    var nclone = [];
    lis.forEach(d => {
      switch (d.apply_year) {
        case 2014:
          count2014 += 1;
          break;
        case 2015:
          count2015 += 1;
          break;
        case 2016:
          count2016 += 1;
          break;
        case 2017:
          count2017 += 1;
          break;
        case 2018:
          count2018 += 1;
          break;
        case 2019:
          count2019 += 1;
          break;
        default:
          break;
      }
      switch (d.status) {
        case 1:
          sqcount += 1;
          break;
        case 2:
          yxcount += 1;
          break;
        case 3:
          yxcount += 1;
          break;
        case 4:
          wxcount += 1;
          break;
        case 5:
          otcount += 1;
          break;
        default:
          break;
      }
      nclone.push(d.ncl_one_codes);
    }
    );
    var yearcount = [{ "key": "2014", "value": count2014 }, { "key": "2015", "value": count2015 }, { "key": "2016", "value": count2016 },
    { "key": "2017", "value": count2017 }, { "key": "2018", "value": count2018 }, { "key": "2019", "value": count2019 }];
    var statuscount = [{ "key": "有效注册", "value": yxcount }, { "key": "申请中", "value": sqcount }, { "key": "无效", "value": wxcount },
    { "key": "其他", "value": otcount }]
    return { yearcount: yearcount, statuscount: statuscount, nclone: nclone };
  }
  //商标数据
  async tminfosearch(companyName) {
    var obj = {
      applier: companyName,
      type: 0
    }
    var count2014 = 0;
    var count2015 = 0;
    var count2016 = 0;
    var count2017 = 0;
    var count2018 = 0;
    var count2019 = 0;
    var sqcount = 0;
    var yxcount = 0;
    var wxcount = 0;
    var otcount = 0;
    try {
      var yinfo = await this.byTmSearchApi.tmzcraggsSearch(obj);
      var yearsinfo = yinfo.data;
      if(yearsinfo.length>0){
        for (var i = 0; i < yearsinfo.length; i++) {
          if (yearsinfo[i].key == 2014) {
            count2014 = yearsinfo[i].doc_count;
          } else if (yearsinfo[i].key == 2015) {
            count2015 = yearsinfo[i].doc_count;
          } else if (yearsinfo[i].key == 2016) {
            count2016 = yearsinfo[i].doc_count;
          } else if (yearsinfo[i].key == 2017) {
            count2017 = yearsinfo[i].doc_count;
          } else if (yearsinfo[i].key == 2018) {
            count2018 = yearsinfo[i].doc_count;
          } else if (yearsinfo[i].key == 2019) {
            count2019 = yearsinfo[i].doc_count;
          }
        }
        obj.type = 1;
        var sinfo = await this.byTmSearchApi.tmzcraggsSearch(obj);
        var statusall = sinfo.data;
        for (var i = 0; i < statusall.length; i++) {
          if (statusall[i].key == 1) {
            sqcount = statusall[i].doc_count;
          } else if (statusall[i].key == 2 || statusall[i].key == 3) {
            yxcount += statusall[i].doc_count;
          } else if (statusall[i].key == 4) {
            wxcount = statusall[i].doc_count;
          } else {
            otcount = statusall[i].doc_count;
          }
        }
        var yearcount = [{ "key": "2014", "value": count2014 }, { "key": "2015", "value": count2015 }, { "key": "2016", "value": count2016 },
        { "key": "2017", "value": count2017 }, { "key": "2018", "value": count2018 }, { "key": "2019", "value": count2019 }];
        var statuscount = [{ "key": "有效注册", "value": yxcount }, { "key": "申请中", "value": sqcount }, { "key": "无效", "value": wxcount },
        { "key": "其他", "value": otcount }]
        return {
          yearcount: yearcount,
          statuscount: statuscount,
          status: 1
        };
      }
      else{
        return {
          status: 0
        };
      }

    }
    catch (e) {
      //日志记录
      // logCtl.error({
      //   optitle: "商标查询失败-error",
      //   op: "base/service/companyportraitService/tminfosearch",
      //   content: e.stack,
      //   clientIp: ""
      // });
      console.log(e);
      return { status: -1, msg: "操作失败", data: null };
    }
  }

  async patentsearch(obj) {//专利服务
    var applicant = obj.applname == null ? "" : obj.applname;
    if (applicant) {
      var parm = {
        "term": {
          "applicant_name.raw": applicant
        }
      }

      var capilist = [];
      capilist.push(parm);
      var reTypestatistic = [];//专利类型统计
      var empowerlist = [];//专利授权趋势
      var reTitle = [];//专利词云
      var cbuckets = [];
      var tms = await this.GsbByChinaAggApi.KeyWordAggs(capilist);//获取专利词云查询结果;
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        for (var i = 0; i < cbuckets.length; i++) {
          reTitle.push({ name: cbuckets[i].key, value: cbuckets[i].doc_count });
        }
      }

      cbuckets = [];
      tms = await this.GsbByChinaAggApi.PubTypeAggs(capilist);//获取专利类型查询结果
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        for (var i = 0; i < cbuckets.length; i++) {
          reTypestatistic.push({ typename: cbuckets[i].key, value: cbuckets[i].doc_count });
        }

      }
      cbuckets = [];
      tms = await this.GsbByChinaAggApi.GryearAggs(capilist);//专利授权趋势
      if (tms) {
        if (tms.status == 0) {
          if (tms.buckets.types.buckets) {
            cbuckets = tms.buckets.types.buckets;
          }
        }
      }

      if (cbuckets.length > 0) {
        for (var i = 0; i < cbuckets.length; i++) {
          empowerlist.push({ data: cbuckets[i].key, value: cbuckets[i].doc_count });
        }
      }

      return {
        keyword: reTitle,//专利词云
        typestatus: reTypestatistic,//专利类型
        grstatus: empowerlist//专利授权趋势
      }

    }
    else {
      return null;
    }
  }

}
module.exports = companyportraitService;
