const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("sitetheme", {
    siteTheme: {
      //站点主题类型: spring: 春天, summer: 夏天, autumn: 秋天, winter: 冬天
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.site_theme),
      set: function (val) {
        this.setDataValue("siteTheme", val);
        this.setDataValue("siteThemeName", uiconfig.config.pdict.site_theme[val]);
      },
    },
    siteThemeName: {//站点主题名称
      type: DataTypes.STRING,
    },
    isEnabled: {//是否启用，0不启用，1启用，默认为0
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    themeAddr: DataTypes.STRING,//主题路径
    notes: DataTypes.STRING,//备注
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_site_theme',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
