const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("pmquestion", Object.assign({  
    solvTypeName:{
      type:DataTypes.STRING,
      defaultValue: "待解决",
    },
    solvType:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.question_status),
      defaultValue: "waithandle",
      set:function(val){
        this.setDataValue("solvType",val);
        this.setDataValue("solvTypeName",uiconfig.config.pdict.question_status[val]);
      },
    },
    urgentStateName:DataTypes.STRING,
    urgentState:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.urgent_status),
      set:function(val){
        this.setDataValue("urgentState",val);
        this.setDataValue("urgentStateName",uiconfig.config.pdict.urgent_status[val]);
      }
    },
    questionPic: DataTypes.STRING,
    questionSlvPic: DataTypes.STRING,
    solvpath:DataTypes.STRING(255),//
    submemo:DataTypes.STRING(255),//
    memo:DataTypes.STRING(255),//
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'pm_question',
      validate: {
      }
    });
}
