const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
const uuidv4 = require('uuid/v4');
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("companypayparam", Object.assign({
    //基类 code: 公司唯一编码
    //基类 name:  公司名称
    pay_appid: DataTypes.STRING(50),//支付appid
    mch_id: DataTypes.STRING(50),//支付商户号
    pay_key: DataTypes.STRING(50),//支付key
    pay_url: DataTypes.STRING,//支付地址
    payType: {//支付类型1：通联支付、2：中信支付
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    notes: DataTypes.STRING,//备注
    isEnabled: {
      type: DataTypes.BOOLEAN,
      defaultValue: true
    },
    notifyUrl: DataTypes.STRING(500),//通知url
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_company_payparam',
      validate: {
      }
    });
}
