const system = require("../../system");
const Dao = require("../dao.base");
class ReceiptVoucherDao extends Dao {
  constructor() {
    super(Dao.getModelName(ReceiptVoucherDao));
  }
  extraModelFilter() {
    //return {"key":"include","value":[{model:this.db.models.app,},{model:this.db.models.role,as:"Roles",attributes:["id","name"],joinTableAttributes:['created_at']}]};
    return { "key": "include", "value": [{ model: this.db.models.moneyaccount, as: "moneyaccount", attributes: ["name"] }] };
  }
  extraWhere(obj, w) {
    var company_id = w.company_id || "";
    if (company_id) {
      delete w["company_id"];
      w[this.db.Op.or] = [{ company_id: company_id }, { createcompany_id: company_id }];
    }
  }
}
module.exports = ReceiptVoucherDao; 
